<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%--
  -- Page:       placeLocalIndexes.jsp
  -- Controller: db/adm/schm/DataPartitionsController.java
  --
  -- Description: Place Local Indexes options page for data
  --              [sub]partitions during MERGE/ADD/SPLIT/MOVE PMOPs
  --              Launched when appropriate from Place Local Indexes
  --              button on PMOP page [EDIT only]
  --%>
<script language="JavaScript" src="/em/database/LOV.js"></script>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<db:script src="/database/utils.js"/>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<uix:renderingContext id="renderingContext">

  <uix:bundle name="pmsgs"
              class="oracle.sysman.db.rsc.schm.PartitionsMsg"/>
  <uix:bundle name="DBmsgs"
              class="oracle.sysman.db.rsc.DBObjectMsg"/>

  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>
  
  <%-- Browser title.  Page name from controller getPageHeader() --%>
  <%@ include file="/oemTitle.jspf" %>

  <uix:body>

    <%-- HTML Form --%>
    <db:form name="tblForm" 
             method="post"
             destinationBinding="destination@objectBean@servletRequest"
             copyParams="target,type,cancelURL,sname,oname,otype">
      <uix:formValue name="pageName" value="<%= SchemaPages.PARTITIONS_PLACE_IDX_PG %>"/>
        <uix:pageLayout titleBinding="PLACE_INDEXES@pmsgs">
          <%-- Oracle Logo and Tabs --%>
          <%@ include file="/database/global.jspf" %>

          <%-- Warning/Error display --%>
          <oem:messageBox messageType="info" 
                          errorTableBinding="info@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>
          <oem:messageBox messageType="error" 
                          errorTableBinding="errors@servletRequest"
                          titleTextKey="titleText" mainTextKey="mainText"/>


                <!-- CASE: PLACE LOCAL INDEXES operation -->
                <uix:stackLayout>

                  <uix:rowLayout> 
                    <uix:switcher childNameBinding="isParts@dataPartitionsBean@servletRequest">
                      <uix:case name="true">
                        <uix:switcher childNameBinding="canEditOpts@dataPartitionsBean@servletRequest">
                          <uix:case name="true">
                            <uix:styledText styleClass="OraInstructionText"
                                            textBinding="PLACE_IDX_DESC@pmsgs"/>
                          </uix:case>
                          <uix:case name="false">
                            <uix:styledText styleClass="OraInstructionText"
                                            textBinding="PLACE_IDX_V_DESC@pmsgs"/>
                          </uix:case>
                        </uix:switcher>
                      </uix:case>
                      <uix:case name="false">
                        <uix:styledText styleClass="OraInstructionText"
                                        textBinding="SUB_PLACE_IDX_DESC@pmsgs"/> 
                      </uix:case>
                    </uix:switcher>
                  </uix:rowLayout> 

                  <uix:spacer height="10"/>        

                  <oem:table name="placeIndexesUI"
                             beanKey="dataPartitionsBean" 
                             formSubmitted="true" 
                             dataSourceProp="placeIndexesUI" 
                             summaryBinding="INDEX_PARTS@pmsgs"
                             blockSize="10"
                             width="100%" >
                    <uix:tableSelection>
                      <oem:singleSelection shortDescBinding="SELECT@uixDBObjectBundle@servletRequest"
                           selectedIndexBinding="selectedIndex4@dataPartitionsBean@servletRequest">

                        <uix:submitButton textBinding="ADVOPT@pmsgs" 
                                          shortDescBinding="ADVOPT@pmsgs" 
                                          name="event" 
                                          value="advOptionsPLI"/>

                      </oem:singleSelection>
                    </uix:tableSelection>
                  </oem:table>

                  <uix:spacer height="10"/>        
                </uix:stackLayout>


          <uix:pageButtons>
            <uix:pageButtonBar>

	  <%-- CANCEL BUTTON --%>
	    <uix:submitButton textBinding="CANCEL@DBmsgs" 
                          shortDescBinding="CANCEL@DBmsgs" 
			      name="event" 
			      value="cancelPlaceIdx" />

            <%-- OK BUTTON --%>
            <uix:submitButton textBinding="OK@DBmsgs" 
                              shortDescBinding="OK@DBmsgs" 
                              name="event" 
                              value="finishPlaceIdx" />
            </uix:pageButtonBar>
        </uix:pageButtons>
      </uix:pageLayout>
    </db:form>
    <%-- END: HTML Form --%>

  </uix:body>

  </uix:document>
</uix:renderingContext>
<%-- END: Content --%>
