<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%--
  -- Page:        recreateConfirmation.jsp
  -- Controller:  oracle.sysman.db.adm.schm.TableController
  --              oracle.sysman.db.adm.schm.PartitionsWizardController
  -- Description: Confirmation page for recreating all partitions --
  --              clicking Create button after having gone through wizard.
  --
  --  MODIFIED    (MM/DD/YY)
  --     sresrini  03/21/06 - Fix jsp compilation errors
  --     chanchan  10/09/03 - Add ADA supports 
  --     mpawelko  09/25/03 - mpawelko_partition_validation 
  --     mpawelko  09/23/03 - created 
  --%>
<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<%-- Message Bundle --%>
<uix:renderingContext id="renderingContext">
  <uix:bundle name="pmsgs" 
              class="oracle.sysman.db.rsc.schm.PartitionsMsg" />
  <uix:bundle name="DBObjectBundle"
              class="oracle.sysman.db.rsc.DBObjectMsg"/>
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>
 
    <uix:metaContainer>
      <uix:head titleBinding="CONFIRMATION@DBObjectBundle"/>
    </uix:metaContainer>

    <uix:body>
     <db:form name="tblForm"
              method="post"
              destinationBinding="destination@objectBean@servletRequest"
              copyParams="target,type,cancelURL,sname,oname,otype">
       <uix:formValue name="pageName" value="<%= SchemaPages.PARTITIONS_RECREATE_PG %>"/>
         <uix:pageLayout messageType="confirmation">
          
           <!-- for breadcrumbs support; plus standard label, links, tabs, etc -->
           <%@ include file="/database/globalPopup.jspf" %>

           <uix:pageStatus>
             <uix:styledText styleClass="OraDataText" textBinding="RECREATE_WARN@pmsgs" />  
           </uix:pageStatus>

           <uix:spacer height="10"/>

           <uix:styledText styleClass="OraInstructionText" textBinding="CONTINUE_QUESTION@pmsgs" />  


          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:button textBinding="NO@uixDBObjectBundle@servletRequest" 
                          shortDescBinding="NO@uixDBObjectBundle@servletRequest"
                      destination="javascript: history.back()" />
              <uix:submitButton textBinding="YES@uixDBObjectBundle@servletRequest" 
                                shortDescBinding="YES@uixDBObjectBundle@servletRequest"
                                name="event" 
                                value="doLaunchWizard" />
            </uix:pageButtonBar>
          </uix:pageButtons>

        </uix:pageLayout>            
     </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
