<%--
  -- Page:        subpartitionsTable.jsp
  -- Controller:  oracle.sysman.db.adm.schm.TableController
  --              oracle.sysman.db.adm.schm.PartitionsWizardController
  -- Description: Subpartitions table included into partitioning wizard
  --
  --  MODIFIED    (MM/DD/YY)
  --     mpawelko  05/17/05 - fix oac violations 
  --     mpawelko  07/20/04 - use generic LOV field 
  --     chanchan  10/09/03 - Add ADA supports 
  --     mpawelko  08/20/03 - GUI review changes 
  --     mpawelko  08/13/03 - change type to ptype (due to copyparam changes 
  --     rreilly   05/29/03 - add db library
  --     mpawelko  05/19/03 - show Advanced Options on Create
  --     mpawelko  05/02/03 - disable add if DEFAULT
  --     mpawelko  03/26/03 - disable Delete
  --     mpawelko  03/24/03 - Advanced Options not allowed for subpartitions
  --     mpawelko  12/09/02 - Need db tags for LOV fields
  --     jochen    11/22/02 - Fix spacing
  --     jochen    11/19/02 - jochen_partition
  --     jochen    11/18/02 -
  --                          Cloned from dataSubpartitions.jsp
  --     jochen    11/15/02 - Add subpartitions table to create page
  --%>

<script language="JavaScript" src="/em/database/LOV.js"></script>

<%--
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<uix:buildTree nodeID="subpartitionsTable">
--%>

<db:script src="/database/utils.js"/>

  <oem:table name="dataSubpartTemplateUI"
             beanKey="dataPartitionsBean"
             formSubmitted="true"
             summaryBinding="GLOBAL_SUBPART@msgs"
             dataSourceProp="dataSubpartTemplateUI"
             blockSize="10"
             width="100%"
             alternateTextBinding="NO_SPARTS@msgs">

    <uix:tableSelection>
      <oem:singleSelection shortDescBinding="SELECT@uixDBObjectBundle@servletRequest"
            selectedIndexBinding="selectedIndex2@dataPartitionsBean@servletRequest">
            <uix:flowLayout renderedBinding="creating@dataPartitionsBean@servletRequest">
              <uix:submitButton textBinding="INSERT@msgs"
                                shortDescBinding="INSERT@msgs" 
                                name="event"
                                value="insertSubpartition"/>

              <uix:spacer width="5"/>
            </uix:flowLayout>

            <uix:submitButton textBinding="DELETE@msgs"
                              shortDescBinding="DELETE@msgs" 
                              name="event"
                              disabledBinding="disableDelete@dataPartitionsBean@servletRequest"
                              value="deleteSubpartition"/>
      </oem:singleSelection>
    </uix:tableSelection>

    <uix:footer>
          <uix:submitButton textBinding="ADDAS@msgs"
                            shortDescBinding="ADDAS@msgs" 
                            name="event"
                            renderedBinding="canAdd@dataPartitionsBean@servletRequest"
                            value="addSubpartition"/>
    </uix:footer>
  </oem:table>

  <uix:switcher childNameBinding="ptype@partWizardBean@servletRequest">
    <%-- Range-List partitioning --%>
    <uix:case name="4">
        <uix:tip renderedBinding="canUseDef@dataPartitionsBean@servletRequest">
          <uix:styledText styleClass="OraTipText"
                          textBinding="L_DEF_TIP@msgs" />
        </uix:tip>      
    </uix:case>
  </uix:switcher>

<%--
</uix:buildTree>
--%>
