<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<db:script src="/database/utils.js"/>

<script language="javascript">
function setParallel()
{
  if (document.forms[0].parallel != null)
  {
    document.forms[0].parallel.disabled = !document.forms[0].updateIndexes.checked;
    document.forms[0].defaultDegree[0].disabled = (!document.forms[0].parallel.checked || document.forms[0].parallel.disabled);
    document.forms[0].defaultDegree[1].disabled = (!document.forms[0].parallel.checked || document.forms[0].parallel.disabled);
    document.forms[0].degree.disabled = (document.forms[0].defaultDegree[0].checked || document.forms[0].defaultDegree[0].disabled);
  }
}
</script>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<uix:renderingContext id="renderingContext">
     <uix:bundle name="partitionsBundle" 
                 class="oracle.sysman.db.rsc.schm.PartitionsMsg" />
     <uix:bundle name="tableBundle"
                 class="oracle.sysman.db.rsc.schm.TableMsg"/>
     <uix:bundle name="DBObjectBundle"
                 class="oracle.sysman.db.rsc.DBObjectMsg"/>
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>
 
     <uix:metaContainer>
      <uix:head titleBinding="CONFIRMATION@DBObjectBundle"/>
    </uix:metaContainer>

    <uix:body onLoad="setParallel()">
     <db:form name="tblForm"
              method="post"
              destinationBinding="destination@objectBean@servletRequest"
              copyParams="target,type,cancelURL,sname,oname,otype">
     <uix:formValue name="pageName" value="<%= SchemaPages.PARTITIONS_TRUNCATE_PG %>"/>
        <uix:pageLayout messageType="confirmation">
          
          <!-- for breadcrumbs support; plus standard label, links, tabs, etc -->
          <%@ include file="/database/globalPopup.jspf" %>

          <uix:pageStatus>
            <uix:switcher childNameBinding="isParts@dataPartitionsBean@servletRequest">
              <uix:case name="true">
                <uix:styledText styleClass="OraDataText" textBinding="CONFIRM_TRUNCATE_BODY@partitionsBundle" />  
              </uix:case>
              <uix:case name="false">
                <uix:styledText styleClass="OraDataText" textBinding="CONFIRM_SUB_TRUNCATE_BODY@partitionsBundle" />  
              </uix:case>
            </uix:switcher>
          </uix:pageStatus>

          <uix:spacer height="10"/>

          <uix:switcher childNameBinding="isParts@dataPartitionsBean@servletRequest">
            <uix:case name="true">
              <uix:styledText styleClass="OraInstructionText" textBinding="truncateText@dataPartitionsBean@servletRequest" />  
            </uix:case>
            <uix:case name="false">
              <uix:styledText styleClass="OraInstructionText" textBinding="subTruncateText@dataPartitionsBean@servletRequest" />  
            </uix:case>
          </uix:switcher>

          <%-- Include PMOP OPTIONS --%>
          <uix:switcher childNameBinding="isIOT@dataPartitionsBean@servletRequest">
            <uix:case name="false">
              <jsp:include page="/database/schema/partitions/dataPMOPOpt.jsp"/>
              <uix:ref refID="dataPMOPOpt"/>
            </uix:case>              
          </uix:switcher>              

          <uix:spacer height="20"/>

          <%-- Tip --%>
          <uix:tip>
            <uix:styledText styleClass="OraTipText"
                            textBinding="CONFIRM_TIP@partitionsBundle" />
          </uix:tip>

          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:button textBinding="NO@uixDBObjectBundle@servletRequest" 
                          shortDescBinding="NO@uixDBObjectBundle@servletRequest"
                          destination="javascript: history.back()" />
              <uix:submitButton textBinding="YES@uixDBObjectBundle@servletRequest" 
                                shortDescBinding="YES@uixDBObjectBundle@servletRequest"
                                name="event" 
                                value="doTruncatePartition" />
            </uix:pageButtonBar>
          </uix:pageButtons>

        </uix:pageLayout>
            
     </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
