<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%--
  -- Page:        wizMethod.jsp
  -- Controller:  oracle.sysman.db.adm.schm.TableController
  --              oracle.sysman.db.adm.schm.PartitionsWizardController
  -- Description: Loader page into the partition creation wizard.  User can
  --              select the partitioning method.  This is not part of the
  --              wizard since wizards are only allowed to skip one step
  --              in a train, so we need to pre-load partitioning method.
  --
  --  MODIFIED    (MM/DD/YY)
  --     mpawelko  12/04/03 - remove references to selectedType 
  --     chanchan  10/08/03 - Add ADA supports 
  --     mpawelko  09/20/03 - add logged in as msg 
  --     mpawelko  08/19/03 - remove contents tags 
  --     hsu       07/25/03 - change global
  --     mpawelko  06/10/03 - need to rename type parameter due to database type
  --     rreilly   06/06/03 - find why copy params fails
  --     rreilly   05/29/03 - add copyparams
  --     rreilly   05/21/03 - db:form to db:form
  --     qsong     04/29/03 - Add oemTop.jspf
  --     mnihalan  01/20/03 - Change the page header
  --     jochen    01/02/03 - No list if < 9i.  No range-list if < 9iRel2
  --     jochen    12/23/02 - DB version check for list part
  --     jochen    12/17/02 - Support IOT
  --     jochen    12/02/02 - Duplicate page buttons
  --     jochen    11/19/02 - jochen_partition
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>
<%@ page import="oracle.sysman.emo.adm.schema.partitions.DataPartitionsAttributes" %>
<%@ page import="oracle.sysman.db.adm.schm.PartitionsWizardController" %>

<%-- Message Bundle --%>
<uix:renderingContext id="renderingContext">
  <uix:bundle name="msgs"
              class="oracle.sysman.db.rsc.schm.PartitionsMsg"/>
  <uix:bundle name="sdkMsgs"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
<oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%-- Browser title.  Page name from controller getPageHeader() --%>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>

      <%-- HTML Form --%>
      <%-- copyParams="target,type,cancelURL,sname,oname,otype" --%>
      <db:form name="tblForm"
               method="post"
               destinationBinding="destination@objectBean@servletRequest" 
               copyParams="target,type,cancelURL,sname,oname,otype" >

        <uix:formValue name="pageName" value="<%= SchemaPages.PART_WIZ_METHOD_PG %>"/>

        <uix:pageLayout titleBinding="pageHeader@partWizardBean@servletRequest">
          <%-- Oracle Logo and Tabs, breadcrumb data from --%>
          <%-- controller getNavigatorPath()              --%>
          <%@ include file="/database/global.jspf" %>

          <%-- Cancel and Continue buttons --%>
          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:submitButton textBinding="CANCEL@sdkMsgs"
                                shortDescBinding="CANCEL@sdkMsgs"
                                name="event"
                                value="<%= PartitionsWizardController.S_CANCEL_EVENT %>" />
              <uix:submitButton textBinding="CONTINUE@sdkMsgs"
                                shortDescBinding="CONTINUE@sdkMsgs"
                                name="event"
                                value="<%= PartitionsWizardController.S_GOTO_COLS_EVENT %>" />
            </uix:pageButtonBar>
          </uix:pageButtons>

          <uix:pageStatus>
            <%@ include file="/database/sqlaccess/wizContext.jspf" %> 
          </uix:pageStatus>
          <%-- Follow page/wizard context information with a separator --%>
          <uix:separator/>

            <uix:stackLayout>
              <uix:separator>
                <uix:spacer height="3"/>
              </uix:separator>

              <%-- Instructional text --%>
              <uix:styledText textBinding="METHOD_INSTR@msgs"
                              styleClass="OraInstructionText"/>

                <uix:rowLayout>
                  <uix:spacer width="10"/>

                  <%--               --%>
                  <%-- Radio buttons --%>
                  <%--               --%>
                  <uix:stackLayout>
                    <uix:separator>
                      <uix:spacer width="3" height="2"/>
                    </uix:separator>

                      <%-- Range --%>
                      <uix:stackLayout>
                        <uix:radioButton textBinding="RANGE@msgs"
                                          name="ptype"
                                          selected="true"
                                          value="<%= DataPartitionsAttributes.RANGE_PARTITION %>" />
                        <uix:rowLayout>
                          <uix:spacer width="20"/>
                          <uix:styledText textBinding="RDESC@msgs"
                                          styleClass="OraInlineInfoText"/>
                        </uix:rowLayout>
                      </uix:stackLayout>


                      <%-- Hash --%>
                      <uix:stackLayout>
                        <uix:radioButton textBinding="HASH@msgs"
                                          name="ptype"
                                          value="<%= DataPartitionsAttributes.HASH_PARTITION %>" />
                        <uix:rowLayout>
                          <uix:spacer width="20"/>
                          <uix:styledText textBinding="HDESC@msgs"
                                          styleClass="OraInlineInfoText"/>
                        </uix:rowLayout>
                      </uix:stackLayout>

                      <%-- List --%>
                      <uix:stackLayout renderedBinding="supportsList@dataPartitionsBean@servletRequest">
                        <uix:radioButton textBinding="LIST@msgs"
                                          name="ptype"
                                          value="<%= DataPartitionsAttributes.LIST_PARTITION %>" />
                        <uix:rowLayout>
                          <uix:spacer width="20"/>
                          <uix:styledText textBinding="LDESC@msgs"
                                          styleClass="OraInlineInfoText"/>
                        </uix:rowLayout>
                      </uix:stackLayout>

                      <%-- Range-Hash --%>
                      <uix:stackLayout renderedBinding="isNotIOT@dataPartitionsBean@servletRequest">
                        <uix:radioButton textBinding="RANGEHASH@msgs"
                                          name="ptype"
                                          value="<%= DataPartitionsAttributes.RANGE_HASH_PARTITION %>" />
                        <uix:rowLayout>
                          <uix:spacer width="20"/>
                          <uix:styledText textBinding="RHDESC@msgs"
                                          styleClass="OraInlineInfoText"/>
                        </uix:rowLayout>
                      </uix:stackLayout>

                      <%-- Range-List --%>
                      <uix:stackLayout renderedBinding="supportsRangeList@dataPartitionsBean@servletRequest">
                        <uix:radioButton textBinding="RANGELIST@msgs"
                                          name="ptype"
                                          value="<%= DataPartitionsAttributes.RANGE_LIST_PARTITION %>" />
                        <uix:rowLayout>
                          <uix:spacer width="20"/>
                          <uix:styledText textBinding="RLDESC@msgs"
                                          styleClass="OraInlineInfoText"/>
                        </uix:rowLayout>
                      </uix:stackLayout>

                  </uix:stackLayout>
                </uix:rowLayout>
            </uix:stackLayout>
        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
