<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%--
  -- Page:        wizMultiCol.jsp
  -- Controller:  oracle.sysman.db.adm.schm.TableController
  --              oracle.sysman.db.adm.schm.PartitionsWizardController
  -- Description: Partitioning column selection page for those partitioning methods
  --              that allow more than one partitioning column.
  --
  --  MODIFIED    (MM/DD/YY)
  --     chanchan  10/08/03 - Add ADA supports 
  --     mpawelko  09/19/03 - add validation 
  --     mpawelko  08/19/03 - GUI review changes 
  --     mpawelko  08/13/03 - change type to ptype (due to copyparam changes 
  --     hsu       07/25/03 - change global
  --     rreilly   05/21/03 - db:form to db:form
  --     qsong     04/29/03 - Add oemTop.jspf
  --     mnihalan  01/20/03 - Change the page header
  --     jochen    12/17/02 - Fix spacing
  --     jochen    12/04/02 - Add error box
  --     jochen    12/02/02 - Duplicate page buttons
  --     jochen    11/19/02 - jochen_partition
  --     jochen    11/15/02 - Handle subpartitions
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>
<%@ page import="oracle.sysman.db.adm.schm.PartitionsWizardController" %>
<%@ page import="oracle.sysman.emo.adm.schema.partitions.WizardConstants" %>

<%-- Message Bundle --%>
<uix:renderingContext id="renderingContext">
  <uix:bundle name="msgs"
              class="oracle.sysman.db.rsc.schm.PartitionsMsg"/>
  <uix:bundle name="sdkMsgs"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
<oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%-- Browser title.  Page name from controller getPageHeader() --%>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>

      <%-- HTML Form --%>
      <db:form name="tblForm" 
               method="post"
               destinationBinding="destination@objectBean@servletRequest"
               copyParams="target,type,cancelURL,sname,oname,otype">
        <uix:formValue name="pageName" value="<%= SchemaPages.PART_WIZ_MULTI_COLS_PG %>"/>

        <uix:pageLayout titleBinding="pageHeader@partWizardBean@servletRequest">

          <%-- Oracle Logo and Tabs, breadcrumb data from --%>
          <%-- controller getNavigatorPath()              --%>
          <%@ include file="/database/global.jspf" %>

          <%-- Train --%>
          <uix:location>
            <jsp:include page="wizTrain.jsp" />
            <uix:ref refID="wizTrain" />
          </uix:location>

          <uix:pageStatus>
            <%@ include file="/database/sqlaccess/wizContext.jspf" %> 
          </uix:pageStatus>
          <%-- Follow page/wizard context information with a separator --%>
          <uix:separator/>

          <%-- Warning/Error display --%>
          <uix:messages>
            <oem:messageBox messageType="error"
                            errorTableBinding="errors@servletRequest"
                            titleTextKey="titleText" mainTextKey="mainText"/>
          </uix:messages>

          <%-- Navigation buttons --%>
          <jsp:include page="wizNavButtons.jsp" />
          <uix:pageButtons>
            <uix:ref refID="wizNavButtons" />
          </uix:pageButtons>

          <%--                    --%>
          <%-- Instructional text --%>
          <%--                    --%>
            <uix:stackLayout>
              <uix:switcher childNameBinding="ptype@partWizardBean@servletRequest">
                <%-- Hash partitioning --%>
                <uix:case name="1">
                  <uix:styledText textBinding="MULTICOLS_HASH_INSTR@msgs"
                                  styleClass="OraInstructionText"/>
                </uix:case>
                <uix:default>
                  <uix:styledText textBinding="MULTICOLS_RANGE_INSTR@msgs"
                                  styleClass="OraInstructionText"/>
                </uix:default>
              </uix:switcher>
              <uix:spacer height="5"/>
            </uix:stackLayout>

            <uix:stackLayout>

                <%--               --%>
                <%-- columns table --%>
                <%--               --%>
                <uix:dataScope currentDataBinding="partWizMultiColBean@servletRequest">
                  <jsp:include page="wizMultiColInclude.jsp" />
                  <uix:ref refID="wizMultiCol" />
                </uix:dataScope>

            </uix:stackLayout>
        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
