<%--
  -- Include:     wizMultiColInclude.jspf
  -- Controller:  db/adm/schm/PartitionsWizardController.java
  --
  -- Description: Included table to select columns for partitioning methods
  --              that allow multiple partitioning columns
  --
  --  MODIFIED    (MM/DD/YY)
  --     chanchan  05/12/05 - Fix ADA issues 
  --     chanchan  10/08/03 - Add ADA supports 
  --     mpawelko  09/19/03 - add validation 
  --     mpawelko  08/27/03 - GUI review changes 
  --     mpawelko  08/19/03 - GUI review changes 
  --     rreilly   05/29/03 - add db library
  --     jochen    11/19/02 - jochen_partition
  --     jochen    11/15/02 - handle subpartitions
  --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ page import="oracle.sysman.emo.adm.schema.partitions.WizardConstants" %>

<uix:buildTree nodeID="wizMultiCol">

  <uix:table name="multiColTable"
             width="80%"
             tableDataBinding="multiCols@"
             formSubmitted="true"
             maxValueBinding="numCols@"
             blockSize="10"
             summaryBinding="COLNAME@msgs"
             valueBinding="startIndex@">

    <%-- Table column name column --%>
    <uix:column>
      <uix:columnHeader>
        <uix:styledText textBinding="COLNAME@msgs"/>
      </uix:columnHeader>
      <uix:columnFormat columnDataFormat="textFormat"/>
      <uix:contents>
        <uix:styledText textBinding="<%= WizardConstants.S_NAME_ATTR %>"/>
      </uix:contents>
    </uix:column>

    <%-- Column datatype column --%>
    <uix:column>
      <uix:columnHeader>
        <uix:styledText textBinding="DATATYPE@msgs"/>
      </uix:columnHeader>
      <uix:columnFormat columnDataFormat="textFormat"/>
      <uix:contents>
        <uix:styledText textBinding="<%= WizardConstants.S_DATATYPE_ATTR %>"/>
      </uix:contents>
    </uix:column>

    <%-- Order column --%>
    <uix:column>
      <uix:columnHeader>
        <uix:styledText textBinding="ORDER@msgs"/>
      </uix:columnHeader>
      <uix:columnFormat columnDataFormat="textFormat"/>
      <uix:contents>
        <uix:textInput columns="7" shortDescBinding="ORDER@msgs"
                        name="orderAttr"
                        textBinding="<%= WizardConstants.S_ORDER_ATTR %>">
          <uix:onSubmitValidater>
            <uix:decimal />
          </uix:onSubmitValidater>
        </uix:textInput/>
      </uix:contents>
    </uix:column>

  </uix:table>
</uix:buildTree>
