<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%--
  -- Page:        wizPartDesc.jsp
  -- Controller:  oracle.sysman.db.adm.schm.TableController
  --              oracle.sysman.db.adm.schm.PartitionsWizardController
  -- Description: Partioning wizard page - partitioning description page
  --              Lets the user specify the details of each partition
  --
  --  MODIFIED    (MM/DD/YY)
  --     mpawelko  04/14/04 - Bug 3565227: get date example from backend 
  --     mpawelko  09/20/03 - add logged in as msg 
  --     mpawelko  08/19/03 - GUI review changes 
  --     mpawelko  08/13/03 - change type to ptype (due to copyparam changes 
  --     hsu       07/25/03 - change global
  --     rreilly   05/21/03 - db:form to db:form
  --     mpawelko  04/30/03 - display date tip only if there are dates
  --     qsong     04/29/03 - Add oemTop.jspf
  --     mnihalan  01/20/03 - Change the page header
  --     jochen    12/02/02 - Duplicate page buttons
  --     jochen    11/19/02 - jochen_partition
  --              Cloned from dataPartitionsR.jsp
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>
<%@ page import="oracle.sysman.db.adm.schm.PartitionsWizardController" %>
<%@ page import="oracle.sysman.emo.adm.schema.partitions.WizardConstants" %>

<%-- Message Bundle --%>
<uix:renderingContext id="renderingContext">
  <uix:bundle name="msgs"
              class="oracle.sysman.db.rsc.schm.PartitionsMsg"/>
  <uix:bundle name="sdkMsgs"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
<oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%-- Browser title.  Page name from controller getPageHeader() --%>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>

      <%-- HTML Form --%>
      <db:form name="tblForm" 
               method="post"
               destinationBinding="destination@objectBean@servletRequest"
               copyParams="target,type,cancelURL,sname,oname,otype">
        <uix:formValue name="pageName" value="<%= SchemaPages.PART_WIZ_PART_DESC_PG %>"/>

        <uix:pageLayout titleBinding="pageHeader@partWizardBean@servletRequest">

          <%-- Oracle Logo and Tabs, breadcrumb data from --%>
          <%-- controller getNavigatorPath()              --%>
          <%@ include file="/database/global.jspf" %>

          <%-- Train --%>
          <uix:location>
            <jsp:include page="wizTrain.jsp" />
            <uix:ref refID="wizTrain" />
          </uix:location>

          <uix:pageStatus>
            <%@ include file="/database/sqlaccess/wizContext.jspf" %> 
          </uix:pageStatus>
          <%-- Follow page/wizard context information with a separator --%>
          <uix:separator/>

          <%-- Warning/Error display --%>
          <uix:messages> 
            <oem:messageBox messageType="error"
                            errorTableBinding="errors@servletRequest"
                            titleTextKey="titleText" mainTextKey="mainText"/>
          </uix:messages>

          <%-- Navigation buttons --%>
          <jsp:include page="wizNavButtons.jsp" />
          <uix:pageButtons>
              <uix:ref refID="wizNavButtons" />
          </uix:pageButtons>

          <%-- <uix:pageStatus> --%>
            <uix:stackLayout>
              <%--                    --%>
              <%-- Instructional text --%>
              <%--                    --%>
              <uix:switcher childNameBinding="ptype@partWizardBean@servletRequest">
                <%-- Hash partitioning --%>
                <uix:case name="1">
                  <uix:spacer width="1" height="25"/>
                </uix:case>

                <%-- List partitioning --%>
                <uix:case name="2">
                  <uix:stackLayout>
                    <uix:separator>
                      <uix:spacer height="5"/>
                    </uix:separator>
                    <uix:styledText textBinding="LVDESC@msgs"
                                    styleClass="OraInstructionText"/>
                    <%--                  --%>
                    <%-- Date format tip  --%>
                    <%--                  --%>
                    <uix:styledText renderedBinding="hasDate@partitionColsBean@servletRequest"
                                    textBinding="dateExample@partWizardBean@servletRequest"
                                    styleClass="OraInlineInfoText"/>
                    <uix:spacer height="5"/>
                  </uix:stackLayout>
                </uix:case>

                <%-- Range, range-hash, range-list --%>
                <uix:default>
                  <uix:stackLayout>
                    <uix:separator>
                      <uix:spacer height="5"/>
                    </uix:separator>
                      <uix:styledText textBinding="RHVDESC@msgs"
                                      styleClass="OraInstructionText"/>
                      <%--                  --%>
                      <%-- Date format tip  --%>
                      <%--                  --%>
                      <uix:styledText renderedBinding="hasDate@partitionColsBean@servletRequest"
                                      textBinding="dateExample@partWizardBean@servletRequest"
                                      styleClass="OraInlineInfoText"/>
                  </uix:stackLayout>
                </uix:default>
              </uix:switcher>
              <uix:spacer height="5"/>
            </uix:stackLayout>
          <%-- </uix:pageStatus> --%>

            <uix:stackLayout>

              <uix:separator>
                <uix:spacer height="7"/>
              </uix:separator>

              <%--                  --%>
              <%-- Partitions table --%>
              <%--                  --%>
              <jsp:include page="partitionsTable.jsp" />
              <uix:ref refID="partitionsTable" />

            </uix:stackLayout>
        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
