<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%--
  -- Page:        wizPartSpec.jsp
  -- Controller:  oracle.sysman.db.adm.schm.TableController
  --              oracle.sysman.db.adm.schm.PartitionsWizardController
  -- Description: Partioning wizard page - lets the user select the
  --              number of partitions and the tablespaces to use.
  --
  --  MODIFIED    (MM/DD/YY)
  --     mpawelko  04/15/04 - 
  --     mpawelko  04/14/04 - Bug 3565227: get date tip from backend 
  --     chanchan  10/08/03 - Add ADA supports 
  --     mpawelko  09/20/03 - add logged in as msg 
  --     mpawelko  07/21/03 - move/simplify tablespace choices
  --     rreilly   05/21/03 - db:form to db:form
  --     mpawelko  04/29/03 - add power of 2 tip for hash partitions
  --     qsong     04/29/03 - Add oemTop.jspf
  --     mpawelko  04/07/03 - make lov fields active only when radio button checked
  --     mpawelko  04/04/03 - change tablespace options
  --     mnihalan  01/20/03 - Change the page header
  --     chanchan  01/15/03 - Set relative url
  --     jochen    12/30/02 - Tablespace validation
  --     cchan     01/02/03 - Added uix:messageLovField support
  --     jochen    12/26/02 - Add error box
  --     jochen    12/17/02 - Support IOT
  --     jochen    12/04/02 - Input fields shouldn't be required so cancel works
  --     jochen    11/26/02 - Make round-robin list an LOV
  --     jochen    11/21/02 - Change label on number of partitions
  --     jochen    11/19/02 - jochen_partition
  --     jochen    11/15/02 - handle subpartitions
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>


<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>
<%@ page import="oracle.sysman.db.adm.schm.PartitionsWizardController" %>
<%@ page import="oracle.sysman.emo.adm.schema.partitions.WizardConstants" %>

<%-- Message Bundle --%>
<uix:renderingContext id="renderingContext">
  <uix:bundle name="msgs"
              class="oracle.sysman.db.rsc.schm.PartitionsMsg"/>
  <uix:bundle name="sdkMsgs"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
<oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%-- Browser title.  Page name from controller getPageHeader() --%>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>

      <%-- HTML Form --%>
      <db:form name="tblForm" 
               method="post"
               destinationBinding="destination@objectBean@servletRequest"
               copyParams="target,type,cancelURL,sname,oname,otype">
        <uix:formValue name="pageName" value="<%= SchemaPages.PART_WIZ_PART_SPEC_PG %>"/>

        <uix:pageLayout titleBinding="pageHeader@partWizardBean@servletRequest">
          <%-- Oracle Logo and Tabs, breadcrumb data from --%>
          <%-- controller getNavigatorPath()              --%>
          <%@ include file="/oemGlobal.jspf" %>

          <%-- Train --%>
          <uix:location>
            <jsp:include page="wizTrain.jsp" />
            <uix:ref refID="wizTrain" />
          </uix:location>

          <uix:pageStatus>
            <%@ include file="/database/sqlaccess/wizContext.jspf" %> 
          </uix:pageStatus>
          <%-- Follow page/wizard context information with a separator --%>
          <uix:separator/>

          <%-- Warning/Error display --%>
          <uix:messages> 
            <oem:messageBox messageType="error"
                            errorTableBinding="errors@servletRequest"
                            titleTextKey="titleText" mainTextKey="mainText"/>
          </uix:messages>

          <%-- Navigation buttons --%>
          <jsp:include page="wizNavButtons.jsp" />
          <uix:pageButtons>
            <uix:ref refID="wizNavButtons" />
          </uix:pageButtons>

            <uix:stackLayout>
              <uix:separator>
                <uix:spacer height="5"/>
              </uix:separator>

                <%--                                --%>
                <%-- Number of partitions input box --%>
                <%--                                --%>
                <uix:rowLayout>
                  <uix:messagePrompt required="uiOnly"
                                     promptBinding="ADD_PARTS@msgs"
                                     labeledNodeId="initialNumParts"/>
                  <uix:spacer width="5"/>
                    <uix:stackLayout>
                      <uix:textInput name="initialNumParts"
                                     id="initialNumParts" shortDescBinding="ADD_PARTS@msgs"
                                     textBinding="initialNumParts@partWizardBean@servletRequest"
                                     required="uiOnly"
                                     columns="5">
                        <uix:onSubmitValidater>
                          <uix:decimal />
                        </uix:onSubmitValidater>
                      </uix:textInput>
                      <uix:messageText messageType="error"
                                       messageBinding="initialNumParts@errors@servletRequest" />
                   </uix:stackLayout>
                  </uix:rowLayout>

                  <uix:rowLayout>
                    <uix:stackLayout renderedBinding="isHash@dataPartitionsBean@servletRequest">	
                      <uix:spacer height="10"/>
                        <uix:tip>
                          <uix:styledText textBinding="PSPEC_HASH_HINT@msgs"
                                          styleClass="OraTipText"/>
                        </uix:tip>
                   </uix:stackLayout>
                  </uix:rowLayout>


                <uix:spacer height="5"/>

                <%--          --%>
                <%-- MAXVALUE --%>
                <%--          --%>
                <uix:stackLayout
                     renderedBinding="canAutogen@partWizardBean@servletRequest">
                  <uix:checkBox textBinding="PSPEC_MAX@msgs"
                                name="automax"
                                checkedBinding="automax@partWizardBean@servletRequest"/>
                  <uix:rowLayout>
                    <uix:spacer width="20"/>
                    <uix:styledText styleClass="OraInlineInfoText"
                                    textBinding="PSPEC_MAX_HINT@msgs"/>
                  </uix:rowLayout>
                </uix:stackLayout>

                <%--          --%>
                <%-- DEFAULT  --%>
                <%--          --%>
                <uix:switcher childNameBinding="ptype@partWizardBean@servletRequest">
                  <%-- List partitioning --%>
                  <uix:case name="2">

                    <uix:stackLayout
                       renderedBinding="is92@dataPartitionsBean@servletRequest">
                      <uix:checkBox textBinding="PSPEC_DEF@msgs"
                                    name="autodef"
                                    checkedBinding="autodef@partWizardBean@servletRequest"/>
                      <uix:rowLayout>
                        <uix:spacer width="20"/>
                        <uix:styledText styleClass="OraInlineInfoText"
                                        textBinding="PSPEC_DEF_HINT@msgs"/>
                      </uix:rowLayout>
                    </uix:stackLayout>
                  </uix:case>
                </uix:switcher>


                <%--         --%>
                <%-- Autogen --%>
                <%--         --%>
                <uix:header textBinding="PSPEC_AUTO_HDR@msgs"
                            renderedBinding="canAutogen@partWizardBean@servletRequest">

                <uix:stackLayout>
                <uix:spacer height="5"/>

<%--
                                onClick="submitForm('tblForm', true, {event:'changeTablespaceSel'})"
--%>

                  <uix:checkBox textBinding="PSPEC_AUTO@msgs"
                                name="autogen"
                                checkedBinding="autogen@partWizardBean@servletRequest"
                                disabledBinding="autogenDisabled@partWizardBean@servletRequest"/>

                  <uix:rowLayout>
                    <uix:spacer width="20"/>
                    <uix:stackLayout>
                      <uix:styledText styleClass="OraInlineInfoText"
                                      textBinding="PSPEC_AUTO_HINT@msgs"/>
                    </uix:stackLayout>
                  </uix:rowLayout>


          <uix:stackLayout renderedBinding="autogenNotDisabled@partWizardBean@servletRequest">
            <uix:separator>
              <uix:spacer height="5"/>
            </uix:separator>

            <%--              --%>
            <%-- Input fields --%>
            <%--              --%>
            <uix:dataScope currentDataBinding="partWizMultiColBean@servletRequest">
              <uix:include nodeBinding="autogenFields@partWizMultiColBean@servletRequest"/>
            </uix:dataScope>

                  <uix:spacer height="5"/>

            <uix:switcher childNameBinding="hasDate@partitionColsBean@servletRequest">
              <uix:case name="true">	
                <uix:tip>
                  <uix:styledText textBinding="dateRangeTip@dataPartitionsBean@servletRequest"
                                  styleClass="OraTipText"/>
                </uix:tip>
              </uix:case>
              <uix:case name="false">	
                <uix:tip>
                  <uix:styledText textBinding="PSPEC_AUTO_TIP1@msgs"
                                  styleClass="OraTipText"/>
                </uix:tip>
              </uix:case>
            </uix:switcher>


                  <uix:spacer height="5"/>
                  <uix:tip>
                    <uix:styledText textBinding="PSPEC_AG_HINT@msgs"
                                    styleClass="OraTipText"/>
                  </uix:tip>

               </uix:stackLayout>
               </uix:stackLayout>
              </uix:header>

            </uix:stackLayout>
        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
