<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%--
  -- Page:        wizSingleCol.jsp
  -- Controller:  oracle.sysman.db.adm.schm.TableController
  --              oracle.sysman.db.adm.schm.PartitionsWizardController
  -- Description: Partitioning column selection page for those partitioning methods
  --              that allow more than one partitioning column.
  --
  --  MODIFIED    (MM/DD/YY)
  --     chanchan  05/12/05 - Fix ADA issues 
  --     chanchan  10/09/03 - Add ADA supports 
  --     mpawelko  09/20/03 - add logged in as msg 
  --     mpawelko  08/19/03 - GUI review changes 
  --     hsu       07/25/03 - change global
  --     rreilly   05/21/03 - db:form to db:form
  --     qsong     04/29/03 - Add oemTop.jspf
  --     mnihalan  01/20/03 - Change the page header
  --     jochen    12/02/02 - Duplicate page buttons
  --     jochen    11/19/02 - jochen_partition
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>
<%@ page import="oracle.sysman.db.adm.schm.PartitionsWizardController" %>
<%@ page import="oracle.sysman.emo.adm.schema.partitions.WizardConstants" %>

<%-- Message Bundle --%>
<uix:renderingContext id="renderingContext">
  <uix:bundle name="msgs"
              class="oracle.sysman.db.rsc.schm.PartitionsMsg"/>
  <uix:bundle name="sdkMsgs"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
<oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%-- Browser title.  Page name from controller getPageHeader() --%>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>

      <%-- HTML Form --%>
      <db:form name="tblForm" 
               method="post"
               destinationBinding="destination@objectBean@servletRequest"
               copyParams="target,type,cancelURL,sname,oname,otype">
        <uix:formValue name="pageName" value="<%= SchemaPages.PART_WIZ_SINGLE_COL_PG %>"/>

        <uix:pageLayout titleBinding="pageHeader@partWizardBean@servletRequest">
          <%-- Oracle Logo and Tabs, breadcrumb data from --%>
          <%-- controller getNavigatorPath()              --%>
          <%@ include file="/database/global.jspf" %>

          <%-- Train --%>
          <uix:location>
            <jsp:include page="wizTrain.jsp" />
            <uix:ref refID="wizTrain" />
          </uix:location>

          <%-- Navigation buttons --%>
          <jsp:include page="wizNavButtons.jsp" />
          <uix:pageButtons>
            <uix:ref refID="wizNavButtons" />
          </uix:pageButtons>

          <uix:pageStatus>
            <%@ include file="/database/sqlaccess/wizContext.jspf" %> 
          </uix:pageStatus>
          <%-- Follow page/wizard context information with a separator --%>
          <uix:separator/>

            <uix:stackLayout>
              <uix:separator>
                <uix:spacer height="5"/>
              </uix:separator>

              <%--                    --%>
              <%-- Instructional text --%>
              <%--                    --%>
              <uix:styledText textBinding="HCOLS@msgs"
                              styleClass="OraInstructionText"/>

                <%--               --%>
                <%-- columns table --%>
                <%--               --%>
                <uix:table name="singleColTable"
                           width="80%"
                           tableDataBinding="multiCols@partWizMultiColBean@servletRequest"
                           formSubmitted="true"
                           maxValueBinding="numCols@partWizMultiColBean@servletRequest"
                           blockSize="10"
                           summaryBinding="HCOLS@msgs"
                           valueBinding="startIndex@partWizMultiColBean@servletRequest">

                  <uix:tableSelection>
                    <uix:singleSelection selectedIndexBinding="singleSelectCol@partWizMultiColBean@servletRequest" shortDescBinding="SELECT@uixDBObjectBundle@servletRequest"/>
                  </uix:tableSelection>

                  <%-- Table column name column --%>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:styledText textBinding="COLNAME@msgs"/>
                    </uix:columnHeader>
                    <uix:columnFormat columnDataFormat="textFormat"/>
                      <uix:styledText textBinding="<%= WizardConstants.S_NAME_ATTR %>"/>
                  </uix:column>

                  <%-- Column datatype column --%>
                  <uix:column>
                    <uix:columnHeader>
                      <uix:styledText textBinding="DATATYPE@msgs"/>
                    </uix:columnHeader>
                    <uix:columnFormat columnDataFormat="textFormat"/>
                      <uix:styledText textBinding="<%= WizardConstants.S_DATATYPE_ATTR %>"/>
                  </uix:column>

                </uix:table>
            </uix:stackLayout>
        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
