<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%--
  -- Page:        wizPartDesc.jsp
  -- Controller:  oracle.sysman.db.adm.schm.TableController
  --              oracle.sysman.db.adm.schm.PartitionsWizardController
  -- Description: Partioning wizard page - partitioning description page
  --              Lets the user specify the details of each partition
  --
  --  MODIFIED    (MM/DD/YY)
  --     mpawelko  09/20/03 - add logged in as msg 
  --     mpawelko  09/01/03 - GUI review changes 
  --     mpawelko  08/19/03 - GUI review changes 
  --     hsu       07/25/03 - change global
  --     rreilly   05/29/03 - remove duplicate tag library calls
  --     rreilly   05/21/03 - db:form to db:form
  --     mpawelko  05/02/03 - 
  --     qsong     04/29/03 - Add oemTop.jspf
  --     mnihalan  01/20/03 - Change the page header
  --     jochen    12/02/02 - Duplicate page buttons
  --     jochen    11/19/02 - jochen_partition
  --     jochen    11/18/02 -
  --              Cloned from dataPartitionsR.jsp
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>
<%@ page import="oracle.sysman.db.adm.schm.PartitionsWizardController" %>
<%@ page import="oracle.sysman.emo.adm.schema.partitions.WizardConstants" %>

<%-- Message Bundle --%>
<uix:renderingContext id="renderingContext">
  <uix:bundle name="msgs"
              class="oracle.sysman.db.rsc.schm.PartitionsMsg"/>
  <uix:bundle name="sdkMsgs"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
<oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%-- Browser title.  Page name from controller getPageHeader() --%>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>

      <%-- HTML Form --%>
      <db:form name="tblForm" 
               method="post" 
               destinationBinding="destination@objectBean@servletRequest"
               copyParams="target,type,cancelURL,sname,oname,otype">
        <uix:formValue name="pageName" value="<%= SchemaPages.PART_WIZ_SUBPART_DESC_PG %>"/>

        <uix:pageLayout titleBinding="pageHeader@partWizardBean@servletRequest">

          <%-- Oracle Logo and Tabs, breadcrumb data from --%>
          <%-- controller getNavigatorPath()              --%>
          <%@ include file="/database/global.jspf" %>

          <%-- Train --%>
          <uix:location>
            <jsp:include page="wizTrain.jsp" />
            <uix:ref refID="wizTrain" />
          </uix:location>

         <%-- Warning/Error display --%>
          <uix:messages> 
            <oem:messageBox messageType="error"
                            errorTableBinding="errors@servletRequest"
                            titleTextKey="titleText" mainTextKey="mainText"/>
          </uix:messages>

          <%-- Navigation buttons --%>
          <jsp:include page="wizNavButtons.jsp" />
          <uix:pageButtons>
            <uix:stackLayout>
              <uix:ref refID="wizNavButtons" />
              <uix:spacer height="2"/>
            </uix:stackLayout>
          </uix:pageButtons>

          <uix:pageStatus>
            <%@ include file="/database/sqlaccess/wizContext.jspf" %> 
          </uix:pageStatus>
          <%-- Follow page/wizard context information with a separator --%>
          <uix:separator/>


            <%--                    --%>
            <%-- Instructional text --%>
            <%--                    --%>
            <uix:styledText textBinding="SUBTEMPDESC@msgs"
                            styleClass="OraInstructionText"/>

            <uix:stackLayout>

              <uix:spacer height="5"/>

              <uix:separator>
                <uix:spacer height="5"/>
              </uix:separator>

              <%--                    --%>
              <%-- Instructional text --%>
              <%--                    --%>
              <uix:switcher childNameBinding="ptype@partWizardBean@servletRequest">
               <%-- List partitioning --%>
                <uix:case name="4">
                  <uix:stackLayout>
                    <uix:separator>
                      <uix:spacer height="5"/>
                    </uix:separator>
                    <uix:styledText textBinding="SUB_LVDESC@msgs"
                                    styleClass="OraInstructionText"/>
                  </uix:stackLayout>
                </uix:case>
              </uix:switcher>

                <%--                     --%>
                <%-- Subpartitions table --%>
                <%--                     --%>
                <%@ include file="subpartitionsTable.jsp" %>

            </uix:stackLayout>
        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
