<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%--
  -- Page:        wizSubPartSpec.jsp
  -- Controller:  oracle.sysman.db.adm.schm.TableController
  --              oracle.sysman.db.adm.schm.PartitionsWizardController
  -- Description: Partioning wizard page - lets the user select the
  --              number of subpartitions and the tablespaces to use.
  --
  --  MODIFIED    (MM/DD/YY)
  --     chanchan  10/09/03 - Add ADA supports 
  --     mpawelko  09/20/03 - add logged in as msg 
  --     mpawelko  08/16/03 - change tablespace options 
  --     hsu       07/25/03 - change global
  --     rreilly   05/21/03 - uix:form to db:form
  --     mpawelko  04/29/03 - add power of 2 tip for hash subpartitions
  --     qsong     04/29/03 - Add oemTop.jspf
  --     mpawelko  04/07/03 - make lov fields active only when radio button checked
  --     mpawelko  04/04/03 - change tablespace options
  --     mnihalan  01/20/03 - Change the page header
  --     jochen    12/30/02 - Tablespace validation
  --     jochen    12/26/02 - Add error box
  --     jochen    12/19/02 - Replace rather than add subpartitions
  --     jochen    12/05/02 - Input fields shouldn't be required so cancel works
  --     jochen    11/26/02 - Make round-robin list an LOV
  --     jochen    11/20/02 - Change numSubparts property name
  --     jochen    11/15/02 - handle subpartitions
  --%>
<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>
<%@ page import="oracle.sysman.db.adm.schm.PartitionsWizardController" %>
<%@ page import="oracle.sysman.emo.adm.schema.partitions.WizardConstants" %>

<%-- Message Bundle --%>
<uix:renderingContext id="renderingContext">
  <uix:bundle name="msgs"
              class="oracle.sysman.db.rsc.schm.PartitionsMsg"/>
  <uix:bundle name="sdkMsgs"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
<oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%-- Browser title.  Page name from controller getPageHeader() --%>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>

      <%-- HTML Form --%>
      <db:form name="tblForm" 
               method="post"
               destinationBinding="destination@objectBean@servletRequest"
               copyParams="target,type,cancelURL,sname,oname,otype">
        <uix:formValue name="pageName" value="<%= SchemaPages.PART_WIZ_SUBPART_SPEC_PG %>"/>

        <uix:pageLayout titleBinding="pageHeader@partWizardBean@servletRequest">
          <%-- Oracle Logo and Tabs, breadcrumb data from --%>
          <%-- controller getNavigatorPath()              --%>
          <%@ include file="/database/global.jspf" %>

          <%-- Train --%>
          <uix:location>
            <jsp:include page="wizTrain.jsp" />
            <uix:ref refID="wizTrain" />
          </uix:location>

          <%-- Warning/Error display --%>
          <uix:messages>
            <oem:messageBox messageType="error"
                            errorTableBinding="errors@servletRequest"
                            titleTextKey="titleText" mainTextKey="mainText"/>
          </uix:messages>

          <%-- Navigation buttons --%>
          <jsp:include page="wizNavButtons.jsp" />
          <uix:pageButtons>
            <uix:ref refID="wizNavButtons" />
          </uix:pageButtons>

          <uix:pageStatus>
            <%@ include file="/database/sqlaccess/wizContext.jspf" %> 
          </uix:pageStatus>
          <%-- Follow page/wizard context information with a separator --%>
          <uix:separator/>

            <uix:stackLayout>
              <uix:separator>
                <uix:spacer height="5"/>
              </uix:separator>

                <%--                                --%>
                <%-- Number of partitions input box --%>
                <%--                                --%>
                <uix:rowLayout>
                  <uix:messagePrompt required="uiOnly"
                                     promptBinding="NUMSUBPARTS@msgs"
                                     labeledNodeId="initialNumSubparts"/>
                  <uix:spacer width="5"/>
                  <uix:stackLayout>
                    <uix:textInput name="initialNumSubparts"
                                   id="initialNumSubparts"
                                   shortDescBinding="NUMSUBPARTS@msgs"
                                   textBinding="initialNumSubparts@partWizardBean@servletRequest"
                                   required="no"
                                   columns="5">
                      <uix:onSubmitValidater>
                        <uix:decimal />
                      </uix:onSubmitValidater>
                    </uix:textInput>
                    <uix:messageText messageType="error"
                                     messageBinding="initialNumSubparts@errors@servletRequest" />
                  </uix:stackLayout>
                </uix:rowLayout>


                <uix:switcher childNameBinding="isSubHash@dataPartitionsBean@servletRequest">
                  <uix:case name="true">
                    <uix:rowLayout>
                      <uix:stackLayout>	
                        <uix:spacer height="5"/>
                        <uix:tip>
                          <uix:styledText textBinding="PSPEC_SUB_HASH_HINT@msgs"
                                          styleClass="OraTipText"/>
                        </uix:tip>
                      </uix:stackLayout>
                    </uix:rowLayout>
                  </uix:case>
                  <uix:case name="false">
                  <%--               --%>
                  <%-- Auto DEFAULT  --%>
                  <%--               --%>
                    <uix:stackLayout
                       renderedBinding="is92@dataPartitionsBean@servletRequest">
                      <uix:checkBox textBinding="PSPEC_DEF@msgs"
                                    name="subAutodef"
                                    checkedBinding="subAutodef@partWizardBean@servletRequest"/>
                      <uix:rowLayout>
                        <uix:spacer width="20"/>
                        <uix:styledText styleClass="OraInlineInfoText"
                                        textBinding="PSPEC_DEF_SUB_HINT@msgs"/>
                      </uix:rowLayout>
                    </uix:stackLayout>
                  </uix:case>
                </uix:switcher>


            </uix:stackLayout>
        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
