<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%--
  -- Page:        wizSubTablespaces.jsp
  -- Controller:  oracle.sysman.db.adm.schm.TableController
  --              oracle.sysman.db.adm.schm.DataPartitionsController
  --              oracle.sysman.db.adm.schm.PartitionsWizardController
  -- Description: Wizard subpartition tablespace selection page.
  --
  --  MODIFIED    (MM/DD/YY)
  --     sresrini  03/21/06 - Fix jsp compilation errors
  --     mpawelko  05/18/05 - fix oac violations 
  --     mpawelko  05/14/05 - fix oac violations 
  --     mpawelko  07/20/04 - fix LOV fields - use new generic ones 
  --     mpawelko  11/25/03 - need to build LOV fields on backend 
  --     chanchan  11/14/03 - Fix ADA lov field 
  --     chanchan  10/09/03 - Add ADA supports 
  --     mpawelko  09/20/03 - add logged in as msg 
  --     rreilly   09/22/03 - 
  --     mpawelko  08/21/03 - mpawelko_bug-3103244 
  --     mpawelko  08/19/03 - created
  --%>
<script language="JavaScript" src="/em/database/LOV.js"></script>

<script language="javascript">
function setOptions()
{
    document.forms[0].subRoundRobinList.disabled = !document.forms[0].subTSSel[2].checked;
    if (document.forms[0].tableSubTablespace != null)
        document.forms[0].tableSubTablespace.disabled = !document.forms[0].subTSSel[1].checked;
}
</script>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>
<%@ page import="oracle.sysman.db.adm.schm.PartitionsWizardController" %>
<%@ page import="oracle.sysman.emo.adm.schema.partitions.WizardConstants" %>

<%-- Message Bundle --%>
<uix:renderingContext id="renderingContext">
  <uix:bundle name="msgs"
              class="oracle.sysman.db.rsc.schm.PartitionsMsg"/>
  <uix:bundle name="sdkMsgs"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
<oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%-- Browser title.  Page name from controller getPageHeader() --%>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body onLoad="setOptions()">

      <%-- HTML Form --%>
      <db:form name="tblForm" 
               method="post" 
               destinationBinding="destination@objectBean@servletRequest"
               copyParams="target,type,cancelURL,sname,oname,otype">
        <uix:formValue name="pageName" value="<%= SchemaPages.PART_WIZ_SUBPART_TABLESPACES_PG %>"/>

        <uix:pageLayout titleBinding="pageHeader@partWizardBean@servletRequest">
          <%-- Oracle Logo and Tabs, breadcrumb data from --%>
          <%-- controller getNavigatorPath()              --%>
          <%@ include file="/database/global.jspf" %>

          <%-- Train --%>
          <uix:location>
            <jsp:include page="wizTrain.jsp" />
            <uix:ref refID="wizTrain" />
          </uix:location>

          <%-- Warning/Error display --%>
          <uix:messages>
            <oem:messageBox messageType="error"
                            errorTableBinding="errors@servletRequest"
                            titleTextKey="titleText" mainTextKey="mainText"/>
          </uix:messages>

          <%-- Navigation buttons --%>
          <jsp:include page="wizNavButtons.jsp" />
          <uix:pageButtons>
            <uix:ref refID="wizNavButtons" />
          </uix:pageButtons>

          <uix:pageStatus>
            <%@ include file="/database/sqlaccess/wizContext.jspf" %> 
          </uix:pageStatus>
          <%-- Follow page/wizard context information with a separator --%>
          <uix:separator/>


          <uix:styledText textBinding="TS_SUB_INSTR@msgs" 
                          labeledNodeId="TS_INSTR"
                          styleClass="OraInstructionText"/>


                <%--             --%>
                <%-- Tablespaces --%>
                <%--             --%>
                <uix:rowLayout>
                  <uix:stackLayout>

                    <uix:stackLayout>
                      <uix:spacer height="10"/>
                      <uix:separator>
                        <uix:spacer height="2"/>
                      </uix:separator>

                      <uix:radioButton name="subTSSel"
                                        value="<%= WizardConstants.S_USE_DEF_TS %>"
                                        selectedValueBinding="subTSSel@partWizardBean@servletRequest"
                                        onClick="setOptions()"
                                        textBinding="PSPEC_USE_DEF_TS@msgs"/>

                    <uix:rowLayout>
                      <uix:spacer width="20"/>

                      <uix:styledText styleClass="OraInlineInfoText"
                                      textBinding="PSPEC_TS_DEF_HINT@msgs"/>
                    </uix:rowLayout>
                  </uix:stackLayout>


                    <%-- Use table's tablespace (or inherit user's default) --%>
                    <uix:stackLayout>
                      <uix:spacer height="10"/>
                      <uix:separator>
                        <uix:spacer height="2"/>
                      </uix:separator>

                      <uix:radioButton name="subTSSel"
                                        value="<%= WizardConstants.S_USE_TABLE_TS %>"
                                        selectedValueBinding="subTSSel@partWizardBean@servletRequest"
                                        onClick="setOptions()"
                                        textBinding="PSPEC_USE_TABLE_TS@msgs"/>

                         <uix:rowLayout>
                          <uix:spacer width="20"/>

                      <uix:switcher childNameBinding="usingTableTablespace@partWizardBean@servletRequest">
                        <uix:case name="true">

                          <uix:styledText styleClass="OraDataText"
                                          textBinding="tableSubTablespace@partWizardBean@servletRequest"/>
                         </uix:case>
                         <uix:case name="false">
                          <uix:stackLayout>


                            <uix:messageLovField name="tableSubTablespace"
                                             textBinding="tableSubTablespace@partWizardBean@servletRequest"
                                             columns="30"
                                             id="TS_INSTR"
                                             searchDescBinding="SELECT_TS@msgs"
                                             onClick = "startLov('tableSubTablespace', 'ListTablespacePerm')"/>

                        <uix:messageText messageType="error"
                                         messageBinding="tableSubTablespace@errors@servletRequest" />
                        <uix:styledText styleClass="OraInlineInfoText"
                                        textBinding="PSPEC_TS_CHANGE_HINT@msgs"/>

                          </uix:stackLayout>
                         </uix:case>
                         </uix:switcher>
                        </uix:rowLayout>

                    </uix:stackLayout>

                    <%-- round robin --%>
                    <uix:stackLayout>
                      <uix:spacer height="10"/>
                      <uix:separator>
                        <uix:spacer height="2"/>
                      </uix:separator>


                        <uix:radioButton name="subTSSel"
                                          value="<%= WizardConstants.S_USE_LIST_TS %>"
                                          selectedValueBinding="subTSSel@partWizardBean@servletRequest"
                                          onClick="setOptions()"                                         
                                          textBinding="PSPEC_USE_LIST_TS@msgs"/>

                        <uix:rowLayout>
                          <uix:spacer width="20"/>
                          <uix:stackLayout>


                            <uix:messageLovField name="subRoundRobinList"
                                             textBinding="subRoundRobinList@partWizardBean@servletRequest"
                                             columns="80"
                                             id="TS_INSTR2"
                                             searchDescBinding="SELECT_TS@msgs"
                                             onClick = "appendData();selectMultiple();startLov('subRoundRobinList', 'ListTablespacePerm')"/>
                            <uix:messageText messageType="error"
                                             messageBinding="subRoundRobinList@errors@servletRequest" />
                            <uix:styledText styleClass="OraInlineInfoText"
                                            labeledNodeId="TS_INSTR2"
                                            textBinding="TSTIP@msgs"/>
                          </uix:stackLayout>
                        </uix:rowLayout>
                    </uix:stackLayout>


                  </uix:stackLayout> 
                </uix:rowLayout>

                <uix:stackLayout>
                  <uix:spacer height="20"/>
                  <uix:tip>
                    <uix:styledText textBinding="PSPEC_SUBTS_HINT@msgs"
                                    styleClass="OraTipText"/>
                  </uix:tip>
                </uix:stackLayout>



        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
