<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%--
  -- Page:        wizTablespaces.jsp
  -- Controller:  oracle.sysman.db.adm.schm.TableController
  --              oracle.sysman.db.adm.schm.DataPartitionsController
  --              oracle.sysman.db.adm.schm.PartitionsWizardController
  -- Description: Wizard partition tablespace selection page.
  --
  --  MODIFIED    (MM/DD/YY)
  --     sresrini  03/21/06 - Fix jspcompilation errors
  --     mpawelko  05/14/05 - fix oac violations 
  --     mpawelko  07/20/04 - fix LOV fields - use new generic ones 
  --     chanchan  04/20/04 - Use generic LOV 
  --     mpawelko  11/25/03 - need to build LOV fields on backend 
  --     chanchan  11/14/03 - Fix ADA lov field 
  --     chanchan  10/29/03 - Fix ADA issues 
  --     chanchan  10/08/03 - Add ADA supports 
  --     mpawelko  09/19/03 - add validation 
  --     rreilly   09/22/03 - use lov dest on the request
  --     mpawelko  09/01/03 - GUI review changes 
  --     mpawelko  08/21/03 - mpawelko_bug-3103244 
  --     mpawelko  08/18/03 - created
  --%>
<script language="JavaScript" src="/em/database/LOV.js"></script>
<script language="javascript">
function setOptions()
{
    document.forms[0].roundRobinList.disabled  = document.forms[0].tablespaceSel[0].checked;
    document.forms[0].tableTablespace.disabled = document.forms[0].tablespaceSel[1].checked;
    if (document.forms[0].OFTablespaceSel != null)
    {
        document.forms[0].OFRoundRobinList.disabled= document.forms[0].OFTablespaceSel[0].checked;
        document.forms[0].tableOFTablespace.disabled=document.forms[0].OFTablespaceSel[1].checked;
    }
}
</script>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>
<%@ page import="oracle.sysman.db.adm.schm.PartitionsWizardController" %>
<%@ page import="oracle.sysman.emo.adm.schema.partitions.WizardConstants" %>

<%-- Message Bundle --%>
<uix:renderingContext id="renderingContext">
  <uix:bundle name="msgs"
              class="oracle.sysman.db.rsc.schm.PartitionsMsg"/>
  <uix:bundle name="sdkMsgs"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
<oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%-- Browser title.  Page name from controller getPageHeader() --%>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body onLoad="setOptions()">

      <%-- HTML Form --%>
      <db:form name="tblForm" 
               method="post" 
               destinationBinding="destination@objectBean@servletRequest"
               copyParams="target,type,cancelURL,sname,oname,otype">
        <uix:formValue name="pageName" value="<%= SchemaPages.PART_WIZ_TABLESPACES_PG %>"/>

        <uix:pageLayout titleBinding="pageHeader@partWizardBean@servletRequest">
          <%-- Oracle Logo and Tabs, breadcrumb data from --%>
          <%-- controller getNavigatorPath()              --%>
          <%@ include file="/database/global.jspf" %>

          <%-- Train --%>
          <uix:location>
            <jsp:include page="wizTrain.jsp" />
            <uix:ref refID="wizTrain" />
          </uix:location>

          <%-- Warning/Error display --%>
          <uix:messages>
            <oem:messageBox messageType="error"
                            errorTableBinding="errors@servletRequest"
                            titleTextKey="titleText" mainTextKey="mainText"/>
          </uix:messages>

          <%-- Navigation buttons --%>
          <jsp:include page="wizNavButtons.jsp" />
          <uix:pageButtons>
            <uix:ref refID="wizNavButtons" />
          </uix:pageButtons>

          <uix:pageStatus>
            <%@ include file="/database/sqlaccess/wizContext.jspf" %> 
          </uix:pageStatus>
          <%-- Follow page/wizard context information with a separator --%>
          <uix:separator/>

                  <uix:styledText textBinding="TS_INSTR@msgs" labeledNodeId="TS_INSTR"
                                  styleClass="OraInstructionText"/>


                <%--             --%>
                <%-- Tablespaces --%>
                <%--             --%>

                <uix:rowLayout>
                  <uix:stackLayout>
                    <%-- Use table's tablespace (or inherit user's default) --%>
                    <uix:stackLayout>
                      <uix:spacer height="10"/>
                      <uix:separator>
                        <uix:spacer height="2"/>
                      </uix:separator>
                        <uix:radioButton name="tablespaceSel" 
                                         value="<%= WizardConstants.S_USE_TABLE_TS %>"
                                         selectedValueBinding="tablespaceSel@partWizardBean@servletRequest"
                                         onClick="setOptions()"
                                         textBinding="PSPEC_USE_TABLE_TS@msgs"/>
                        <uix:rowLayout>
                          <uix:spacer width="20"/>
                          <uix:stackLayout>

                        <uix:messageLovField name="tableTablespace" 
                                             textBinding="tableTablespace@partWizardBean@servletRequest"
                                             columns="30"
                                             id="TS_INSTR" searchDescBinding="SELECT_TS@msgs"
                                             onClick = "startLov('tableTablespace', 'ListTablespacePerm')"/>

<%--
                            <uix:messageText messageType="error"
                                             messageBinding="(USE_TABLE_TS_ERR@msgs)@errors@servletRequest" />

                            <uix:messageStyledText messageType="error"
styleClass="OraInlineErrorText"
                                                   textBinding="tableTablespace@errors@servletRequest" />

--%>
                            <uix:styledText styleClass="OraInlineInfoText"
                                            textBinding="PSPEC_TS_CHANGE_HINT@msgs"/>
                            <uix:messageText messageType="error"
                                             messageBinding="tableTablespace@errors@servletRequest" />
                          </uix:stackLayout>
                        </uix:rowLayout>
                    </uix:stackLayout>

                    <%-- round robin --%>
                    <uix:stackLayout>
                      <uix:spacer height="10"/>
                      <uix:separator>
                        <uix:spacer height="2"/>
                      </uix:separator>
                        <uix:radioButton name="tablespaceSel"
                                         value="<%= WizardConstants.S_USE_LIST_TS %>"
                                         selectedValueBinding="tablespaceSel@partWizardBean@servletRequest"
                                         onClick="setOptions()"
                                         textBinding="PSPEC_USE_LIST_TS@msgs"/>
                        <uix:rowLayout>
                          <uix:spacer width="20"/>
                          <uix:stackLayout>
                            <uix:messageLovField name="roundRobinList"
                                                 textBinding="roundRobinList@partWizardBean@servletRequest"
                                                 columns="80"
                                                 id="TS_INSTR2" searchDescBinding="SELECT_TS@msgs"
                                                 onClick = "appendData();selectMultiple();startLov('roundRobinList', 'ListTablespacePerm')"/>

                            <uix:styledText styleClass="OraInlineInfoText"
                                            labeledNodeId="TS_INSTR2"
                                            textBinding="TSTIP@msgs"/>
                            <uix:messageText messageType="error"
                                             messageBinding="roundRobinList@errors@servletRequest" />
                          </uix:stackLayout>
                        </uix:rowLayout>
                    </uix:stackLayout>


                  </uix:stackLayout> 
                </uix:rowLayout>

                <uix:spacer height="10"/>


                <%--                      --%>
                <%-- Overflow Tablespaces --%>
                <%--                       --%>
                <uix:header textBinding="PSPEC_OVERFLOW_TS@msgs"
                            renderedBinding="isIOTOverflow@dataPartitionsBean@servletRequest">

                <uix:rowLayout>
                  <uix:stackLayout>
                    <%-- Use table's tablespace (or inherit user's default) --%>
                    <uix:stackLayout>
                      <uix:spacer height="10"/>
                      <uix:separator>
                        <uix:spacer height="2"/>
                      </uix:separator>
                        <uix:radioButton name="OFTablespaceSel"
                                       value="<%= WizardConstants.S_USE_TABLE_TS %>"
                                         selectedValueBinding="OFTablespaceSel@partWizardBean@servletRequest"
                                         onClick="setOptions()"
                                         textBinding="PSPEC_USE_TABLE_OVERTS@msgs"/>
                        <uix:rowLayout>
                          <uix:spacer width="20"/>
                          <uix:stackLayout>

                        <uix:messageLovField name="tableOFTablespace"
                                             textBinding="tableOFTablespace@partWizardBean@servletRequest"
                                             columns="30"
                                             id="TS_INSTR3" searchDescBinding="SELECT_TS@msgs"
                                             onClick = "startLov('tableOFTablespace', 'ListTablespacePerm')"/>

                            <uix:styledText styleClass="OraInlineInfoText"
                                            labeledNodeId="TS_INSTR3"
                                            textBinding="PSPEC_OFTS_CHANGE_HINT@msgs"/>
                            <uix:messageText messageType="error"
                                             messageBinding="tableOFTablespace@errors@servletRequest" />
                          </uix:stackLayout>
                        </uix:rowLayout>
                    </uix:stackLayout>

                    <%-- round robin --%>
                    <uix:stackLayout>
                      <uix:spacer height="10"/>
                      <uix:separator>
                        <uix:spacer height="2"/>
                      </uix:separator>
                        <uix:radioButton name="OFTablespaceSel"
                                         value="<%= WizardConstants.S_USE_LIST_TS %>"
                                         selectedValueBinding="OFTablespaceSel@partWizardBean@servletRequest"
                                         onClick="setOptions()"
                                         textBinding="PSPEC_USE_LIST_TS@msgs"/>
                        <uix:rowLayout>
                          <uix:spacer width="20"/>
                          <uix:stackLayout>
                            <uix:messageLovField name="OFRoundRobinList"
                                                 textBinding="OFRoundRobinList@partWizardBean@servletRequest"
                                                 columns="80"
                                                 id="TS_INSTR4" searchDescBinding="SELECT_TS@msgs"
                                                 onClick = "appendData();selectMultiple();startLov('OFRoundRobinList', 'ListTablespacePerm')"/>
                            <uix:styledText styleClass="OraInlineInfoText"
                                            labeledNodeId="TS_INSTR4"
                                            textBinding="TSTIP@msgs"/>

                            <uix:messageText messageType="error"
                                             messageBinding="OFRoundRobinList@errors@servletRequest" />                         
                          </uix:stackLayout>
                        </uix:rowLayout>
                    </uix:stackLayout>


                  </uix:stackLayout>
                </uix:rowLayout>
               </uix:header>


                <uix:stackLayout>
                  <uix:spacer height="20"/>
                  <uix:tip>
                    <uix:styledText textBinding="PSPEC_TS_HINT@msgs"
                                    styleClass="OraTipText"/>
                  </uix:tip>
                </uix:stackLayout>



        </uix:pageLayout>
      </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
