<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        createPLSqlObjectPage.jsp
  -- Controller:  db/adm/schm/PLSqlObjectController.java
  --
  -- Description: Short Description of the page.
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>
<db:script src="/database/LOV.js"/>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<uix:renderingContext id="renderingContext">
  <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
<oem:setURLEncoder id="renderingContext"/>
<uix:document>
<%@ include file="/oemTitle.jspf" %>
<%-- HTML Page Title --%>
<uix:metaContainer>
  <uix:head titleBinding="title@objectBean@servletRequest"/>
</uix:metaContainer>
<uix:body>  

<%-- HTML Form --%>
<db:form name="foo" 
         method="post"
         destinationBinding="destination@objectBean@servletRequest"
         copyParams="target,type,cancelURL,sname,oname,otype" >
<uix:formValue name="pageName" value="<%= SchemaPages.PLSQLOBJECT_CREATE_PG %>"/>
<uix:pageLayout titleBinding="header@objectBean@servletRequest">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>

          <uix:contents>
            <uix:tableLayout cellSpacing="5">
              <uix:contents>
                <%-- name --%>
                <uix:rowLayout>
                    <uix:cellFormat hAlign="right" wrappingDisabled="true">
                      <uix:contents>
                        <uix:messagePrompt labeledNodeId="objectName"
                                           promptBinding="NAME@dbMsgs" 
                                           required="yes"/>
                      </uix:contents>
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="left">
                    <uix:textInput id="objectName"
                                   name="objectName" 
                                   shortDescBinding="NAME@dbMsgs"
                                   textBinding="objectName@objectBean@servletRequest"
                                   columns="60"/>
                    <uix:messageText messageBinding="objectName@errors@servletRequest" messageType="error"/>
                    </uix:cellFormat>
                </uix:rowLayout>
                <%-- schema name --%>
                <uix:rowLayout>
                  <uix:contents>
                    <uix:cellFormat hAlign="right" wrappingDisabled="true">
                      <uix:contents>
                        <uix:messagePrompt labeledNodeId="SCHEMA" 
                                           promptBinding="SCHEMA@dbMsgs" 
                                           required="yes"/>
                      </uix:contents>
                    </uix:cellFormat>
                    <uix:messageLovField name="schemaName"
                                         id="SCHEMA"
                                         shortDescBinding="SCHEMA@dbMsgs"
                                         searchDescBinding="SCHEMA@dbMsgs"
                                         textBinding="schemaName@objectBean@servletRequest"
                                         onClick="startLov('schemaName','ListSchema')"/>
                  </uix:contents>
                </uix:rowLayout>

                <%-- source --%>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right" vAlign="top" wrappingDisabled="true">
                    <uix:messagePrompt labeledNodeId="sourceCode"
                                       promptBinding="SOURCE@dbMsgs"  
                                       required="yes"/>
                  </uix:cellFormat>
                  <uix:textInput id="sourceCode"
                                 name="sourceCode"
                                 shortDescBinding="SOURCE@dbMsgs"
                                 textBinding="sourceCode@objectBean@servletRequest"
                                 columns="120" 
                                 rows="20"/>
                  <uix:messageText messageBinding="sourceCode@errors@servletRequest" messageType="error"/>
                </uix:rowLayout>

              </uix:contents>
            </uix:tableLayout>                
            <uix:spacer height="5"/>
          </uix:contents>

  <%-- Create/Edit Buttons --%>
  <uix:pageButtons>
  <uix:pageButtonBar>
    <jsp:include page="/database/schema/pageButtonInclude.jsp" />
    <uix:ref refID="pageButtonInclude" />
  </uix:pageButtonBar>
  </uix:pageButtons>

</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>

</uix:body>
</uix:document>
</uix:renderingContext>
<%-- END: Content --%>
