<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        editPLSqlObjectPage.jsp
  -- Controller:  db/adm/schm/PLSqlObjectController.java
  --
  -- Description: Short Description of the page.
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>
<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<jsp:useBean id="objectBean" scope="request"
   type="oracle.sysman.emo.adm.schema.srctype.plsqlobject.PLSqlObject"/>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>
<uix:document>
<%@ include file="/oemTitle.jspf" %>
<%-- HTML Page Title --%>
<uix:metaContainer>
  <uix:head titleBinding="title@objectBean@servletRequest"/>
  <db:script src="/database/utils.js"/>   <%-- lovField support --%>
</uix:metaContainer>
<uix:body>  

<%-- HTML Form --%>
<db:form name="foo" 
         method="post"
         destinationBinding="destination@objectBean@servletRequest"
         copyParams="target,type,cancelURL,sname,oname,otype" >
<uix:formValue name="pageName" value="<%= SchemaPages.PLSQLOBJECT_EDIT_PG %>"/>
<uix:pageLayout titleBinding="header@objectBean@servletRequest">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>

          <uix:contents>
            <uix:tableLayout cellSpacing="5">
              <uix:contents>

                <%-- name --%>
                <uix:rowLayout>
                    <uix:cellFormat hAlign="right" width="80">
                    <uix:switcher childNameBinding="isViewing@objectBean@servletRequest">
                      <uix:case name="true">
                        <uix:messagePrompt promptBinding="NAME@uixDBObjectBundle@servletRequest"/>
                      </uix:case>
                      <uix:case name="false">
                        <uix:messagePrompt labeledNodeId="objectName" promptBinding="NAME@uixDBObjectBundle@servletRequest"/>
                      </uix:case>
                    </uix:switcher>
                    </uix:cellFormat>
                    <uix:switcher childNameBinding="isViewing@objectBean@servletRequest">
                      <uix:case name="true">
                        <uix:styledText styleClass="OraDataText" 
                                        textBinding="objectName@objectBean@servletRequest"/>
                      </uix:case>
                      <uix:case name="false">
                        <uix:textInput id="objectName"
                                       name="objectName" 
                                       disabled="true" 
                                       columns="60" 
                                       textBinding="objectName@objectBean@servletRequest"/>
                      </uix:case>
                    </uix:switcher>
                </uix:rowLayout>

                <%-- schema name --%>
                <uix:rowLayout>
                    <uix:cellFormat hAlign="right">
                    <uix:switcher childNameBinding="isViewing@objectBean@servletRequest">
                      <uix:case name="true">
                        <uix:messagePrompt promptBinding="SCHEMA@uixDBObjectBundle@servletRequest"/>
                      </uix:case>
                      <uix:case name="false">
                        <uix:messagePrompt labeledNodeId="schemaName" promptBinding="SCHEMA@uixDBObjectBundle@servletRequest"/>
                      </uix:case>
                    </uix:switcher>
                    </uix:cellFormat>
                    <uix:switcher childNameBinding="isViewing@objectBean@servletRequest">
                      <uix:case name="true">
                        <uix:styledText styleClass="OraDataText" 
                                        textBinding="schemaName@objectBean@servletRequest"/>
                      </uix:case>
                      <uix:case name="false">
                        <uix:textInput id="schemaName"
                                       name="schemaName" 
                                       disabled="true" 
                                       columns="60" 
                                       textBinding="schemaName@objectBean@servletRequest"/>
                      </uix:case>
                    </uix:switcher>

                </uix:rowLayout>

                <%-- status --%>
                <uix:rowLayout>
                  <uix:contents>
                    <uix:cellFormat hAlign="right">
                      <uix:contents>
                    <uix:switcher childNameBinding="isViewing@objectBean@servletRequest">
                      <uix:case name="true">
                        <uix:messagePrompt promptBinding="STATUS@uixDBObjectBundle@servletRequest"/>
                      </uix:case>
                      <uix:case name="false">
                        <uix:messagePrompt labeledNodeId="objectStatus"
                                           promptBinding="STATUS@uixDBObjectBundle@servletRequest"/>
                      </uix:case>
                    </uix:switcher>
                      </uix:contents>
                    </uix:cellFormat>
                    <uix:switcher childNameBinding="isViewing@objectBean@servletRequest">
                      <uix:case name="true">
                        <uix:styledText styleClass="OraDataText" textBinding="status@objectBean@servletRequest"/>
                      </uix:case>
                      <uix:case name="false">
                        <uix:textInput id="objectStatus" 
                                       disabled="true" 
                                       columns="60" 
                                       textBinding="status@objectBean@servletRequest"/>
                      </uix:case>
                    </uix:switcher>

                  </uix:contents>
                </uix:rowLayout>

                <%-- methods --%>
                <uix:rowLayout renderedBinding="displayMethods@objectBean@servletRequest">
                  <uix:contents>
                    <uix:cellFormat hAlign="right" vAlign="top">
                      <uix:contents>
                        <uix:messagePrompt labeledNodeId="methods"
                                           promptBinding="METHODS@uixDBObjectBundle@servletRequest"/>
                      </uix:contents>
                    </uix:cellFormat>
                    <uix:textInput id="methods"
                                   textBinding="methodsText@objectBean@servletRequest"
                                   columns="120"
                                   wrap="off"
                                   readOnly="true"
                                   rows="<%=objectBean.getNumMethodRows()%>"/>
                  </uix:contents>
                </uix:rowLayout>

                <%-- tip --%>
                <uix:rowLayout renderedBinding="displayMethods@objectBean@servletRequest">
                  <uix:cellFormat/>
                  <uix:styledText textBinding="numProcFunc@objectBean@servletRequest"
                                  styleClass="OraInlineInfoText"/>
                  <uix:spacer height="10"/>
                </uix:rowLayout>

                <%-- source --%>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right" vAlign="top">
                    <uix:messagePrompt labeledNodeId="sourceCode"
                                       promptBinding="SOURCE@uixDBObjectBundle@servletRequest"/>
                  </uix:cellFormat>

                  <uix:switcher childNameBinding="isViewing@objectBean@servletRequest"> 
                    <uix:case name="false">
                      <uix:stackLayout>
                        <uix:textInput id="sourceCode"
                                       name="sourceCode"
                                       textBinding="sourceCode@objectBean@servletRequest" 
                                       disabledBinding="disabledFlag@objectBean@servletRequest" 
                                       wrap="off"
                                       columns="120" rows="18"/>
                        <uix:messageText messageBinding="sourceCode@errors@servletRequest" messageType="error"/>
                      </uix:stackLayout>
                    </uix:case>
                    <uix:case name="true">
                      <uix:textInput id="sourceCode"
                                     name="sourceCode" 
                                     textBinding="sourceCode@objectBean@servletRequest" 
                                     disabledBinding="disableFlag@objectBean@servletRequest" 
                                     readOnly="true"
                                     wrap="off"
                                     columns="120" rows="<%=objectBean.getNumRows()%>"/>
                    </uix:case> 
                  </uix:switcher> 
                </uix:rowLayout>

                <%-- compile and show errors buttons--%>
                <uix:switcher childNameBinding="isViewing@objectBean@servletRequest">
                 <uix:case name="false">
                   <uix:rowLayout>
                       <uix:messagePrompt prompt = " "/>

                       <uix:cellFormat hAlign="right">
                         <uix:switcher childNameBinding="plSqlObjectType@objectBean@servletRequest">
                           <uix:case name="PACKAGE">
                             <uix:submitButton textBinding="EDIT_PACKAGEBODY@uixPLSqlObjectBundle@servletRequest" 
                                               name="event" 
                                               value="editPackageBody"/>
                           </uix:case>

                           <uix:case name="PACKAGE BODY">
                             <uix:submitButton textBinding="EDIT_PACKAGE@uixPLSqlObjectBundle@servletRequest" 
                                               name="event"
                                               value="editPackage"/>
                           </uix:case>
                         </uix:switcher> 

                         <uix:spacer width="5"/>

                         <uix:submitButton textBinding="COMPILE@uixDBObjectBundle@servletRequest" 
                                           name="event" value="compile"/>

                         <uix:spacer width="5"/>

                         <uix:submitButton textBinding = "errorButtonName@objectBean@servletRequest" 
                                           name="event" value="showErrors"
                                           disabledBinding="valid@objectBean@servletRequest"/>
                       </uix:cellFormat>

                   </uix:rowLayout>
                 </uix:case>
                </uix:switcher>

                <%-- error --%>
                <uix:switcher childNameBinding="showErrors@objectBean@servletRequest" >
                  <uix:case name = "true">
                    <uix:rowLayout>
                    <uix:contents>
                      <uix:cellFormat hAlign="right" vAlign="top">
                        <uix:contents>
                          <uix:messagePrompt labeledNodeId="errors"
                                             promptBinding="ERRORS@uixDBObjectBundle@servletRequest"/>
                        </uix:contents>
                      </uix:cellFormat>
                      <uix:textInput id="errors"
                                     name="errors" 
                                     textBinding="errors@objectBean@servletRequest"
                                     columns="120" 
                                     rows="5" 
                                     readOnly="true"/>
                    </uix:contents>
                    </uix:rowLayout>
                 </uix:case>
                </uix:switcher>
              </uix:contents>
            </uix:tableLayout>
            <uix:spacer height="5"/>
          </uix:contents>

  <%-- Create/Edit Buttons --%>
  <uix:pageButtons>
  <uix:pageButtonBar>
    <uix:switcher childNameBinding="isViewing@objectBean@servletRequest">
      <uix:case name="true">
        <uix:switcher childNameBinding="xmlInitialized@objectBean@servletRequest">
          <uix:case name="false">
           <jsp:include page="/database/schema/pageButtonViewInclude.jsp" />
           <uix:ref refID="pageButtonViewInclude" />
          </uix:case>
          <uix:case name="true">
          <%-- OK Button --%>
          <%@ include file="/database/changemgr/cmEMOViewPageButtons.jspf" %>
          </uix:case>
        </uix:switcher>
      </uix:case> 
      <uix:case name="false">
        <jsp:include page="/database/schema/pageButtonInclude.jsp" />
        <uix:ref refID="pageButtonInclude" />
      </uix:case> 
    </uix:switcher> 
  </uix:pageButtonBar>
  </uix:pageButtons>

</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>

</uix:body>
</uix:document>
</uix:renderingContext>
<%-- END: Content --%>
