<%@ include file="/sdk/oemTop.jspf" %>
<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<jsp:useBean id="objectBean" scope="request"
   type="oracle.sysman.emo.adm.schema.refgroup.RefGroup"/>
<%@ include file="/oemNoscript.jspf" %>
<db:script src="/database/LOV.js"/>
<db:script src="/database/utils.js"/>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<uix:renderingContext id="renderingContext">
  <uix:bundle name="dbMsgs"
              class="oracle.sysman.db.rsc.DBObjectMsg"/>
<oem:setURLEncoder id="renderingContext"/>
<uix:document>

<%-- HTML Page Title --%>
<uix:metaContainer>
  <uix:head titleBinding="title@objectBean@servletRequest"/>
</uix:metaContainer>
<uix:body>

<%-- HTML Form --%>
<db:form name="refGenForm"  
         method="post"
         destinationBinding="destination@objectBean@servletRequest"
         copyParams="target,type,cancelURL,sname,oname,otype">
<uix:formValue name="pageName" value="<%= SchemaPages.REFGROUP_GENERAL_PG%>"/>
<uix:formValue name="value" />
<uix:formValue name="source" />
<uix:pageLayout titleBinding="header@objectBean@servletRequest">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info" errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>

  <uix:subTabLayout>

    <!-- Sub Tabs -->
    <uix:subTabs>
      <uix:subTabBar selectedIndex="0">
        <db:link textBinding="GENERAL@dbMsgs"
                 copyParams="target,type,cancelURL,sname,oname,otype"/>
        <db:link textBinding="MATERIALIZED_VIEWS@dbMsgs"
                 onClick="submitForm('refGenForm', true, {event:'gotoValue2'})"
                 copyParams="target,type,cancelURL,sname,oname,otype"/>
      </uix:subTabBar>
    </uix:subTabs>

  <%-- START: TAB CONTENTS starts here --%>

          <uix:tableLayout cellSpacing="5" hAlign="center" width="75%">

            <!-- Name -->
            <uix:rowLayout>
              <uix:cellFormat hAlign="right" width="100">
                <uix:messagePrompt labeledNodeId="refGroupName"
                                   required="<%=objectBean.isRequired()%>" 
                                   promptBinding="NAME@dbMsgs"/> 
              </uix:cellFormat>
              <uix:cellFormat>
                <uix:stackLayout>
                  <uix:textInput id="refGroupName"
                                 name="refGroupName" 
                                 textBinding="refGroupName@objectBean@servletRequest" 
                                 columns="30" 
                                 disabledBinding="disabled@objectBean@servletRequest"/>
                  <uix:messageText messageBinding="refGroupName@errors@servletRequest"
                                   messageType="error"/>
                </uix:stackLayout>
              </uix:cellFormat>
           
            </uix:rowLayout>
 
            <!-- Schema Name -->
            <uix:rowLayout>
              <uix:cellFormat hAlign="right" width="100">
                <uix:messagePrompt labeledNodeId="schema" required="<%=objectBean.isRequired()%>" 
                                   promptBinding="SCHEMA@dbMsgs"/> 
              </uix:cellFormat>
              <uix:cellFormat>
                <uix:stackLayout>
                  <uix:messageLovField name="schema" 
                                       id="schema"
                                       shortDescBinding="SCHEMA@dbMsgs" 
                                       searchDescBinding="SCHEMA@dbMsgs" 
                                       textBinding="schema@objectBean@servletRequest" 
                                       onClick="startLov('schema','ListSchema')"
                                       disabledBinding="disabled@objectBean@servletRequest"/>
                  <uix:messageText messageBinding="schema@errors@servletRequest"
                                   messageType="error"/>
                </uix:stackLayout>
              </uix:cellFormat>
            </uix:rowLayout>

            <uix:switcher childNameBinding="disabled@objectBean@servletRequest">
              <uix:case name="true">
                <!-- Status -->
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right" width="100">
                    <uix:messagePrompt promptBinding="STATUS@dbMsgs"/>
                  </uix:cellFormat>
                  <uix:styledText styleClass="OraDataText" textBinding="status@objectBean@servletRequest"/>
                </uix:rowLayout>
              </uix:case> 
            </uix:switcher> 

                <!-- Job ID -->
            <uix:switcher childNameBinding="disabled@objectBean@servletRequest">
              <uix:case name="true">
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right" width="100">
                    <uix:messagePrompt promptBinding="JOB_ID@uixRefGrpBundle@servletRequest"/>
                  </uix:cellFormat>
                  <uix:styledText styleClass="OraDataText" textBinding="job@objectBean@servletRequest"/>
                </uix:rowLayout>
              </uix:case> 
            </uix:switcher> 

            <!-- Refresh Options -->
            <uix:header size="2" textBinding="REFRESH@dbMsgs">
              <uix:tableLayout cellSpacing="5"> 
                <!-- Next Date -->
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right" width="100">
                    <uix:messagePrompt labeledNodeId="nextDate"
                                       required="yes" 
                                       promptBinding="NEXT_DATE@uixRefGrpBundle@servletRequest"/>
                  </uix:cellFormat>
                  <uix:cellFormat>
                  <uix:textInput id="nextDate"
                                 name="nextDate" 
                                 textBinding="nextDate@objectBean@servletRequest" 
                                 columns="40" 
                                 rows="1" />
                  <uix:submitButton textBinding="CHANGE@uixRefGrpBundle@servletRequest"
                                    name="event" value="setNextDate"/>
                  </uix:cellFormat>
                </uix:rowLayout>

                <!-- Interval -->
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right" width="100">
                    <uix:messagePrompt labeledNodeId="interval"
                                       required="yes" 
                                       promptBinding="INTERVAL@uixRefGrpBundle@servletRequest"/>
                  </uix:cellFormat>
                  <uix:cellFormat>
                  <uix:textInput id="interval"
                                 name="interval" 
                                 textBinding="interval@objectBean@servletRequest" 
                                 columns="40"/>
                  <uix:submitButton textBinding="CHANGE@uixRefGrpBundle@servletRequest"
                                    name="event" value="setInterval"/>
                  </uix:cellFormat>
                </uix:rowLayout>

                <uix:rowLayout>
                  <uix:cellFormat hAlign="right" width="100"/>
                  <uix:checkBox name="deferred" textBinding="DEFERRED_INST@uixRefGrpBundle@servletRequest"
                                checkedBinding="deferred@objectBean@servletRequest"/>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right" width="100"/>
                  <uix:checkBox name="continue" textBinding="CONTINUE_INST@uixRefGrpBundle@servletRequest"
                                checkedBinding="continue@objectBean@servletRequest"/>
                </uix:rowLayout>

                <uix:rowLayout>
                  <uix:cellFormat width="100"/>
                  <uix:cellFormat>
                    <uix:checkBox name="destroy" checkedBinding="destroy@objectBean@servletRequest" 
                                  textBinding="DESTROY_INST@uixRefGrpBundle@servletRequest"/>
                    <uix:spacer width="5"/>
                    <uix:switcher childNameBinding="disabled@objectBean@servletRequest">
                      <uix:case name="true">
                        <uix:submitButton textBinding="REFRESH_NOW@uixRefGrpBundle@servletRequest" 
                                          name="event" value="refresh" />
                      </uix:case> 
                    </uix:switcher> 
                  </uix:cellFormat>
                </uix:rowLayout>

              </uix:tableLayout> 
            </uix:header> 

            <!-- Rollback Segment -->
            <uix:header size="2" textBinding="RB_SEGMENTS@dbMsgs">
              <uix:tableLayout cellSpacing="3">
              <uix:rowLayout>
                <oem:radioButton name="useDefaultSeg" value="true" 
                                 textBinding="USE_DEFAULT_RBS@uixRefGrpBundle@servletRequest"
                                 selectedValueBinding="useDefaultSeg@objectBean@servletRequest"/>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat>
                  <oem:radioButton name="useDefaultSeg" value="false" 
                                   textBinding="SEGMENT@uixRefGrpBundle@servletRequest"
                                   shortDescBinding="SEGMENT@uixRefGrpBundle@servletRequest"
                                   selectedValueBinding="useDefaultSeg@objectBean@servletRequest"/>
                  <uix:spacer width="5"/>
                <uix:stackLayout>
                  <oem:choice name="rbSegment" 
                              selectedValueBinding="rbSegment@objectBean@servletRequest"
                              shortDescBinding="SEGMENT@dbMsgs"
                              optionsBinding="rbsList@objectBean@servletRequest"/>
                  <uix:messageText messageBinding="rbSegment@errors@servletRequest"
                                   messageType="error"/> 
                </uix:stackLayout>
                </uix:cellFormat>
              </uix:rowLayout>
              </uix:tableLayout> 
              </uix:header> 

          <uix:spacer height="15"/>
          </uix:tableLayout> 
        </uix:subTabLayout>

        <!-- Page Buttons -->
        <uix:pageButtons>
        <uix:pageButtonBar>
          <jsp:include page="/database/schema/pageButtonInclude.jsp" />
          <uix:ref refID="pageButtonInclude" />
        </uix:pageButtonBar>
        </uix:pageButtons>

      </uix:pageLayout>
    </db:form>

   </uix:body>
  </uix:document>
</uix:renderingContext>




