<%@ include file="/sdk/oemTop.jspf" %>
<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<jsp:useBean id="objectBean" scope="request"
   type="oracle.sysman.emo.adm.schema.refgroup.RefGroup"/>

<db:script src="/database/utils.js"/>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>
<uix:document>

<%-- HTML Page Title --%>
<uix:metaContainer>
  <uix:head titleBinding="title@objectBean@servletRequest"/>
</uix:metaContainer>
<uix:body>

<%-- HTML Form --%>
<db:form name="mvForm"
         method="post" 
         destinationBinding="destination@objectBean@servletRequest"
         copyParams="target,type,cancelURL,sname,oname,otype">
<uix:formValue name="pageName" value="<%= SchemaPages.REFGROUP_MVIEW_PG %>"/>
<uix:formValue name="value" />
<uix:formValue name="source" />
<uix:pageLayout titleBinding="header@objectBean@servletRequest">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info" errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>

  <uix:subTabLayout>

    <!-- Sub Tabs -->
    <uix:subTabs>
      <uix:subTabBar selectedIndex="1">
        <db:link textBinding="GENERAL@uixDBObjectBundle@servletRequest"
                 onClick="submitForm('mvForm', true, {event:'gotoValue1'})"
                 copyParams="target,type,cancelURL,sname,oname,otype"/>
        <db:link textBinding="MATERIALIZED_VIEWS@uixDBObjectBundle@servletRequest"
                 copyParams="target,type,cancelURL,sname,oname,otype"/>
      </uix:subTabBar>
    </uix:subTabs>

          <uix:spacer height="15"/>
          <uix:stackLayout> 
              <uix:rowLayout width="90%"> 
                <uix:cellFormat hAlign="right" vAlign="top" width="100%"> 
                  <uix:submitButton textBinding="ADD@uixRefGrpBundle@servletRequest" 
                                    name="event" value="addMV"/>
                </uix:cellFormat> 
              </uix:rowLayout> 

              <uix:rowLayout width="90%"> 
                <oem:table name="mvListUIDataSource" blockSize="20"
                           formSubmitted="true"
                           dataSourceProp="mvListUIDataSource" width="100%"
                           summaryBinding="MATERIALIZED_VIEWS@uixDBObjectBundle@servletRequest"
                           copyParams="target,type,cancelURL,sname,oname,otype">
                  <uix:tableSelection>
                    <uix:multipleSelection shortDescBinding="SELECT_A_VALUE@uixDBObjectBundle@servletRequest">
                      <uix:submitButton textBinding="REMOVE@uixRefGrpBundle@servletRequest" 
                                        name="event" value="removeMV"/>
                    </uix:multipleSelection>
                  </uix:tableSelection>
                </oem:table>
              </uix:rowLayout> 
          </uix:stackLayout>

          <uix:spacer height="15"/>
        </uix:subTabLayout>


        <!-- Page Buttons -->
        <uix:pageButtons>
        <uix:pageButtonBar>
          <jsp:include page="/database/schema/pageButtonInclude.jsp" />
          <uix:ref refID="pageButtonInclude" />
        </uix:pageButtonBar>
        </uix:pageButtons>

      </uix:pageLayout>
    </db:form>
   </uix:body>
  </uix:document>
</uix:renderingContext>



