<%@ include file="/sdk/oemTop.jspf" %>
<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<jsp:useBean id="objectBean" scope="request"
   type="oracle.sysman.emo.adm.schema.refgroup.RefGroup"/>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<uix:renderingContext id="renderingContext">
<uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
<oem:setURLEncoder id="renderingContext"/>
<uix:document>

<%-- HTML Page Title --%>
<uix:metaContainer>
  <uix:head titleBinding="GENERAL_TITLE@uixRefGrpBundle@servletRequest"/>
</uix:metaContainer>

<%-- HTML Form --%>
<db:form name="selectMVForm"  
         method="post" 
         destinationBinding="destination@objectBean@servletRequest"
         copyParams="target,type,cancelURL,sname,oname,otype">
<uix:formValue name="pageName" value="<%= SchemaPages.REFGROUP_SEL_MVIEW_PG%>"/>
<uix:formValue name="value" />
<uix:formValue name="source" />
<uix:pageLayout titleBinding="selectMVHeader@objectBean@servletRequest">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>


    <uix:tableLayout cellSpacing="2">
      <%-- Search Criteria and Instruction --%>
      <uix:rowLayout>
        <uix:header textBinding="SEARCH@dbMsgs">
          <uix:rowLayout>
            <uix:styledText textBinding="SEARCH_SCHEMA_OBJECT_INTS@dbMsgs"/>
          </uix:rowLayout>

          <uix:rowLayout>
            <uix:tableLayout cellSpacing="4">
              <uix:rowLayout>

                <uix:cellFormat vAlign="top">
                  <uix:stackLayout>
                    <uix:styledText labeledNodeId="searchSchemaName"
                                    textBinding="SCHEMA_NAME_COLON@dbMsgs"/>
                    <uix:textInput id="searchSchemaName"
                                   name="searchSchemaName" 
                                   textBinding="searchSchemaName@objectBean@servletRequest"/> 
                  </uix:stackLayout> 
                </uix:cellFormat>

                <uix:cellFormat vAlign="top">
                  <uix:stackLayout>
                    <uix:styledText labeledNodeId="searchObjectName"
                                    textBinding="objectColumnText@objectBean@servletRequest"/>
                    <uix:rowLayout>
                      <uix:textInput id="searchObjectName"
                                     name="searchObjectName" 
                                     textBinding="searchObjectName@objectBean@servletRequest"/> 
                      <uix:submitButton textBinding="GO@dbMsgs"
                                        name="event" value="searchSchemaObject"/> 
                    </uix:rowLayout>
                  </uix:stackLayout> 
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>
          </uix:rowLayout>
        </uix:header>
      </uix:rowLayout>
      <%-- End Search Criteria and Instruction --%>

      <uix:rowLayout>
        <uix:switcher childNameBinding="showSearchResults@objectBean@servletRequest">
          <uix:case name="true">
            <uix:header textBinding="RESULTS@dbMsgs">
              <uix:rowLayout width="80%">
                <oem:table name="schemaObjectUIDataSource" blockSize="25"
                           formSubmitted="true"
                           dataSourceProp="schemaObjectUIDataSource" width="100%"
        		   alternateTextBinding="NO_ITEMS_FOUND@dbMsgs"
        		   summaryBinding="RESULTS@dbMsgs"
                           copyParams="target,type,cancelURL,sname,oname,otype">
                  <uix:tableSelection>
                    <uix:multipleSelection shortDescBinding="SELECT_A_VALUE@dbMsgs"/>
                  </uix:tableSelection>
                </oem:table>
              </uix:rowLayout>
            </uix:header>
          </uix:case>
        </uix:switcher>
      </uix:rowLayout>
    </uix:tableLayout>
 
    <uix:pageButtons>
      <uix:pageButtonBar>
        <uix:submitButton textBinding="CANCEL@dbMsgs" 
                          name="event" value="cancelAddingMV"/>
        <uix:submitButton textBinding="OK@dbMsgs" 
                          name="event" value="addingMV"/>
      </uix:pageButtonBar>
    </uix:pageButtons>

  </uix:pageLayout>
</db:form>

</uix:document>
</uix:renderingContext>
