<%@ include file="/sdk/oemTop.jspf" %>
<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<jsp:useBean id="objectBean" scope="request"
   type="oracle.sysman.emo.adm.schema.refgroup.RefGroup"/>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<uix:renderingContext id="renderingContext">
  <uix:bundle name="refMsgs"
              class="oracle.sysman.db.rsc.schm.RefGroupMsg"/>
<oem:setURLEncoder id="renderingContext"/>
<uix:document>

<%-- HTML Page Title --%>
<uix:metaContainer>
  <uix:head titleBinding="GENERAL_TITLE@uixRefGrpBundle@servletRequest"/>
</uix:metaContainer>

<%-- HTML Form --%>
<db:form name="dateForm"
         method="post" 
         destinationBinding="destination@objectBean@servletRequest"
         copyParams="target,type,cancelURL,sname,oname,otype">
<uix:formValue name="pageName" value="<%= SchemaPages.REFGROUP_SETDATE_PG%>"/>
<uix:formValue name="value" />
<uix:formValue name="source" />
<uix:pageLayout titleBinding="header@objectBean@servletRequest">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>

  <!-- ERROR display -->
  <oem:messageBox messageType="info" errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>

  <%-- START: CONTENTS starts here --%>
          <uix:tableLayout cellSpacing="5" hAlign="center" width="75%">

            <uix:rowLayout>
            <uix:cellFormat hAlign="left" width="120">
                <oem:radioButton name="date" textBinding="NOW@refMsgs" value="1" 
                                 selectedValueBinding="date@objectBean@servletRequest"/> 
            </uix:cellFormat> 
            </uix:rowLayout>
 
            <!-- Calendar -->
            <uix:rowLayout>
              <uix:cellFormat hAlign="left" width="120">
                <oem:radioButton name="date" textBinding="CALENDAR_DATE@refMsgs" value="2" 
                                 shortDescBinding="CALENDAR_DATE@refMsgs"
                                 selectedValueBinding="date@objectBean@servletRequest"/> 
            </uix:cellFormat> 
            <uix:cellFormat> 
               <uix:dateField valueBinding="scheduleDate@objectBean@servletRequest" 
                              shortDescBinding="NEXT_DATE@refMsgs"
                              name="scheduleDate" columns="20"/>

               <uix:spacer width="2"/>
               <uix:messagePrompt labeledNodeId="HR" promptBinding="HR@refMsgs"/>
               <oem:choice name="hour" id="HR" optionsBinding="hours@objectBean@servletRequest" 
                           selectedValueBinding="hour@objectBean@servletRequest"/>
               <uix:spacer width="2"/>
               <uix:messagePrompt labeledNodeId="MIN" promptBinding="MIN@refMsgs"/>
               <oem:choice name="minute" id="MIN" optionsBinding="minutes@objectBean@servletRequest" 
                           selectedValueBinding="minute@objectBean@servletRequest"/>
               <uix:spacer width="2"/>
               <uix:messagePrompt labeledNodeId="SEC" promptBinding="SEC@refMsgs"/>
               <oem:choice name="second" id="SEC" optionsBinding="seconds@objectBean@servletRequest" 
                           selectedValueBinding="second@objectBean@servletRequest"/>
            </uix:cellFormat> 
            </uix:rowLayout>

            <!-- User Expression -->
            <uix:rowLayout>
              <uix:cellFormat hAlign="left" width="120">
                <oem:radioButton name="date" textBinding="USER_EXPRESSION@refMsgs" value="3"  
                                 selectedValueBinding="date@objectBean@servletRequest"/>
              </uix:cellFormat> 
              <uix:cellFormat> 
                <uix:textInput name="userExpression" 
                               textBinding="userExpression@objectBean@servletRequest" 
                               columns="60"
                               shortDescBinding="USER_EXPRESSION@refMsgs"/> 
              </uix:cellFormat> 
            </uix:rowLayout>
          </uix:tableLayout>

        <!-- Page Buttons -->
        <uix:contentFooter>
        <uix:pageButtonBar>
          <uix:submitButton textBinding="CANCEL@uixDBObjectBundle@servletRequest"
                            name="event" value="back" />
          <uix:submitButton textBinding="OK@uixDBObjectBundle@servletRequest"
                            name="event" value="finishSetNextDate" />
        </uix:pageButtonBar>
        </uix:contentFooter>

      </uix:pageLayout>
     
    </db:form>
  </uix:document>
</uix:renderingContext>




