<%@ include file="/sdk/oemTop.jspf" %>
<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<jsp:useBean id="objectBean" scope="request"
   type="oracle.sysman.emo.adm.schema.refgroup.RefGroup"/>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<uix:renderingContext id="renderingContext">
<uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
<uix:bundle name="refMsgs" class="oracle.sysman.db.rsc.schm.RefGroupMsg"/>
<oem:setURLEncoder id="renderingContext"/>
<uix:document>

<%-- HTML Page Title --%>
<uix:metaContainer>
  <uix:head titleBinding="GENERAL_TITLE@uixRefGrpBundle@servletRequest"/>
</uix:metaContainer>

<%-- HTML Form --%>
<db:form name="intervalForm" 
         method="post"
         destinationBinding="destination@objectBean@servletRequest"
         copyParams="target,type,cancelURL,sname,oname,otype">
<uix:formValue name="pageName" value="<%= SchemaPages.REFGROUP_SETINTERVAL_PG %>"/>
<uix:formValue name="value" />
<uix:formValue name="source" />
<uix:pageLayout titleBinding="header@objectBean@servletRequest">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>

  <!-- ERROR display -->
  <oem:messageBox messageType="info" errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>

          <uix:tableLayout cellSpacing="5" hAlign="center"> 
            <uix:rowLayout>
               <uix:messagePrompt labeledNodeId="intervalUnit"
                                  promptBinding="EVERY@refMsgs"/>
               <uix:textInput id="intervalUnit"
                              name="intervalUnit" 
                              textBinding="intervalUnit@objectBean@servletRequest" 
                              columns="30"/>
               <oem:choice name="intervalOption" 
                           optionsBinding="intervalOptions@objectBean@servletRequest" 
                           shortDescBinding="INTERVAL@refMsgs"
                           selectedValueBinding="intervalOption@objectBean@servletRequest"/>
            </uix:rowLayout>

          </uix:tableLayout>

        <!-- Page Buttons -->
        <uix:contentFooter>
        <uix:pageButtonBar>
          <uix:submitButton textBinding="CANCEL@dbMsgs"
                            name="event" value="back" />
          <uix:submitButton textBinding="OK@dbMsgs"
                            name="event" value="finishSetInterval" />
        </uix:pageButtonBar>
        </uix:contentFooter>

      </uix:pageLayout>
     
    </db:form>
  </uix:document>
</uix:renderingContext>



