<%@ include file="/sdk/oemTop.jspf" %>
<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>
<jsp:useBean id="objectBean" scope="request"
   type="oracle.sysman.emo.adm.schema.refgroup.RefGroup"/>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>
<uix:document>

<%-- HTML Page Title --%>
<uix:metaContainer>
  <uix:head titleBinding="title@objectBean@servletRequest"/>
</uix:metaContainer>
<uix:body>

<%-- HTML Form --%>
<db:form name="rfViewForm"  
         method="post" 
         destinationBinding="destination@objectBean@servletRequest"
         copyParams="target,type,cancelURL,sname,oname,otype">
<uix:formValue name="pageName" value="<%= SchemaPages.REFGROUP_VIEW_PG%>"/>
<uix:formValue name="value" />
<uix:formValue name="source" />
<uix:pageLayout titleBinding="header@objectBean@servletRequest">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info"
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error"
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>

        <uix:header textBinding="GENERAL@uixDBObjectBundle@servletRequest">

          <!-- Name -->
          <uix:tableLayout>
            <uix:rowLayout>
              <uix:cellFormat hAlign="right" width="150">
                <uix:messagePrompt promptBinding="NAME@uixDBObjectBundle@servletRequest"/>
              </uix:cellFormat>
              <uix:cellFormat>
                <uix:spacer height="2" width="5" />
              </uix:cellFormat>
              <uix:styledText styleClass="OraDataText"
                              textBinding="name@objectBean@servletRequest" />
            </uix:rowLayout>


            <!-- Schema -->
            <uix:rowLayout>
              <uix:cellFormat hAlign="right" width="150">
                <uix:messagePrompt promptBinding="SCHEMA@uixDBObjectBundle@servletRequest"/> 
              </uix:cellFormat>
              <uix:cellFormat>
                <uix:spacer height="2" width="5" />
              </uix:cellFormat>
              <uix:styledText styleClass="OraDataText"
                              textBinding="schemaName@objectBean@servletRequest" />
            </uix:rowLayout>

            <!-- Status -->
            <uix:rowLayout>
              <uix:cellFormat hAlign="right" width="150">
                <uix:messagePrompt promptBinding="STATUS@uixDBObjectBundle@servletRequest"/> 
              </uix:cellFormat>
              <uix:cellFormat>
                <uix:spacer height="2" width="5" />
              </uix:cellFormat>
              <uix:styledText styleClass="OraDataText"
                              textBinding="status@objectBean@servletRequest" />
            </uix:rowLayout>


            <!-- Job ID-->
            <uix:rowLayout>
              <uix:cellFormat hAlign="right" width="150">
                <uix:messagePrompt promptBinding="JOB_ID@uixRefGrpBundle@servletRequest"/> 
              </uix:cellFormat>
              <uix:cellFormat>
                <uix:spacer height="2" width="5" />
              </uix:cellFormat>
              <uix:styledText styleClass="OraDataText"
                              textBinding="job@objectBean@servletRequest" />
            </uix:rowLayout>

            <!-- Rollback Segment -->
            <uix:rowLayout>
              <uix:cellFormat hAlign="right" width="150">
                <uix:messagePrompt promptBinding="RB_SEGMENT@uixDBObjectBundle@servletRequest"/>
              </uix:cellFormat>
              <uix:cellFormat>
                <uix:spacer height="2" width="5" />
              </uix:cellFormat>
              <uix:styledText styleClass="OraDataText"
                              textBinding="rbSegment@objectBean@servletRequest" />
            </uix:rowLayout>
          </uix:tableLayout>
        </uix:header>
        <!-- END: General Header-->

        <!-- Refresh Header-->
        <uix:header textBinding="REFRESH@uixDBObjectBundle@servletRequest">
          <uix:tableLayout>

            <!-- Next Date-->
            <uix:rowLayout>
              <uix:cellFormat hAlign="right" width="150">
                <uix:messagePrompt promptBinding="NEXT_DATE@uixRefGrpBundle@servletRequest"/>
              </uix:cellFormat>
              <uix:cellFormat>
                <uix:spacer height="2" width="5" />
              </uix:cellFormat>
              <uix:styledText styleClass="OraDataText"
                              textBinding="nextDate@objectBean@servletRequest" />
            </uix:rowLayout>

            <!-- Interval -->
            <uix:rowLayout>
              <uix:cellFormat hAlign="right" width="150">
                <uix:messagePrompt promptBinding="INTERVAL@uixRefGrpBundle@servletRequest"/>
              </uix:cellFormat>
              <uix:cellFormat>
                <uix:spacer height="2" width="5"/>
              </uix:cellFormat>
              <uix:styledText styleClass="OraDataText" textBinding="interval@objectBean@servletRequest" />
            </uix:rowLayout>
          </uix:tableLayout>
        </uix:header>
        <!-- END: Refresh Header-->

        <!-- Materialized View List -->
        <uix:header textBinding="MATERIALIZED_VIEWS@uixDBObjectBundle@servletRequest">
          <uix:rowLayout width="100%">
            <uix:cellFormat width="20"/>
            <uix:cellFormat>
            <oem:table name="mvListUIDataSource" blockSize="25" 
                             formSubmitted="true"
                             dataSourceProp="mvListUIDataSource" width="80%"
                             summaryBinding="MATERIALIZED_VIEWS@uixDBObjectBundle@servletRequest"
                             copyParams="target,type,cancelURL,sname,oname,otype"/>
            </uix:cellFormat>
          </uix:rowLayout>
        </uix:header>
        <!-- END: Materialized View List -->

        <!-- Options Header-->
        <uix:header rendered="<%=objectBean.getHasOptions()%>" 
                    textBinding="OPTIONS@uixDBObjectBundle@servletRequest">
          <uix:tableLayout>
            <!-- Implicit Destroy -->
            <uix:switcher childNameBinding="destroy@objectBean@servletRequest">
              <uix:case name="true">
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right" width="20"/>
                  <uix:messagePrompt promptBinding="DESTROY_INST@uixRefGrpBundle@servletRequest" /> 
                </uix:rowLayout>
              </uix:case>
            </uix:switcher> 
   
            <!-- Deferred -->
            <uix:switcher childNameBinding="deferred@objectBean@servletRequest">
              <uix:case name="true">
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right" width="20"/>
                  <uix:messagePrompt promptBinding="DEFERRED_INST@uixRefGrpBundle@servletRequest"/>
                </uix:rowLayout>
              </uix:case>
            </uix:switcher> 
  
            <!-- Continure Refresh -->
            <uix:switcher childNameBinding="continue@objectBean@servletRequest">
              <uix:case name="true">
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right" width="20"/>
                    <uix:messagePrompt promptBinding="CONTINUE_INST@uixRefGrpBundle@servletRequest"/>
                </uix:rowLayout>
              </uix:case>
            </uix:switcher> 
  
          </uix:tableLayout>
        </uix:header>


          

      <!-- PAGE BUTTONS -->
      <uix:pageButtons>
        <uix:pageButtonBar>
          <jsp:include page="/database/schema/pageButtonViewInclude.jsp" />
          <uix:ref refID="pageButtonViewInclude" />
        </uix:pageButtonBar>
      </uix:pageButtons>

      </uix:pageLayout>
    </db:form>
   </uix:body>
  </uix:document>
</uix:renderingContext>




