<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<% oracle.cabo.share.util.CaboHttpUtils.setNoCacheHeaders(response); %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">
    <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
    <uix:bundle name="dblinkMsgs" class="oracle.sysman.db.rsc.schm.DbLinkMsg"/>
    <oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="SEARCH_AND_SELECT_HEADER@dbMsgs"/>
       <script language="JavaScript" >
        <%@ include file="/database/utils.js"%>
        </script>
      <script language="JavaScript" >
        <%@ include file="/cabo/jsLibs/TableProxy.js" %>
      </script>

      <script>
        function lovSelect(lovField)
        {
          var proxy = new TableProxy('dblinkDataSource');
          var selectedIndex = proxy.getSelectedRow();
          if (selectedIndex >= 0)
          {
            var selectedElement = proxy.getFormElement('DBLink', selectedIndex);
            lovField.value = selectedElement.value;
            window.close();
          }
        }
      </script>

    </uix:metaContainer>
    <uix:body>

   <db:form name="foo" 
            destinationBinding="destination@objectBean@servletRequest"
            copyParams="target,type,cancelURL,sname,oname,otype">
      <%--uix:pageLayout titleBinding="SEL_REF_SCHEMA_OBJECT_HEADER@synMsgs"--%>
      <uix:pageLayout titleBinding="SEARCH_SEL_DB_LINK@dbMsgs">
        <uix:formValue name="pageName" value="/database/schema/selectDBLinkPage"/>

        <uix:tableLayout cellSpacing="2">
	  <uix:rowLayout>
	      <uix:stackLayout>
	        <uix:header  textBinding="SEARCH@dbMsgs">
	          <uix:styledText textBinding="TO_FIND_ITEM@dbMsgs"/>
	          <uix:rowLayout>
	            <uix:textInput name="dblinkSearchCriteria" 
                                   textBinding="dblinkSearchCriteria@objectBean@servletRequest"/>
	            <uix:submitButton textBinding="GO@dbMsgs" 
                                      name="event" value="changeDBLinkSearchCriteria"/>
	          </uix:rowLayout>
	        </uix:header>
	      </uix:stackLayout>
	  </uix:rowLayout>

	  <uix:rowLayout>
              <uix:stackLayout>
	        <uix:header textBinding="RESULTS@dbMsgs">
                  <oem:table name="dblinkDataSource" beanKey="objectBean" blockSize="10"
                             destinationBinding="destination@objectBean@servletRequest" 
                             formSubmitted="true"
                             dataSourceProp="dblinkDataSource" width="90%" 
                             summaryBinding="RESULTS@dbMsgs"
			     alternateTextBinding="NO_ITEMS_FOUND@dbMsgs">
                     <uix:tableSelection>
                       <uix:singleSelection shortDescBinding="SELECT_A_VALUE@dbMsgs"
                                            selectedIndex="0"/>
                     </uix:tableSelection>
                  </oem:table>
	        </uix:header>
	      </uix:stackLayout>
	  </uix:rowLayout>
	</uix:tableLayout>

       <uix:pageButtons>
          <uix:pageButtonBar>
            <uix:button textBinding="CANCEL@dbMsgs" destination="javascript:self.close()" />
            <uix:button textBinding="SELECT@dbMsgs"
                        destinationBinding="selectDBLinkDestination@servletRequest"/>
         </uix:pageButtonBar>
       </uix:pageButtons>

     </uix:pageLayout>
   </db:form>
   </uix:body>
  </uix:document>
</uix:renderingContext>
