<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:       selectQueuePage.jsp
  -- Controller: db/adm/schm/*Controller.java - used by several controllers
  -- Description: Queue LOV used be several of the queue objects - usually 
  --              only available on CREATE.
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<% oracle.cabo.share.util.CaboHttpUtils.setNoCacheHeaders(response); %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>


<uix:renderingContext id="renderingContext">
    <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
    <uix:bundle name="ScheduleEventBundle"
          class="oracle.sysman.db.rsc.inst.SchedulesMsg"/>

    <oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="SEARCH_AND_SELECT_HEADER@dbMsgs"/>
       <script language="JavaScript" >
        <%@ include file="/database/utils.js"%>
        </script>
      <script language="JavaScript" >
        <%@ include file="/cabo/jsLibs/TableProxy.js" %>
      </script>

      <script>
        function lovSelect()
        {
          var proxy = new TableProxy('queueDataSource');
          var selectedIndex = proxy.getSelectedRow();
              if (selectedIndex >= 0)
          {
            var selectedElement = proxy.getFormElement('Hidden', selectedIndex);
	    window.opener.lovCallBack(selectedElement.value);
            window.close();
          }
        }
      </script>
    </uix:metaContainer>
    <uix:body>

   <db:form name="foo" 
            destinationBinding="destination@objectBean@servletRequest"
            copyParams="target,type,cancelURL,sname,oname,otype">
      <uix:pageLayout titleBinding="SEARCH_AND_SELECT_QUEUE@ScheduleEventBundle">
        <uix:formValue name="pageName" value="/database/schema/selectQueuePage"/>


          <uix:tableLayout cellSpacing="2">

            <%-- Search Criteria and Instruction --%>
            <uix:rowLayout>
	            <uix:stackLayout>
	              <uix:header textBinding="SEARCH@dbMsgs">
	                <uix:rowLayout>
	                  <uix:messageTextInput id="queueSearchCriteria"
                                         name="queueSearchCriteria" 
                                     promptBinding="SEARCH_FOR_QUEUE@ScheduleEventBundle"
                                     shortDescBinding="SEARCH_FOR_QUEUE@ScheduleEventBundle"
                                         textBinding="queueSearchCriteria@objectBean@servletRequest"/>
	                  <uix:submitButton textBinding="GO@dbMsgs" name="event" 
                                            value="changeQueueSearchCriteria" />
	                </uix:rowLayout>
	              </uix:header>
	            </uix:stackLayout>
	        </uix:rowLayout>
	        <uix:rowLayout>
                <uix:stackLayout>
                  <uix:header textBinding="RESULT@dbMsgs">
                    <oem:table name="queueDataSource" beanKey="objectBean" blockSize="25"
                        destinationBinding="destination" formSubmitted="true"
                        dataSourceProp="queueDataSource" width="90%" 
                        summaryBinding="RESULT@dbMsgs"
                        alternateTextBinding="NO_ITEMS_FOUND@dbMsgs">
                        <uix:tableSelection>
                          <uix:singleSelection shortDescBinding="SELECT_A_VALUE@dbMsgs"
                                               selectedIndex="0"/>
                        </uix:tableSelection>
                    </oem:table>
	              </uix:header>
	            </uix:stackLayout>
	        </uix:rowLayout>
	      </uix:tableLayout>

        <uix:pageButtons>
          <uix:pageButtonBar>
            <uix:button textBinding="CANCEL@dbMsgs" destination="javascript:self.close()" />
            <uix:button textBinding="SELECT@dbMsgs" destinationBinding="selectQueueDestination@servletRequest"/>
         </uix:pageButtonBar>
        </uix:pageButtons>
     </uix:pageLayout>
   </db:form>
   </uix:body>
  </uix:document>
</uix:renderingContext>

