<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:       selectSchemaObjectPage.jsp
  -- Controller: db/adm/schm/*Controller.java - used by several controllers
  --
  -- Description: LOV that lets users search and select a schema.object combination.
  --              An example of this being used can be seen by looking at the 
  --              Table object's Add Foreign Key Constriant page, this is the 
  --              LOV that allows the user to select a referenced table.
  --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<% oracle.cabo.share.util.CaboHttpUtils.setNoCacheHeaders(response); %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>


<uix:renderingContext id="renderingContext">
    <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
    <oem:setURLEncoder id="renderingContext"/>

  <uix:document>
    <uix:metaContainer>
      <uix:head titleBinding="SEARCH_AND_SELECT_HEADER@dbMsgs"/>
       <script language="JavaScript" >
        <%@ include file="/database/utils.js"%>
        </script>
      <script language="JavaScript" >
        <%@ include file="/cabo/jsLibs/TableProxy.js" %>
      </script>

      <script>
        function lovSelectSubmit()
        {
          var destField="onSchemaAndObject";
          if (window.opener.callBackLov != null)
            destField=window.opener.callBackLov();
          lovSelect(eval("window.opener.document.forms[0]."+destField));
        }
        function lovSelect(lovField)
        {
          var proxy = new TableProxy('schemaObjectUIDataSource');
          var selectedIndex = proxy.getSelectedRow();
          if (selectedIndex >= 0)
          {
            var selectedElement=proxy.getFormElement('Object', selectedIndex);
            lovField.value=selectedElement.value;
            window.close();
          }
        }
      </script>
    </uix:metaContainer>
    <uix:body>

   <db:form name="foo" 
            destinationBinding="destination@objectBean@servletRequest"
            copyParams="target,type,cancelURL,sname,oname,otype">
      <uix:pageLayout titleBinding="selectSchemaObjectHeader@objectBean@servletRequest">
        <uix:formValue name="pageName" value="/database/schema/selectSchemaObjectPage"/>

          <uix:tableLayout cellSpacing="2">

              <%-- Search Criteria and Instruction --%>
              <uix:rowLayout>
              <uix:header  textBinding="SEARCH@dbMsgs">
                <uix:rowLayout>
                  <uix:tableLayout cellSpacing="4">
                    <uix:rowLayout hAlign="left">
                      <uix:cellFormat vAlign="top">
                          <uix:messageTextInput name="searchSchemaName" 
                                                      promptBinding="SCHEMA_NAME_COLON@dbMsgs"
                                                      shortDescBinding="SCHEMA_NAME_COLON@dbMsgs"
                                                      textBinding="searchSchemaName@objectBean@servletRequest"/> 
                      </uix:cellFormat>
                      <uix:cellFormat vAlign="top">
                          <uix:rowLayout>
                            <uix:messageTextInput name="searchObjectName" 
                                                  promptBinding="objectColumnText@objectBean@servletRequest"
                                                  shortDescBinding="objectColumnText@objectBean@servletRequest"
                                                  textBinding="searchObjectName@objectBean@servletRequest"/> 
                            <uix:submitButton  textBinding="GO@dbMsgs"
                                              name="event" value="searchSchemaObject"/> 
                          </uix:rowLayout>
                      </uix:cellFormat>
                    </uix:rowLayout>
                  </uix:tableLayout>
                </uix:rowLayout>
              </uix:header>
            </uix:rowLayout>
            <%-- End Search Criteria and Instruction --%>

            <uix:rowLayout>
              <uix:switcher childNameBinding="showSearchResults@objectBean@servletRequest">
                <uix:case name="true">
                  <uix:header  textBinding="RESULTS@dbMsgs">
                    <uix:rowLayout width="80%">
                      <oem:table name="schemaObjectUIDataSource" blockSize="25"
                                 destinationBinding="destination" formSubmitted="true"
                                 dataSourceProp="schemaObjectUIDataSource" width="100%"
                                 summaryBinding="RESULTS@dbMsgs"
        		         alternateTextBinding="NO_ITEMS_FOUND@dbMsgs"
                                 copyParams="target,type,cancelURL,sname,oname,otype">
                        <uix:tableSelection>
                          <uix:singleSelection shortDescBinding="SELECT_A_VALUE@dbMsgs"
                                               selectedIndex="0"/>
                        </uix:tableSelection>
                      </oem:table>
                    </uix:rowLayout>
                  </uix:header>
                </uix:case>
              </uix:switcher>
            </uix:rowLayout>
          </uix:tableLayout>

        <uix:pageButtons>
          <uix:pageButtonBar>
            <uix:button textBinding="CANCEL@dbMsgs" destination="javascript:self.close()" />
            <uix:button textBinding="SELECT@dbMsgs" destination="javascript:lovSelectSubmit()" />
         </uix:pageButtonBar>
        </uix:pageButtons>
     </uix:pageLayout>
   </db:form>
   </uix:body>
  </uix:document>
</uix:renderingContext>

