<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:       selectSchemaPage.jsp
  -- Controller: db/adm/schm/*Controller.java - used by several controllers
  -- Description: Schema LOV used be several of the schema objects - usually 
  --              only available on CREATE.
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<% oracle.cabo.share.util.CaboHttpUtils.setNoCacheHeaders(response); %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">
    <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
    <oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="SEARCH_AND_SELECT_HEADER@dbMsgs"/>
       <script language="JavaScript" >
        <%@ include file="/database/utils.js"%>
        </script>
      <script language="JavaScript" >
        <%@ include file="/cabo/jsLibs/TableProxy.js" %>
      </script>

      <script>
        function lovSelect(lovField)
        {
          var proxy = new TableProxy('schemaDataSource');
          var selectedIndex = proxy.getSelectedRow();
              if (selectedIndex >= 0)
          {
            var selectedElement = proxy.getFormElement('Hidden', selectedIndex);
            lovField.value = selectedElement.value;
            window.close();
          }
        }
      </script>
    </uix:metaContainer>
    <uix:body>

   <db:form name="foo" 
            destinationBinding="destination@objectBean@servletRequest"
            copyParams="target,type,cancelURL,sname,oname,otype">
      <uix:pageLayout titleBinding="SEARCH_AND_SELECT_SCHEMA@dbMsgs">
        <uix:formValue name="pageName" value="/database/schema/selectSchemaPage"/>


          <uix:tableLayout cellSpacing="2">

            <%-- Search Criteria and Instruction --%>
            <uix:rowLayout>
	            <uix:stackLayout>
	              <uix:header textBinding="SEARCH@dbMsgs">
	                <uix:rowLayout>
	                  <uix:messageTextInput id="schemaSearchCriteria"
                                         name="schemaSearchCriteria" 
                                     promptBinding="SEARCH_FOR_SCHEMA@dbMsgs"
                                     shortDescBinding="SEARCH_FOR_SCHEMA@dbMsgs"
                                         textBinding="schemaSearchCriteria@objectBean@servletRequest"/>
	                  <uix:submitButton textBinding="GO@dbMsgs" name="event" 
                                            value="changeSchemaSearchCriteria"/>
	                </uix:rowLayout>
	              </uix:header>
	            </uix:stackLayout>
	        </uix:rowLayout>
	        <uix:rowLayout>
                <uix:stackLayout>
                  <uix:header textBinding="RESULT@dbMsgs">
                    <oem:table name="schemaDataSource" beanKey="objectBean" blockSize="10"
                        destinationBinding="destination" formSubmitted="true"
                        dataSourceProp="schemaDataSource" width="90%" 
                        summaryBinding="RESULT@dbMsgs"
                        alternateTextBinding="NO_ITEMS_FOUND@dbMsgs">
                        <uix:tableSelection>
                          <uix:singleSelection shortDescBinding="SELECT_A_VALUE@dbMsgs"
                                               selectedIndex="0"/>
                        </uix:tableSelection>
                    </oem:table>
	              </uix:header>
	            </uix:stackLayout>
	        </uix:rowLayout>
	      </uix:tableLayout>

        <uix:pageButtons>
          <uix:pageButtonBar>
            <uix:button textBinding="CANCEL@dbMsgs" destination="javascript:self.close()" />
            <uix:button textBinding="SELECT@dbMsgs" destinationBinding="selectSchemaDestination@servletRequest"/>
         </uix:pageButtonBar>
        </uix:pageButtons>
     </uix:pageLayout>
   </db:form>
   </uix:body>
  </uix:document>
</uix:renderingContext>

