<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%--
  -- Page:       selectTablespacePage.jsp
  -- Controller: db/adm/schm/*Controller.java - used by several controllers
  -- Description: Tablespace LOV used be several of the schema objects - usually 
  --              only available on CREATE.
  --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<% oracle.cabo.share.util.CaboHttpUtils.setNoCacheHeaders(response); %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">
    <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
    <oem:setURLEncoder id="renderingContext"/>

  <uix:document>
    <uix:metaContainer>
      <uix:head titleBinding="SEARCH_AND_SELECT_HEADER@dbMsgs"/>
       <script language="JavaScript" >
        <%@ include file="/database/utils.js"%>
        </script>
      <script language="JavaScript" >
        <%@ include file="/cabo/jsLibs/TableProxy.js" %>
      </script>

      <script>
        function lovSelect(lovField)
        {
          var appendData = "";
          var proxy = new TableProxy('tablespaceDataSource');
          var selectedIndex = proxy.getSelectedRow();
          if (selectedIndex >= 0)
          {
            var selectedElement = proxy.getFormElement('Hidden', selectedIndex);
	    if ((lovField == null) && (window.opener.callBackLov != null))
            {
              lovField=eval("window.opener.document.forms[0]."+window.opener.callBackLov());
              if ((window.opener.isAppendData != null) && window.opener.isAppendData() && ((s=lovField.value).length > 0))
                  appendData = s + ",";
            }
            lovField.value = appendData + selectedElement.value;
            window.close();
          }
        }
      </script>

     </uix:metaContainer>
   <uix:body>

   <db:form name="foo" 
            destinationBinding="destination@objectBean@servletRequest" 
            copyParams="target,type,cancelURL,sname,oname,otype,lovName">
      <uix:pageLayout titleBinding="SEARCH_AND_SELECT_TABLESPACE@dbMsgs">
        <uix:formValue name="pageName" value="/database/schema/selectTablespacePage"/>

          <uix:tableLayout cellSpacing="2">

            <%-- Search Criteria and Instruction --%>
	    <uix:rowLayout>
	        <uix:stackLayout>
	          <uix:header textBinding="SEARCH@dbMsgs">
	            <uix:rowLayout>
	              <uix:messageTextInput name="tablespaceSearchCriteria" 
                                     textBinding="tablespaceSearchCriteria@objectBean@servletRequest"
                                     promptBinding="SEARCH_FOR_TABLESPACE@dbMsgs"
                                     shortDescBinding="SEARCH_FOR_TABLESPACE@dbMsgs"/>
	              <uix:submitButton textBinding="GO@dbMsgs" 
                                    shortDescBinding="GO@dbMsgs"
                                    name="event" value="changeTablespaceSearchCriteria"/>
	            </uix:rowLayout>
	          </uix:header>
	        </uix:stackLayout>
	    </uix:rowLayout>
            <%-- End Search Criteria and Instruction --%>

	    <uix:rowLayout>
                <uix:stackLayout>
	          <uix:header textBinding="RESULTS@dbMsgs">
                    <oem:table name="tablespaceDataSource" beanKey="objectBean" blockSize="10"
                               destinationBinding="destination" formSubmitted="true"
                               dataSourceProp="tablespaceDataSource" width="90%"
                               summaryBinding="RESULTS@dbMsgs"
                               alternateTextBinding="NO_ITEMS_FOUND@dbMsgs"
                               copyParams="target,type,cancelURL,sname,oname,otype,lovName">
                        <uix:tableSelection>
                          <uix:singleSelection shortDescBinding="SELECT_A_VALUE@dbMsgs"
                                               selectedIndex="0"/>
                        </uix:tableSelection>
                      </oem:table>
	          </uix:header>
	        </uix:stackLayout>
	    </uix:rowLayout>
	  </uix:tableLayout>

        <uix:pageButtons>
          <uix:pageButtonBar>
            <uix:button textBinding="CANCEL@dbMsgs" destination="javascript:self.close()" shortDescBinding="CANCEL@dbMsgs"/>
            <uix:button textBinding="SELECT@dbMsgs" destinationBinding="selectTablespaceDestination@servletRequest" shortDescBinding="SELECT@dbMsgs"/>
         </uix:pageButtonBar>
        </uix:pageButtons>
     </uix:pageLayout>
   </db:form>
   </uix:body>
  </uix:document>
</uix:renderingContext>

