<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:       selectUserObjectPage.jsp
  -- Controller: db/adm/schm/ObjectTypeController.java
  --
  -- Description: LOV for selecting user defined object types.
  --              This is only available on EDIT of an objectType object.
  --              To see it, add a predefined type and click the LOV on 
  --              the page that pops up.
  --              This maybe could be changed to use the
  --              selectSchemaObjectPage.jsp, which is a more generic version
  --              of this same LOV.
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>
<uix:renderingContext id="renderingContext">
<uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
<oem:setURLEncoder id="renderingContext"/>
<uix:document>

<%-- HTML Page Title --%>
<uix:metaContainer>
  <uix:head titleBinding="SEARCH_SEL_USER_OBJ@dbMsgs"/>
</uix:metaContainer>
<uix:body>
  <db:script src="/database/utils.js"/>
  <db:script src="/cabo/jsLibs/TableProxy.js"/>
  <script>
    function lovSelect(lovField)
    {
      var proxy = new TableProxy('selectUserObjectDataSource');
      var selectedIndex = proxy.getSelectedRow();
      if (selectedIndex >= 0)
      {
        var selectedElement1 = proxy.getFormElement('Schema', selectedIndex);
        var selectedElement2 = proxy.getFormElement('Object', selectedIndex);
        
        lovField.value = selectedElement1.value + "." + selectedElement2.value;
        window.close();
      }
    }
  </script>

<%-- HTML Form --%>
<db:form name="foo"
         method="post"
         destinationBinding="destination@objectBean@servletRequest"
         copyParams="target,type,cancelURL,sname,oname,otype">
<uix:formValue name="pageName" value="/database/schema/selectUserObjectPage"/>
   <uix:pageLayout titleBinding="SEARCH_SEL_USER_OBJ@dbMsgs">
      <uix:stackLayout>
      <uix:tableLayout cellSpacing="10">
              <uix:header textBinding="SEARCH@dbMsgs">
        <uix:rowLayout>
          <uix:styledText textBinding="SEARCH_INSTRUCTIONS@dbMsgs"/>
        </uix:rowLayout>

        <uix:spacer height="5"/> 

        <uix:rowLayout> 
        <uix:cellFormat width="100" hAlign="right"> 
            <uix:messagePrompt labeledNodeId="destLovSchemaName"
                               promptBinding="SCHEMA@dbMsgs"/>
        </uix:cellFormat> 
        <uix:spacer width="5"/> 
            <uix:textInput id="destLovSchemaName"
                           name="destLovSchemaName" 
                           textBinding="destLovSchemaName@objectBean@servletRequest"/>
        </uix:rowLayout>
        <uix:spacer height="5"/> 

        <uix:rowLayout> 
        <uix:cellFormat width="100" hAlign="right"> 
            <uix:messagePrompt labeledNodeId="selectUserObjectSearchCriteria"
                               promptBinding="OBJECT_NAME_COLON@dbMsgs"/>
        </uix:cellFormat> 
        <uix:spacer width="5"/> 
            <uix:textInput id="selectUserObjectSearchCriteria"
                           name="selectUserObjectSearchCriteria" 
                           textBinding="selectUserObjectSearchCriteria@objectBean@servletRequest"/>
        <uix:spacer width="5"/> 
            <uix:submitButton textBinding="GO@dbMsgs"
                              name="event" value="changeSelectUserObjectSearchCriteria"/>
        </uix:rowLayout>
              </uix:header> 

        <uix:rowLayout>
          <uix:cellFormat>
            <uix:stackLayout>
              <uix:header textBinding="RESULTS@dbMsgs">
                <oem:table name="selectUserObjectDataSource" blockSize="10"
                           destinationBinding="destination" formSubmitted="true"
                           dataSourceProp="selectUserObjectDataSource" width="90%"
                           summaryBinding="RESULTS@dbMsgs"
                           alternateTextBinding="NO_ITEMS_FOUND@dbMsgs"
                           copyParams="target,type,cancelURL,sname,oname,otype">
                    <uix:tableSelection>
                      <uix:singleSelection shortDescBinding="SELECT_A_VALUE@dbMsgs"
                                           selectedIndex="0"/>
                    </uix:tableSelection>
                </oem:table>
              </uix:header>
            </uix:stackLayout>
          </uix:cellFormat>
        </uix:rowLayout>
      </uix:tableLayout>
      </uix:stackLayout>

      <uix:pageButtons>
        <uix:pageButtonBar>
          <uix:button textBinding="CANCEL@dbMsgs" destination="javascript:self.close()" />
          <uix:button textBinding="SELECT@dbMsgs" destination="javascript:lovSelect(window.opener.document.foo.OTAttrFullObjectName)"/>
       </uix:pageButtonBar>
      </uix:pageButtons>
     </uix:pageLayout>
   </db:form>
   </uix:body>
  </uix:document>
</uix:renderingContext>

