<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        createSequencePage.jsp
  -- Controller:  db/adm/schm/SequenceController.java
  --
  -- Description: Short Description of the page.
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">
  <uix:bundle name="dbMsgs"
              class="oracle.sysman.db.rsc.DBObjectMsg"/>
  <uix:bundle name="seqMsgs"
              class="oracle.sysman.db.rsc.schm.SequenceMsg"/>
<oem:setURLEncoder id="renderingContext"/>
<uix:document>
<%@ include file="/oemTitle.jspf" %>
<%-- HTML Page Title --%>
<uix:metaContainer>
  <uix:head titleBinding="title@objectBean@servletRequest"/>
  <db:script src="/database/LOV.js"/>
</uix:metaContainer>
<uix:body>  

<%-- HTML Form --%>
<db:form name="foo" 
         method="post"
         destinationBinding="destination@objectBean@servletRequest"
         copyParams="target,type,cancelURL,sname,oname,otype" >
<uix:formValue name="pageName" value="/database/schema/sequence/createSequencePage"/>
<uix:pageLayout titleBinding="header@objectBean@servletRequest">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>

          <uix:contents>
           <uix:header textBinding="GENERAL@seqMsgs">
            <uix:tableLayout cellSpacing="5">

                <%-- name --%>
                <uix:rowLayout>
                    <uix:cellFormat hAlign="right" width="100" wrappingDisabled="true">
                      <uix:contents>
                        <uix:messagePrompt labeledNodeId="objectName"
                                           promptBinding="NAME@dbMsgs" 
                                           required="yes"/>
                      </uix:contents>
                    </uix:cellFormat>
                    <uix:stackLayout>
                      <uix:textInput id="objectName"
                                     name="objectName" 
                                     shortDescBinding="NAME@dbMsgs" 
                                     textBinding="objectName@objectBean@servletRequest" 
                                     columns="30"/>
                      <uix:messageText messageBinding="objectName@errors@servletRequest" messageType="error"/>
                    </uix:stackLayout>
                </uix:rowLayout>

                <%-- schema name --%>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right" width="100" wrappingDisabled="true">
                    <uix:messagePrompt labeledNodeId="schema" promptBinding="SCHEMA@dbMsgs" required="yes"/>
                  </uix:cellFormat>
                  <uix:stackLayout>
                    <uix:messageLovField name="schemaName" 
                                         id="schema"
                                         shortDescBinding="SCHEMA@dbMsgs" 
                                         searchDescBinding="SCHEMA@dbMsgs" 
                                         textBinding="schemaName@objectBean@servletRequest" 
                                         onClick="startLov('schemaName','ListSchema')"/>
                      <uix:messageText messageBinding="schemaName@errors@servletRequest" messageType="error"/>
                  </uix:stackLayout>
                </uix:rowLayout>
            </uix:tableLayout>
           </uix:header>

            <%-- values --%>
            <uix:header textBinding="VALUES@dbMsgs">
              <uix:tableLayout cellSpacing="5">
            	<uix:contents>

 		<%-- maximum value --%>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right" wrappingDisabled="true">
                    <uix:messagePrompt promptBinding="MAXIMUM@uixSequenceBundle@servletRequest" required="yes"/>
                  </uix:cellFormat>

                  <uix:cellFormat>
                    <uix:tableLayout cellSpacing="5">
                      <uix:rowLayout>
                        <uix:cellFormat wrappingDisabled="true">
                          <oem:radioButton name="maxValRadio"
                                           value="false"
                                           textBinding="VALUE@seqMsgs"
                                           selectedValueBinding="useUnlimitedMaxVal@objectBean@servletRequest"/>
                        </uix:cellFormat>
                        <uix:cellFormat wrappingDisabled="true">
                          <uix:stackLayout>
                            <uix:textInput name="maxVal"
                                           textBinding="maxVal@objectBean@servletRequest" 
                                           columns="20"
                                           shortDescBinding="MAXIMUM@uixSequenceBundle@servletRequest">
                              <uix:onSubmitValidater><uix:decimal/></uix:onSubmitValidater>   
                            </uix:textInput>                                            
                            <uix:messageText messageBinding="maxVal@errors@servletRequest" messageType="error"/>
                          </uix:stackLayout>
                        </uix:cellFormat>
                      </uix:rowLayout>
                    </uix:tableLayout>
                  </uix:cellFormat>

                  <uix:cellFormat wrappingDisabled="true">
                    <oem:radioButton name="maxValRadio"
                                     value="true"
                                     textBinding="UNLIMITED@seqMsgs"
                                     selectedValueBinding="useUnlimitedMaxVal@objectBean@servletRequest"/>
                  </uix:cellFormat>
                </uix:rowLayout>


                <%-- minimum value --%>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right" wrappingDisabled="true">
                     <uix:messagePrompt promptBinding="MINIMUM@uixSequenceBundle@servletRequest" required="yes"/>
                  </uix:cellFormat>

                  <uix:cellFormat>
                    <uix:tableLayout cellSpacing="5">
                      <uix:rowLayout>
                        <uix:cellFormat wrappingDisabled="true">
                          <oem:radioButton name="minValRadio"
                                           value="false"
                                           textBinding="VALUE@seqMsgs"
                                           selectedValueBinding="useUnlimitedMinVal@objectBean@servletRequest"/>
                        </uix:cellFormat>
                        <uix:cellFormat wrappingDisabled="true">
                          <uix:stackLayout>
                            <uix:textInput name="minVal" 
                                           textBinding="minVal@objectBean@servletRequest"
                                           columns="20"
                                           shortDescBinding="MINIMUM@uixSequenceBundle@servletRequest">
                              <uix:onSubmitValidater><uix:decimal/></uix:onSubmitValidater>   
                            </uix:textInput>                                            
                            <uix:messageText messageBinding="minVal@errors@servletRequest" messageType="error"/>
                          </uix:stackLayout>
                        </uix:cellFormat>
                      </uix:rowLayout>
                    </uix:tableLayout>
                  </uix:cellFormat>

                  <uix:cellFormat wrappingDisabled="true">
                    <oem:radioButton name="minValRadio"
                                     value="true"
                                     textBinding="UNLIMITED@seqMsgs"
                                     selectedValueBinding="useUnlimitedMinVal@objectBean@servletRequest"/>
                  </uix:cellFormat>
                </uix:rowLayout>

                <%-- interval --%>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right" width="100" wrappingDisabled="true">
                    <uix:messagePrompt labeledNodeId="interval"
                                       promptBinding="INTERVAL@uixSequenceBundle@servletRequest" 
                                       required="yes"/>
                  </uix:cellFormat>
                  <uix:stackLayout>
                    <uix:textInput id="interval"
                                   name="interval" 
                                   shortDescBinding="INTERVAL@uixSequenceBundle@servletRequest" 
                                   textBinding="interval@objectBean@servletRequest" 
                                   columns="30">
                      <uix:onSubmitValidater><uix:decimal/></uix:onSubmitValidater>   
                    </uix:textInput>                                            
                    <uix:messageText messageBinding="interval@errors@servletRequest" messageType="error"/>
                  </uix:stackLayout>
                </uix:rowLayout>

                <%-- initial --%>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right" width="100" wrappingDisabled="true">
                    <uix:messagePrompt labeledNodeId="initial"
                                       promptBinding="INITIAL@uixSequenceBundle@servletRequest" 
                                       required="yes"/>
                  </uix:cellFormat>
                  <uix:stackLayout>
                    <uix:textInput id="initial"
                                   name="initial" 
                                   shortDescBinding="INITIAL@uixSequenceBundle@servletRequest" 
                                   textBinding="initial@objectBean@servletRequest"
                                   columns="30">
                      <uix:onSubmitValidater><uix:decimal/></uix:onSubmitValidater>   
                    </uix:textInput>                                            
                    <uix:messageText messageBinding="initial@errors@servletRequest" messageType="error"/>
                  </uix:stackLayout>
                </uix:rowLayout>


                <uix:rowLayout>
            	  <uix:spacer height="2"/>
                </uix:rowLayout>
              </uix:contents>
            </uix:tableLayout>
           </uix:header>

	    <%--- options ---%>
            <uix:header textBinding="OPTIONS@dbMsgs">
	      <uix:tableLayout cellSpacing="5">
            	<uix:contents>

                <uix:rowLayout>
                  <uix:stackLayout>
               	    <uix:checkBox name="cycle" 
                                  textBinding="CYCLE_VALUES_CHECKBOX@uixSequenceBundle@servletRequest"
                                  checkedBinding="cycle@objectBean@servletRequest"/>
               	    <uix:checkBox name="order" 
                                  textBinding="ORDER_VALUES_CHECKBOX@uixSequenceBundle@servletRequest"
                                  checkedBinding="order@objectBean@servletRequest" />
                  </uix:stackLayout>
                </uix:rowLayout>


                <uix:rowLayout>
            	  <uix:spacer height="2"/>
                </uix:rowLayout>

             </uix:contents>
            </uix:tableLayout>
           </uix:header>

            <%--- cache ---%>
            <uix:header textBinding="CACHE_OPTIONS@uixSequenceBundle@servletRequest">
	       <uix:tableLayout cellSpacing="5">

               <uix:rowLayout>
                  <uix:cellFormat columnSpan="5" hAlign="left" width="100%">
                     <contents>
                         <uix:checkBox name="useCache"
                               checkedBinding="useCache@objectBean@servletRequest"
                               textBinding="USE_CACHE@seqMsgs"/>
                     </contents>
                  </uix:cellFormat>
               </uix:rowLayout>
               <uix:rowLayout>
                 <uix:cellFormat hAlign="right" width="100">
                   <uix:messagePrompt labeledNodeId="cache"
                                      promptBinding="CACHE_SIZE@seqMsgs"/>
                 </uix:cellFormat>
                 <uix:textInput id="cache"
                                name="cache" 
                                shortDescBinding="CACHE_SIZE@seqMsgs" 
                                columns="10"
                                text="20">
                   <uix:onSubmitValidater><uix:decimal/></uix:onSubmitValidater>   
                 </uix:textInput>                                            
               </uix:rowLayout>

              </uix:tableLayout>
             </uix:header>
            <uix:spacer height="2"/>
           </uix:contents>

  <%-- Create/Edit Buttons --%>
  <uix:pageButtons>
  <uix:pageButtonBar>
    <jsp:include page="/database/schema/pageButtonInclude.jsp" />
    <uix:ref refID="pageButtonInclude" />
  </uix:pageButtonBar>
  </uix:pageButtons>

</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>

</uix:body>
</uix:document>
</uix:renderingContext>
<%-- END: Content --%>
