<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        editSequencePage.jsp
  -- Controller:  db/adm/schm/SequenceController.java
  --
  -- Description: Short Description of the page.
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>
<uix:renderingContext id="renderingContext">
  <uix:bundle name="seqMsgs"
              class="oracle.sysman.db.rsc.schm.SequenceMsg"/>
<oem:setURLEncoder id="renderingContext"/>
<uix:document>
<%@ include file="/oemTitle.jspf" %>

<%-- HTML Page Title --%>
<uix:metaContainer>
  <uix:head titleBinding="title@objectBean@servletRequest"/>
  <db:script src="/database/utils.js"/>   <%-- lovField support --%>
</uix:metaContainer>
<uix:body>

<%-- HTML Form --%>
<db:form name="foo"
         method="post"
         destinationBinding="destination@objectBean@servletRequest"
         copyParams="target,type,cancelURL,sname,oname,otype" >
<uix:formValue name="pageName" value="/database/schema/sequence/editSequencePage"/>
<uix:pageLayout titleBinding="header@objectBean@servletRequest">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>

          <uix:contents>
            <%-- uix:header beanKey="objectBean" textBinding="header" --%>
            <uix:header textBinding="GENERAL@seqMsgs">
            <uix:tableLayout cellSpacing="5">

                <%-- name --%>
                <uix:rowLayout>
                  <uix:contents>
                    <uix:cellFormat hAlign="right" width="100">
                      <uix:contents>
                        <uix:messagePrompt promptBinding="NAME@uixDBObjectBundle@servletRequest"/>
                      </uix:contents>
                    </uix:cellFormat>
                    <uix:styledText styleClass="OraDataText" textBinding="objectName@objectBean@servletRequest"/>
                  </uix:contents>
                </uix:rowLayout>

                <%-- schema name --%>
                <uix:rowLayout>
                  <uix:contents>
                    <uix:cellFormat hAlign="right" width="100">
                      <uix:contents>
                        <uix:messagePrompt promptBinding="SCHEMA@uixDBObjectBundle@servletRequest"/>
                      </uix:contents>
                    </uix:cellFormat>
                    <uix:styledText styleClass="OraDataText" textBinding="schemaName@objectBean@servletRequest"/>
                  </uix:contents>
                </uix:rowLayout>
              </uix:tableLayout>
            </uix:header>

             <%-- values --%>
             <uix:header textBinding="VALUES@uixDBObjectBundle@servletRequest">
	       <uix:tableLayout cellSpacing="5">

 		<%-- maximum value --%>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right" width="100">
                    <uix:messagePrompt promptBinding="MAXIMUM@uixSequenceBundle@servletRequest"/>
                  </uix:cellFormat>

                  <uix:cellFormat>
                    <oem:radioButton name="maxValRadio" 
                                     value="false"
                                     textBinding="VALUE@seqMsgs"
                                     selectedValueBinding="useUnlimitedMaxVal@objectBean@servletRequest"/>
                    <uix:spacer width="2"/>
                    <uix:textInput name="maxVal" 
                                   disabled="false"
                                   textBinding="maxVal@objectBean@servletRequest" 
                                   columns="20"
                                   shortDescBinding="MAXIMUM@uixSequenceBundle@servletRequest">
                      <uix:onSubmitValidater><uix:decimal/></uix:onSubmitValidater>
                    </uix:textInput>
                  </uix:cellFormat>
                  <uix:messageText messageBinding="maxVal@errors@servletRequest" messageType="error"/>
                  <uix:spacer width="5"/>
                  <uix:cellFormat>
                    <oem:radioButton name="maxValRadio" 
                                     value="true"
                                     textBinding="UNLIMITED@seqMsgs"
                                     selectedValueBinding="useUnlimitedMaxVal@objectBean@servletRequest"/>
                  </uix:cellFormat>
                </uix:rowLayout>


                 <%-- minimum value --%>
                 <uix:rowLayout>
                   <uix:cellFormat hAlign="right" width="100" >
                     <uix:messagePrompt promptBinding="MINIMUM@uixSequenceBundle@servletRequest"/>
                   </uix:cellFormat>

                   <uix:cellFormat>
                     <oem:radioButton name="minValRadio" 
                                      value="false"
                                      textBinding="VALUE@seqMsgs"
                                      selectedValueBinding="useUnlimitedMinVal@objectBean@servletRequest"/>
                    <uix:spacer width="2"/>
                    <uix:textInput name="minVal" 
                                   textBinding="minVal@objectBean@servletRequest"
                                   columns="20"
                                   shortDescBinding="MINIMUM@uixSequenceBundle@servletRequest">
                      <uix:onSubmitValidater><uix:decimal/></uix:onSubmitValidater>
                   </uix:textInput>
                   </uix:cellFormat>
                  <uix:messageText messageBinding="minVal@errors@servletRequest" messageType="error"/>
                  <uix:spacer width="5"/>
                  <uix:cellFormat>
                    <oem:radioButton name="minValRadio" 
                                     value="true"
                                     textBinding="UNLIMITED@seqMsgs"
                                     selectedValueBinding="useUnlimitedMinVal@objectBean@servletRequest"/>
                  </uix:cellFormat>
                </uix:rowLayout>

	         <%-- interval --%>
                 <uix:rowLayout>
                     <uix:cellFormat hAlign="right" width="100">
                       <uix:messagePrompt labeledNodeId="interval"
                                          promptBinding="INTERVAL@uixSequenceBundle@servletRequest"/>
                     </uix:cellFormat>
                     <uix:textInput id="interval"
                                    name="interval" textBinding="interval@objectBean@servletRequest"
                                    columns="30">
                       <uix:onSubmitValidater><uix:decimal/></uix:onSubmitValidater>   
                     </uix:textInput>
                     <uix:messageText messageBinding="interval@errors@servletRequest" messageType="error"/>
                 </uix:rowLayout>


                  <uix:contents>
                      <uix:spacer width="20"/>
                  </uix:contents>

                <%-- Initial --%>
                <uix:rowLayout>
                    <uix:cellFormat hAlign="right" width="100">
                      <uix:messagePrompt labeledNodeId="lastNumber"
                                         promptBinding="LAST_NUMBER@uixSequenceBundle@servletRequest"/>
                    </uix:cellFormat>
                    <uix:textInput id="lastNumber"
                                   disabled="true" 
                                   textBinding="last@objectBean@servletRequest">
                      <uix:onSubmitValidater><uix:decimal /></uix:onSubmitValidater>
                    </uix:textInput>
                </uix:rowLayout>


                <uix:rowLayout>
          	  <uix:contents>
            	    <uix:spacer height="2"/>
                  </uix:contents>
                </uix:rowLayout>

            </uix:tableLayout>
           </uix:header>

	    <%--- options ---%>
            <uix:header textBinding="OPTIONS@uixDBObjectBundle@servletRequest">
	      <uix:tableLayout cellSpacing="5">
            	<uix:contents>

                <uix:rowLayout>
                  <uix:stackLayout>
            	    <uix:contents>
               	      <uix:checkBox name="cycle" 
                                    textBinding="CYCLE_VALUES_CHECKBOX@uixSequenceBundle@servletRequest"
                                    checkedBinding="cycle@objectBean@servletRequest" />
               	      <uix:checkBox name="order" 
                                    textBinding="ORDER_VALUES_CHECKBOX@uixSequenceBundle@servletRequest"
                                    checkedBinding="order@objectBean@servletRequest" />
                    </uix:contents>
                  </uix:stackLayout>
        	</uix:rowLayout>

             </uix:contents>
            </uix:tableLayout>
           </uix:header>


            <%--- cache ---%>
            <uix:header textBinding="CACHE_OPTIONS@uixSequenceBundle@servletRequest">
	      <uix:tableLayout cellSpacing="5">
               <uix:rowLayout>
                 <uix:checkBox name="useCache" 
                               checkedBinding="useCache@objectBean@servletRequest"
                               textBinding="USE_CACHE@seqMsgs"/>
               </uix:rowLayout>
               <uix:rowLayout>
                 <uix:cellFormat hAlign="right" width="100">
                   <uix:messagePrompt labeledNodeId="cache"
                                      promptBinding="CACHE_SIZE@seqMsgs"/>
                 </uix:cellFormat>
                 <uix:textInput id="cache"
                                name="cache" 
                                columns="10"
                                textBinding="cache@objectBean@servletRequest">
                   <uix:onSubmitValidater><uix:decimal/></uix:onSubmitValidater>   
                 </uix:textInput>
               </uix:rowLayout>


            </uix:tableLayout>
          </uix:header>

            <uix:spacer height="5"/>
          </uix:contents>

  <%-- Create/Edit Buttons --%>
  <uix:pageButtons>
  <uix:pageButtonBar>
    <jsp:include page="/database/schema/pageButtonInclude.jsp" />
    <uix:ref refID="pageButtonInclude" />
  </uix:pageButtonBar>
  </uix:pageButtons>

</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>

</uix:body>
</uix:document>
</uix:renderingContext>
<%-- END: Content --%>
