<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        viewSequencePage.jsp
  -- Controller:  db/adm/schm/SequenceController.java
  --
  -- Description: Short Description of the page.
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<NOSCRIPT>
A browser with Javascript enabled is required for this page to operate properly.
</NOSCRIPT>

<jsp:useBean id="objectBean" scope="request"
   type="oracle.sysman.emo.adm.schema.sequence.Sequence"/>

<uix:renderingContext id="renderingContext">
  <uix:bundle name="dbMsgs"
              class="oracle.sysman.db.rsc.DBObjectMsg"/>
  <uix:bundle name="seqMsgs"
              class="oracle.sysman.db.rsc.schm.SequenceMsg"/>
<oem:setURLEncoder id="renderingContext"/>
<uix:document>
<%@ include file="/oemTitle.jspf" %>
<%-- HTML Page Title --%>
<uix:metaContainer>
  <uix:head titleBinding="title@objectBean@servletRequest"/>
  <db:script src="/database/utils.js"/>   <%-- lovField support --%>
</uix:metaContainer>
<uix:body>  

<%-- HTML Form --%>
<db:form name="foo" 
         method="post"
         destinationBinding="destination@objectBean@servletRequest"
         copyParams="target,type,cancelURL,sname,oname,otype" >
<uix:formValue name="pageName" value="/database/schema/sequence/viewSequencePage"/>
<uix:pageLayout titleBinding="header@objectBean@servletRequest">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>

          <uix:contents>
           <uix:header textBinding="GENERAL@seqMsgs">
            <uix:tableLayout cellSpacing="5">
              <uix:contents>

                <%-- name --%>
                <uix:rowLayout>
                  <uix:contents>
                    <uix:cellFormat hAlign="right" width="100">
                      <uix:contents>
                        <uix:messagePrompt promptBinding="NAME@uixDBObjectBundle@servletRequest"/>
                      </uix:contents>
                    </uix:cellFormat>
                    <uix:styledText styleClass="OraDataText" textBinding="objectName@objectBean@servletRequest"/>
                  </uix:contents>
                </uix:rowLayout>

                <%-- schema name --%>
                <uix:rowLayout>
                  <uix:contents>
                    <uix:cellFormat hAlign="right" width="100">
                      <uix:contents>
                        <uix:messagePrompt promptBinding="SCHEMA@uixDBObjectBundle@servletRequest"/>
                      </uix:contents>
                    </uix:cellFormat>
                    <uix:styledText styleClass="OraDataText" textBinding="schemaName@objectBean@servletRequest"/>
                  </uix:contents>
                </uix:rowLayout>

                <%--- type --%>
                <uix:rowLayout>
  		  <uix:contents>
                    <uix:cellFormat hAlign="right" width="100">
                      <uix:contents>
		        <uix:messagePrompt promptBinding="TYPE@uixSequenceBundle@servletRequest"/>
      		      </uix:contents>
    		    </uix:cellFormat>
                    <uix:styledText styleClass="OraDataText" textBinding="typeText@objectBean@servletRequest"/>
  		  </uix:contents>
             	</uix:rowLayout>

                <uix:rowLayout>
          	  <uix:contents>
            	    <uix:spacer height="1"/>
          	  </uix:contents>
                </uix:rowLayout>

              </uix:contents>
            </uix:tableLayout>
            </uix:header>

            <%-- values --%>
            <uix:header textBinding="VALUES@uixDBObjectBundle@servletRequest">
              <uix:tableLayout cellSpacing="5">
                <uix:contents>
               
 	         <%-- maximum value --%>
                 <uix:rowLayout>
                   <uix:cellFormat hAlign="right" width="100">
                     <uix:messagePrompt promptBinding="MAXIMUM@dbMsgs"/> 
                   </uix:cellFormat>
	           <uix:styledText styleClass="OraDataText" textBinding="maxValText@objectBean@servletRequest"/>
                 </uix:rowLayout>

                 <%-- minimum value --%>
                 <uix:rowLayout>
                   <uix:contents>
                    <uix:cellFormat hAlign="right" width="100">
                      <uix:contents>
                        <uix:messagePrompt promptBinding="MINIMUM@dbMsgs"/>
                      </uix:contents>
                    </uix:cellFormat>
		    <uix:styledText styleClass="OraDataText" textBinding="minValText@objectBean@servletRequest"/>
                   </uix:contents>
                 </uix:rowLayout>

	         <%-- interval --%>
                 <uix:rowLayout>
                   <uix:contents>
                     <uix:cellFormat hAlign="right" width="100">
                       <uix:contents>
                         <uix:messagePrompt promptBinding="INTERVAL@uixSequenceBundle@servletRequest"/>
                       </uix:contents>
                     </uix:cellFormat>
                     <uix:styledText styleClass="OraDataText" textBinding="interval@objectBean@servletRequest"/>
                   </uix:contents>
                 </uix:rowLayout>


                 <%-- last --%>
                 <uix:rowLayout>
                   <uix:contents>
                     <uix:cellFormat hAlign="right" width="100">
                       <uix:contents>
                         <uix:messagePrompt promptBinding="LAST_NUMBER@uixSequenceBundle@servletRequest"/>
                       </uix:contents>
                     </uix:cellFormat>
		     <uix:styledText styleClass="OraDataText" textBinding="last@objectBean@servletRequest"/>
                   </uix:contents>
                 </uix:rowLayout>

                 <uix:rowLayout>
            	   <uix:spacer height="1"/>
                 </uix:rowLayout>

          	</uix:contents>
               </uix:tableLayout>
              </uix:header>


		<%--- options ---%>
                <uix:header textBinding="OPTIONS@uixDBObjectBundle@servletRequest" 
                            rendered="<%=objectBean.getHasOptions()%>">
                  <uix:tableLayout cellSpacing="5">

                      <uix:rowLayout>
                         <uix:switcher childNameBinding="cycle@objectBean@servletRequest">
                           <uix:case name="true">
                              <uix:messagePrompt promptBinding="CYCLE_VALUES_CHECKBOX@uixSequenceBundle@servletRequest"/>
                           </uix:case>
                         </uix:switcher> 
                      </uix:rowLayout>
                      <uix:rowLayout>
                         <uix:switcher childNameBinding="order@objectBean@servletRequest">
                           <uix:case name="true">
                              <uix:messagePrompt promptBinding="ORDER_VALUES_CHECKBOX@uixSequenceBundle@servletRequest"/>
                           </uix:case>
                         </uix:switcher> 
                      </uix:rowLayout>

                      <uix:rowLayout>
            	        <uix:spacer height="1"/>
                      </uix:rowLayout>

            	  </uix:tableLayout>
                 </uix:header>

                 <%-- cache --%>
                 <uix:header textBinding="CACHE@uixDBObjectBundle@servletRequest">
	           <uix:tableLayout cellSpacing="5">

                         <uix:switcher childNameBinding="useCache@objectBean@servletRequest">
                           <uix:case name = "true">
                            <uix:rowLayout>
                             <uix:cellFormat hAlign="right" width="100">
                               <uix:messagePrompt promptBinding="CACHE_SIZE@seqMsgs"/>
                             </uix:cellFormat>
                             <uix:cellFormat> 
		               <uix:styledText styleClass="OraDataText" textBinding="cache@objectBean@servletRequest"/>
                             </uix:cellFormat>
                            </uix:rowLayout>
                           </uix:case>
                           <uix:case name = "false">
                            <uix:rowLayout>
                             <uix:cellFormat hAlign="right" width="100">
		               <uix:styledText styleClass="OraDataText" textBinding="NO_CACHE@seqMsgs"/>
                             </uix:cellFormat>
                            </uix:rowLayout>
                           </uix:case>
                         </uix:switcher> 

                   </uix:tableLayout>
                  </uix:header>

                 <uix:spacer height="1"/>
               </uix:contents>

  <%-- Table Buttons --%>
  <uix:pageButtons>
  <uix:pageButtonBar>
    <uix:switcher childNameBinding="xmlInitialized@objectBean@servletRequest">
      <uix:case name="false">
      <jsp:include page="/database/schema/pageButtonViewInclude.jsp" />
      <uix:ref refID="pageButtonViewInclude" />
      </uix:case>
      <uix:case name="true">
        <%-- OK Button --%>
       <%@ include file="/database/changemgr/cmEMOViewPageButtons.jspf" %>
      </uix:case>
    </uix:switcher>
  </uix:pageButtonBar>
  </uix:pageButtons>

</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>

</uix:body>
</uix:document>
</uix:renderingContext>
<%-- END: Content --%>
