<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        createSynonymPage.jsp
  -- Controller:  db/adm/schm/SynonymController.java
  --
  -- Description: Short Description of the page.
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>

<script language="javascript">
function getDBLinkInfo()
{
    dbLink = document.forms[0].DBLink.value;
    isLocal = document.forms[0].isLocalDB[0].checked;
    result = "&DBLink="+dbLink+"&isLocalDB="+isLocal;
    return result;
}
function popWindow(event)
{
    openWindow(window,
               document.forms[0].action+'&pageName=<%=SchemaPages.SYNONYM_CREATE_PG%>&event=selectDestSchemaAndObject'+event,
               'lovWindow',
               {width:700, height:600},
               true,
               'dialog',
               callBackLov);
}
function callBackLov()
{
}
</script>

<uix:renderingContext id="renderingContext">
<uix:bundle name="dbMsgs"
            class="oracle.sysman.db.rsc.DBObjectMsg"/>
<uix:bundle name="synMsgs"
            class="oracle.sysman.db.rsc.schm.SynonymMsg"/>
<oem:setURLEncoder id="renderingContext"/>
<uix:document>
<%@ include file="/oemTitle.jspf" %>
<%-- HTML Page Title --%>
<uix:metaContainer>
  <uix:head titleBinding="title@objectBean@servletRequest"/>
  <db:script src="/database/utils.js"/>   <%-- lovField support --%>
  <db:script src="/database/LOV.js"/>   <%-- lovField support --%>
</uix:metaContainer>
<uix:body>  

<%-- HTML Form --%>
<db:form name="foo"
         method="post"
         destinationBinding="destination@objectBean@servletRequest"
         copyParams="target,type,cancelURL,sname,oname,otype" >
<uix:formValue name="pageName" value="/database/schema/synonym/createSynonymPage"/>
<uix:pageLayout titleBinding="header@objectBean@servletRequest">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>

          <uix:contents>
            <uix:header textBinding="GENERAL@dbMsgs">
            <uix:tableLayout cellSpacing="5">
                <%-- name --%>
                <uix:rowLayout>
                  <uix:cellFormat wrappingDisabled="true">
                    <uix:messagePrompt labeledNodeId="NAME"
                                       promptBinding="NAME@dbMsgs" 
                                       requiredBinding="required@objectBean@servletRequest"/>
                  </uix:cellFormat>
                  <uix:stackLayout>
                    <uix:textInput id="NAME"
                                   name="synonymName" 
                                   textBinding="synonymName@objectBean@servletRequest" columns="50"
                                   disabledBinding="disable@objectBean@servletRequest"/>
                    <uix:messageText messageBinding="synonymName@errors@servletRequest" messageType="error"/>
                  </uix:stackLayout>
                </uix:rowLayout>
                <%-- @QS synonym type --%>

                 <uix:rowLayout>
                   <uix:cellFormat hAlign="left" wrappingDisabled="true">
                    <uix:messagePrompt promptBinding="TYPE@dbMsgs" 
                                       requiredBinding="required@objectBean@servletRequest"/>
                   </uix:cellFormat>
                   <uix:cellFormat wrappingDisabled="true">
                     <oem:radioButton name="isPublic"
                                      value="false"
                                      textBinding="SCHEMA@dbMsgs" 
                                      shortDescBinding="SCHEMA@dbMsgs"
                                      selectedValueBinding="isPublic@objectBean@servletRequest"
                                      disabledBinding="disable@objectBean@servletRequest"/>
                   <uix:stackLayout>
                     <uix:lovField name="schemaName"
                                          shortDescBinding="SCHEMA@dbMsgs"
                                          textBinding="schemaName@objectBean@servletRequest" 
                                          onClick="startLov('schemaName','ListSchema')"
                                          searchDescBinding="schemaName@objectBean@servletRequest"
                                          disabledBinding="disable@objectBean@servletRequest"/>
                     <uix:messageText messageBinding="schemaName@errors@servletRequest" messageType="error"/>
                   </uix:stackLayout>
                   </uix:cellFormat>
                 </uix:rowLayout>
                 <uix:rowLayout>
                   <uix:cellFormat>
                   </uix:cellFormat>
                   <oem:radioButton name="isPublic"
                                    value="true"
                                    textBinding="PUBLIC@synMsgs"
                                    shortDescBinding="PUBLIC@synMsgs"
                                    selectedValueBinding="isPublic@objectBean@servletRequest"
                                    disabledBinding="disable@objectBean@servletRequest"/>
                   <uix:cellFormat>
                   </uix:cellFormat>
                </uix:rowLayout>

            </uix:tableLayout>
            </uix:header>


            <uix:header textBinding="DATABASE@dbMsgs">
            <uix:tableLayout cellSpacing="5">
                <uix:rowLayout>
                  <oem:radioButton  name="isLocalDB"
                                    value="true"
                                    textBinding="LOCAL@synMsgs"
                                    shortDescBinding="LOCAL@synMsgs"
                                    selectedValueBinding="isLocalDB@objectBean@servletRequest"
                                    disabledBinding="disable@objectBean@servletRequest"/>
                </uix:rowLayout>

                <%-- dest DB Link  --%>
                <uix:rowLayout>
                    <uix:cellFormat hAlign="left" width="100" wrappingDisabled="true">
                      <oem:radioButton name="isLocalDB"
                                    value="false"
                                    textBinding="REMOTE@synMsgs"
                                    shortDescBinding="REMOTE@synMsgs"
                                    selectedValueBinding="isLocalDB@objectBean@servletRequest"
                                    disabledBinding="disable@objectBean@servletRequest"/>
                    </uix:cellFormat>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="right" width="100" wrappingDisabled="true">
                    <uix:messagePrompt labeledNodeId="DBLINK"  promptBinding="SERVICE_NAME@synMsgs"/>
                  </uix:cellFormat>
                  <uix:stackLayout>
                    <uix:lovField id="DBLINK"
                                name="DBLink"
                                shortDescBinding="SERVICE_NAME@synMsgs" 
                                searchDescBinding="SERVICE_NAME@synMsgs"
                                textBinding="DBLink@objectBean@servletRequest" 
                                onClick="startLov('DBLink','ListSchemaDBLink')"
                                columns="60"
                                disabledBinding="disable@objectBean@servletRequest"/>
                    <uix:messageText messageBinding="DBLink@errors@servletRequest" messageType="error"/>
                  </uix:stackLayout>
                </uix:rowLayout>

            </uix:tableLayout>
           </uix:header>

            <uix:header textBinding="AS_ALIAS_FOR@synMsgs">
            <uix:tableLayout cellSpacing="5">

                <%-- dest schema name --%>
                <uix:rowLayout>
                    <uix:cellFormat wrappingDisabled="true">
                      <uix:messagePrompt promptBinding="REFERENCING_OBJECT@synMsgs" 
                                         labeledNodeId="REFOBJECT"
                                         requiredBinding="required@objectBean@servletRequest"/>
                    </uix:cellFormat>
                    <uix:stackLayout>
                      <uix:lovField id="REFOBJECT"
                                    name="destSchemaAndObjectName"
                                    shortDescBinding="REFERENCING_OBJECT@synMsgs"
                                    searchDescBinding="REFERENCING_OBJECT@synMsgs"
                                    textBinding="destSchemaAndObjectName@objectBean@servletRequest" 
                                    onClick='<%= "popWindow(getDBLinkInfo())" %>' 
                                    columns="80" disabledBinding="disable@objectBean@servletRequest"/>
                      <uix:messageText messageBinding="Destination Object@errors@servletRequest" messageType="error"/>
                    </uix:stackLayout>
                </uix:rowLayout>


                <%-- dest object type --%>
                <uix:rowLayout renderedBinding="editing@objectBean@servletRequest">
                  <uix:contents>
                    <uix:cellFormat hAlign="right" width="80" wrappingDisabled="true">
                      <uix:contents>
                        <uix:messagePrompt promptBinding="OBJECT_TYPE@dbMsgs"/>
                      </uix:contents>
                    </uix:cellFormat>
                    <uix:styledText styleClass="OraDataText" textBinding="destObjectType@objectBean@servletRequest"/>
                  </uix:contents>
                </uix:rowLayout>

            </uix:tableLayout>
           </uix:header>

          <uix:spacer height="5"/>
           </uix:contents>

  <%-- Create/Edit Buttons --%>
  <uix:pageButtons>
  <uix:pageButtonBar>
    <jsp:include page="/database/schema/pageButtonInclude.jsp" />
    <uix:ref refID="pageButtonInclude" />
  </uix:pageButtonBar>
  </uix:pageButtons>

</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>

</uix:body>
</uix:document>
</uix:renderingContext>
<%-- END: Content --%>
