<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<% oracle.cabo.share.util.CaboHttpUtils.setNoCacheHeaders(response); %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
    <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
    <uix:bundle name="synMsgs" class="oracle.sysman.db.rsc.schm.SynonymMsg"/>
    <oem:setURLEncoder id="renderingContext"/>

  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="SEARCH_AND_SELECT_HEADER@dbMsgs"/>
       <script language="JavaScript" >
        <%@ include file="/database/utils.js"%>
        </script>
      <script language="JavaScript" >
        <%@ include file="/cabo/jsLibs/TableProxy.js" %>
      </script>

      <script>
        function lovSelect(lovField)
        {
          var proxy = new TableProxy('destSchemaAndObjectUIDataSource');
          var selectedIndex = proxy.getSelectedRow();
          if (selectedIndex >= 0)
          {
            var selectedElement=proxy.getFormElement('Object', selectedIndex);
            lovField.value=selectedElement.value;
            window.close();
          }
        }
      </script>

    </uix:metaContainer>
    <uix:body>

   <db:form name="foo" 
            destinationBinding="destination@objectBean@servletRequest"
            copyParams="target,type,cancelURL,sname,oname,otype">
   <uix:formValue name="pageName" value="/database/schema/synonym/selectDestSchemaAndObjectPage"/>
      <uix:pageLayout titleBinding="SEL_REF_SCHEMA_OBJECT_HEADER@synMsgs">

      <%-- Warning/Error display --%>
      <oem:messageBox messageType="info"
                      errorTableBinding="info@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>
      <oem:messageBox messageType="error"
                      errorTableBinding="errors@servletRequest"
                      titleTextKey="titleText" mainTextKey="mainText"/>

          <uix:tableLayout cellSpacing="2">

            <%-- Search Criteria and Instruction --%>
            <uix:rowLayout>
              <uix:header textBinding="SEARCH@dbMsgs">
                <uix:rowLayout>
                  <uix:styledText textBinding="SEARCH_SCHEMA_OBJECT_INST@synMsgs"/>
                </uix:rowLayout>

                <uix:rowLayout>
                  <uix:tableLayout cellSpacing="4">
                    <uix:rowLayout hAlign='left'>
                      <uix:cellFormat vAlign="top">
                        <uix:stackLayout>
                          <uix:styledText textBinding="OBJECT_TYPE_COLON@dbMsgs"/>
                          <oem:choice name="destLovObjectType" 
                                      optionsBinding="destLovObjectTypes@objectBean@servletRequest" 
                                      selectedValueBinding="destLovObjectType@objectBean@servletRequest"/>
                        </uix:stackLayout>
                      </uix:cellFormat>

                      <uix:cellFormat vAlign="top">
                        <uix:stackLayout>
                          <uix:styledText labeledNodeId="destLovSchemaName"
                                          textBinding="SCHEMA_NAME_COLON@dbMsgs"/>
                          <uix:textInput id="destLovSchemaName"
                                         name="destLovSchemaName" 
                                         textBinding="destLovSchemaName@objectBean@servletRequest"/>
                        </uix:stackLayout>
                      </uix:cellFormat>

                      <uix:cellFormat vAlign="top">
                        <uix:stackLayout>
                          <uix:styledText labeledNodeId="destSchemaAndObjectSearchCriteria"
                                          textBinding="OBJECT_NAME_COLON@dbMsgs"/>
                          <uix:rowLayout>
                            <uix:textInput id="destSchemaAndObjectSearchCriteria"
                                           name="destSchemaAndObjectSearchCriteria"
                                           textBinding="destSchemaAndObjectSearchCriteria@objectBean@servletRequest"/>
                            <uix:submitButton textBinding="GO@dbMsgs"
                                              name="event" value="changeDestSchemaAndObjectSearchCriteria"/>
                          </uix:rowLayout>
                        </uix:stackLayout>
                      </uix:cellFormat>
                    </uix:rowLayout>
                  </uix:tableLayout>
                </uix:rowLayout>
              </uix:header>
            </uix:rowLayout>
              <%-- End Search Criteria and Instruction --%>

            <uix:rowLayout> 
              <uix:switcher childNameBinding="showSelSchmAndObjResults@objectBean@servletRequest">
                <uix:case name="true">
                  <uix:header textBinding="RESULTS@dbMsgs">
                      <oem:table name="destSchemaAndObjectUIDataSource" 
                                 blockSize="15" beanKey="objectBean"
                                 destinationBinding="destination@objectBean@servletRequest" 
                                 formSubmitted="true"
                                 dataSourceProp="destSchemaAndObjectUIDataSource" width="80%"
                                 summaryBinding="RESULTS@dbMsgs"
        		         alternateTextBinding="NO_ITEMS_FOUND@dbMsgs">
                        <uix:tableSelection>
                          <uix:singleSelection shortDescBinding="SELECT_A_VALUE@dbMsgs"
                                               selectedIndex="0"/>
                        </uix:tableSelection>
                      </oem:table>
                  </uix:header>
                </uix:case>
              </uix:switcher>
            </uix:rowLayout>
          </uix:tableLayout>

        <uix:pageButtons>
          <uix:pageButtonBar>
            <uix:button textBinding="CANCEL@dbMsgs" destination="javascript:self.close()" />
            <uix:button textBinding="SELECT@dbMsgs"
                        destination="javascript:lovSelect(window.opener.document.foo.destSchemaAndObjectName)"/>
         </uix:pageButtonBar>
        </uix:pageButtons>
     </uix:pageLayout>
   </db:form>
   </uix:body>
  </uix:document>
</uix:renderingContext>

