<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        viewSynonymPage.jsp
  -- Controller:  db/adm/schm/SynonymController.java
  --
  -- Description: Short Description of the page.
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>
<uix:document>
<%@ include file="/oemTitle.jspf" %>
<%-- HTML Page Title --%>
<uix:metaContainer>
  <uix:head titleBinding="title@objectBean@servletRequest"/>
  <db:script src="/database/utils.js"/>   <%-- lovField support --%>
</uix:metaContainer>
<uix:body>  

<%-- HTML Form --%>
<db:form name="foo" 
         method="post"
         destinationBinding="destination@objectBean@servletRequest"
         copyParams="target,type,cancelURL,sname,oname,otype" >
<uix:formValue name="pageName" value="/database/schema/synonym/viewSynonymPage"/>
<uix:pageLayout titleBinding="header@objectBean@servletRequest">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>

          <uix:contents>

            <uix:header textBinding="GENERAL@uixDBObjectBundle@servletRequest"/>
            <uix:tableLayout cellSpacing="5">

                <%-- name --%>
                <uix:rowLayout>
                  <uix:contents>
                    <uix:cellFormat hAlign="right" width="80">
                      <uix:contents>
                        <uix:messagePrompt promptBinding="NAME@uixDBObjectBundle@servletRequest"/>
                      </uix:contents>
                    </uix:cellFormat>
                    <uix:styledText styleClass="OraDataText" textBinding="synonymName@objectBean@servletRequest"/>
                  </uix:contents>
                </uix:rowLayout>

                <%-- schema name --%>
                <uix:rowLayout>
                  <uix:contents>
                    <uix:cellFormat hAlign="right" width="80">
                      <uix:contents>
                        <uix:messagePrompt promptBinding="SCHEMA@uixDBObjectBundle@servletRequest"/>
                      </uix:contents>
                    </uix:cellFormat>
                    <uix:styledText styleClass="OraDataText" textBinding="schemaName@objectBean@servletRequest"/>
                  </uix:contents>
                </uix:rowLayout>
            </uix:tableLayout>


         <uix:header textBinding="DATABASE@uixDBObjectBundle@servletRequest"/> 
           <uix:tableLayout cellSpacing="5">
               <uix:switcher childNameBinding="hasDBLink@objectBean@servletRequest">
              <uix:case name="true">
             <uix:rowLayout>
               <uix:cellFormat hAlign="right" width="80">
                 <uix:messagePrompt promptBinding="LINK@uixSynonymMsgBundle@servletRequest"/>
               </uix:cellFormat>
               <uix:styledText styleClass="OraDataText" textBinding="DBLink@objectBean@servletRequest"/>
              </uix:rowLayout>
              </uix:case>
              <uix:case name="false">
              <uix:rowLayout>
               <uix:cellFormat hAlign="right" width="80">
                 <uix:messagePrompt promptBinding="LOCAL@uixSynonymMsgBundle@servletRequest"/>
               </uix:cellFormat>
              </uix:rowLayout>
              </uix:case>
             </uix:switcher>
            </uix:tableLayout>


          <uix:header textBinding="AS_ALIAS_FOR@uixSynonymMsgBundle@servletRequest">
            <uix:tableLayout cellSpacing="5">
              <uix:contents>

                <%-- dest schema.object name --%>
                <uix:rowLayout>
                  <uix:contents>
                    <uix:cellFormat hAlign="right" width="80">
                      <uix:contents>
                        <uix:messagePrompt promptBinding="OBJECT@uixDBObjectBundle@servletRequest"/>
                      </uix:contents>
                    </uix:cellFormat>
                    <uix:styledText styleClass="OraDataText" textBinding="destSchemaAndObjectName@objectBean@servletRequest"/>
                  </uix:contents>
                </uix:rowLayout>

                <%-- dest object type --%>
              <uix:switcher childNameBinding="xmlInitialized@objectBean@servletRequest">
               <uix:case name="false">
                <uix:rowLayout>
                  <uix:contents>
                    <uix:cellFormat hAlign="right" width="80">
                      <uix:contents>
                        <uix:messagePrompt promptBinding="OBJECT_TYPE@uixDBObjectBundle@servletRequest"/>
                      </uix:contents>
                    </uix:cellFormat>
                    <uix:styledText styleClass="OraDataText" textBinding="destObjectType@objectBean@servletRequest"/>
                  </uix:contents>
                </uix:rowLayout>
               </uix:case>
              </uix:switcher>

              </uix:contents>
            </uix:tableLayout>
            </uix:header>
            <uix:spacer height="1"/>
          </uix:contents>

  <%-- Table Buttons --%>
    <uix:pageButtons>
      <uix:pageButtonBar>
        <uix:switcher childNameBinding="xmlInitialized@objectBean@servletRequest">
          <uix:case name="false">
            <jsp:include page="/database/schema/pageButtonViewInclude.jsp" />
            <uix:ref refID="pageButtonViewInclude" />
          </uix:case>
          <uix:case name="true">
          <%-- OK Button --%>
          <%@ include file="/database/changemgr/cmEMOViewPageButtons.jspf" %>
          </uix:case>
        </uix:switcher>
      </uix:pageButtonBar>
    </uix:pageButtons>


</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>

</uix:body>
</uix:document>
</uix:renderingContext>
<%-- END: Content --%>
