<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        attrDefaultPage.jsp
  -- Controller:  db/adm/schm/TableGeneralController.java
  --
  -- Description: Page for defining a columns attributes.
  --              There will be a new page for each column type we support,
  --              but this will be the default page for standard types.
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>


<%-- 
|| ((Boolean)document.forms[0].<%= TableConst.J_COL_TBL_CURR_NOT_NULL_EXISTING %>.value).booleanValue();
--%>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>
<%@ page import="oracle.sysman.emo.adm.schema.table.TableConst" %>

<uix:renderingContext id="renderingContext">
    <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
    <uix:bundle name="tblMsgs" class="oracle.sysman.db.rsc.schm.TableMsg"/>
    <uix:bundle name="msgs" class="oracle.sysman.db.rsc.schm.PartitionsMsg"/>
    <uix:bundle name="spatialMsgs" class="oracle.sysman.db.rsc.sptl.SpatialMsg"/>
    <oem:setURLEncoder id="renderingContext"/>
    <uix:document>

 
<NOSCRIPT>
A browser with Javascript enabled is required for this page to operate properly.
</NOSCRIPT>
<db:script  src="/database/utils.js"/>
<script language="javascript">
function setKeySeed1() 
{
  if (document.forms[0].keySelect[0].checked  == true)
  {
    document.forms[0].<%= TableConst.J_COL_TBL_CURR_SEED %>.disabled = true;
    document.forms[0].<%= TableConst.J_COL_TBL_CURR_CONFIRM_SEED %>.disabled = true;
            
  }

  if (document.forms[0].keySelect[1].checked  == true)
  {
    document.forms[0].<%= TableConst.J_COL_TBL_CURR_SEED %>.disabled = false;
    document.forms[0].<%= TableConst.J_COL_TBL_CURR_CONFIRM_SEED %>.disabled = false;
            
  }

}
</script>

        <%-- HTML Page Title --%>
	
        <uix:metaContainer>
     <uix:head titleBinding="_emSDK_PageTitle@servletRequest"/>         </uix:metaContainer>

        <uix:body > <%-- onLoad="setKeySeed()"> --%>
        
            <%-- HTML Form --%>
           <db:form name="tblForm"
                method="post"
                destinationBinding="destination@objectBean@servletRequest"
                copyParams="target,type,cancelURL,sname,oname,otype">  

		   <uix:dataScope currentDataBinding="tableColumnsBean@servletRequest">


                    <uix:formValue name="pageName" value="<%= SchemaPages.TBL_COL_ENCRYPTION_OPT_PG %>"/>
                 <%--<uix:formValue name="<%= TableConst.J_COL_TBL_CURR_NOT_NULL_EXISTING %>" 
                    valueBinding="<%= TableConst.J_COL_TBL_CURR_NOT_NULL_EXISTING %>" /> --%>

                    <uix:pageLayout titleBinding="pageHeader@servletRequest">

                        <%-- Oracle Logo and Tabs --%>
                        <%@ include file="/database/global.jspf" %>

                        <%-- Warning/Error display --%>
                        <oem:messageBox messageType="info" 
                        errorTableBinding="info@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
                        
					
	 <%-- START: PAGE CONTENT starts here --%> 
  
				<uix:contents>
                                <uix:subTabLayout>
                                  <uix:contents>
                                    <uix:tableLayout width="100%" hAlign="center" borderWidth="0">
                                      <uix:contents>
                                      <uix:rowLayout>
                                        <uix:formattedText textBinding="ENCRY_ALGO_MSG@tblMsgs" styleClass="OraInstructionText"/> 
                                         </uix:rowLayout>
                                           <uix:rowLayout>
                                          <uix:contents>
                                            <uix:cellFormat>
                                              <uix:contents>
                                                <uix:spacer width="10" height="10"/>
                                              </uix:contents>
                                            </uix:cellFormat>
                                          </uix:contents>
                                        </uix:rowLayout>
                 <uix:tableLayout cellSpacing="7">
		   <uix:dataScope currentDataBinding="tableColumnBean@servletRequest">
                                        <uix:rowLayout>
                                          <uix:contents>
                                            <uix:cellFormat  hAlign="left" >
                                              <uix:contents>
 						<uix:messageChoice name="<%= TableConst.J_TBL_ENCRYPTION_ALGO%>" promptBinding="ENCRYPTION_ALGO@tblMsgs" 
                                                            shortDescBinding="ENCRYPTION_ALGO@tblMsgs"
                                                            selectedValueBinding="<%= TableConst.J_COL_TBL_CURR_ENCRYPT_ALGO %>" >
                                                  <uix:contents>
                                                    <uix:option textBinding="AES192@tblMsgs" value="<%=TableConst.AES192%>" />
                                                    <uix:option textBinding="DES168@tblMsgs" value="<%=TableConst.DES168%>" />
                                                    <uix:option textBinding="AES128@tblMsgs" value="<%=TableConst.AES128%>" />
                                                    <uix:option textBinding="AES256@tblMsgs" value="<%=TableConst.AES256%>" />
                                                  </uix:contents>
                                                </uix:messageChoice>
                                              </uix:contents>
                                            </uix:cellFormat>
                                          </uix:contents>
                                        </uix:rowLayout>

		   </uix:dataScope >
                  </uix:tableLayout>
                                        <uix:rowLayout>
                                          <uix:contents>
                                            <uix:cellFormat>
                                              <uix:contents>
                                                <uix:spacer width="10" height="10"/>
                                              </uix:contents>
                                            </uix:cellFormat>
                                          </uix:contents>
                                        </uix:rowLayout>
                                        <uix:rowLayout width="100%" hAlign="left">
                                          <uix:contents>
                                            <uix:cellFormat width="90%">
                                              <uix:contents>
                                                <uix:header textBinding="KEY_SEED_GEN@tblMsgs">
                                              <uix:contents>
                                                <uix:formattedText textBinding="SEED_VALUE_MSGS@tblMsgs" styleClass="OraInstructionText"/>
                                        <uix:rowLayout>
                                          <uix:contents>
                                            <uix:cellFormat>
                                              <uix:contents>
                                                <uix:spacer width="10" height="10"/>
                                              </uix:contents>
                                            </uix:cellFormat>
                                          </uix:contents>
                                        </uix:rowLayout>
                                  
                                       <uix:rowLayout hAlign="left">
                                          <uix:contents>
                                            <uix:cellFormat hAlign="left">
                                              <uix:contents>
                                              
                                                   
                                  <uix:messageRadioSet name="<%=TableConst.J_TBL_KEY_SELECT%>" 
                                  tipBinding="KEY_SEED_TIP@tblMsgs"  shortDescBinding="KEY_SEED_GEN@tblMsgs"
                                  selectedIndex = "0"  onClick="setKeySeed1()" >
                                  <uix:contents>
                                  <uix:option textBinding="RANDOM_SEED_MSG@tblMsgs"                                                  
                                                   value="<%= TableConst.RANDOM %>" />
                                   <uix:option textBinding="SPECIFY_SEED_MSG@tblMsgs"                                                   
                                                   value="<%=TableConst.KEYSEED %>" />
                                    </uix:contents>
                                    </uix:messageRadioSet>
                                                   
                                                   
                                              </uix:contents>
                                            </uix:cellFormat>
                                          </uix:contents>
                                        </uix:rowLayout>
                                              </uix:contents>
                                                </uix:header>
                                              </uix:contents>
                                            </uix:cellFormat>
                                          </uix:contents>
                                        </uix:rowLayout>
                                        
                                        <uix:rowLayout hAlign="left">
                                          <uix:contents>
                                            <uix:cellFormat  hAlign="left">
                                              <uix:contents>
                                                <uix:spacer width="10" height="30"/>
                                              </uix:contents>
                                            </uix:cellFormat>
                                          </uix:contents>
                                        </uix:rowLayout>
                                        <uix:rowLayout hAlign="left">
                                          <uix:contents>
                                            <uix:cellFormat hAlign="left">
                                              <uix:contents>
                                                <uix:labeledFieldLayout>
                                                  <uix:contents>
						 <uix:messageTextInput name="<%=TableConst.J_COL_TBL_CURR_SEED%>"
                                                        id="SEED_ID"
                                                        shortDescBinding="SEED@tblMsgs"
                                                        columns="20"
							secret="true"
                                                        promptBinding = "ENTER_SEED@tblMsgs"
                                                        text="" 
                                                        disabledBinding="DISABLED_TRUE@tblMsgs"/>

                                                    <uix:rowLayout>
                                                      <uix:contents>
                                                        <uix:cellFormat>
                                                          <uix:contents>
                                                            <uix:spacer width="10" height="10"/>
                                                          </uix:contents>
                                                        </uix:cellFormat>
                                                      </uix:contents>
                                                    </uix:rowLayout>

						       <uix:messageTextInput name="<%= TableConst.J_COL_TBL_CURR_CONFIRM_SEED %>"
                                                        id="CONFIRM_SEED_ID"
                                                        shortDescBinding="CONFIRM_SEED@tblMsgs"  
                                                        columns="20"
							secret="true"
                                                        promptBinding = "ENTER_CONFIRM_SEED@tblMsgs"
                                                        text="" 
                                                        disabledBinding="DISABLED_TRUE@tblMsgs"/>

                                                  </uix:contents>
                                                </uix:labeledFieldLayout>
                                              </uix:contents>
                                            </uix:cellFormat>
                                          </uix:contents>
                                        </uix:rowLayout>
                                        
                                      </uix:contents>
                                    </uix:tableLayout>
                                  </uix:contents>
                                </uix:subTabLayout>
                              </uix:contents>  
  
                        <%-- END: TYPE SPECIFIC ATTRIBUTES PAGE CONTENT ends here --%>  
   
                      <uix:pageStatus>                        
                      </uix:pageStatus>               
               
                        <uix:pageButtons>
                <uix:pageButtonBar>
                <%-- CANCEL BUTTON --%>
          
                    <uix:submitButton textBinding="CANCEL@dbMsgs" shortDescBinding="CANCEL@dbMsgs" name="event" value="<%= TableConst.J_ENCRY_CANCEL %>"/>
                    <%--OK/CANCEL Button --%>
                    <%-- OK BUTTON --%>
                    <uix:submitButton textBinding="CONTINUE@dbMsgs" shortDescBinding="CONTINUE@dbMsgs" name="event" value="<%= TableConst.J_ENCRY_OK %>"/>              </uix:pageButtonBar>
            </uix:pageButtons>
           <uix:pageStatus>
            
       
      </uix:pageStatus>
      
          </uix:pageLayout>
        </uix:dataScope> 
      </db:form>
      <%-- END: HTML Form --%>
    </uix:body>
  </uix:document>
</uix:renderingContext>
<%-- END: Content --%>
