<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%--
  -- Page:        abstTypePage.jsp
  -- Controller:  db/adm/schm/TableGeneralController.java
  --
  -- Description: Page for defining an abstract data type.
  --              Allows the user to search for and select
  --              the datatype they want.
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>
<%@ page import="oracle.sysman.emo.adm.schema.table.TableConst" %>
 
<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>

<uix:document>

<%-- HTML Page Title --%>
<%-- Fix Bug 4080599, for future release
<%@ include file="/oemTitle.jspf" %>
--%>
<uix:metaContainer>
  <uix:head titleBinding="ABSTRACT_TYPE@uixTableBundle@servletRequest"/>
  <db:script src="/database/LOV.js"/>
</uix:metaContainer>

<uix:body>
<%-- HTML Form --%>
<db:form name="tblForm"
         method="post"
         destinationBinding="destination@objectBean@servletRequest"
         copyParams="target,type,cancelURL,sname,oname,otype">
<uix:formValue name="pageName" value="<%= SchemaPages.TBL_ABST_TYPE_PG %>"/>
<uix:pageLayout titleBinding="ABSTRACT_TYPE@uixTableBundle@servletRequest">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errorsAbstPage@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/> 
  <uix:spacer height="5" />
  <%-- START: ABSTRACT DATA TYPE PAGE CONTENTS starts here --%>
  <uix:pageStatus>
    <uix:styledText styleClass="OraInstructionText" textBinding="abstractPageInsertText@tableColumnBean@servletRequest" />
  </uix:pageStatus>
  <uix:stackLayout>
   <%-- Name --%> 
   <uix:rowLayout>
      <uix:cellFormat hAlign="right">
        <uix:messagePrompt promptBinding="COLUMN_NAME@uixDBObjectBundle@servletRequest" required="yes" labeledNodeId="COLUMN_NAME"/>
      </uix:cellFormat>
        <uix:spacer width="5"/>
        <uix:cellFormat>
        <uix:stackLayout>
          <uix:textInput name="attrName" id="COLUMN_NAME" shortDescBinding="COLUMN_NAME@uixDBObjectBundle@servletRequest" 
                         textBinding="attrName@tableColumnBean@servletRequest"
                         columns="50"/>
          <uix:messageText messageType="error" messageBinding="attrName@errors@servletRequest" />
        </uix:stackLayout>
        </uix:cellFormat>
    </uix:rowLayout>  
  <%-- Search --%>
  <uix:header textBinding="SEARCH@uixDBObjectBundle@servletRequest">
    <uix:stackLayout>
    <uix:styledText styleClass="OraInstructionText" textBinding="SEARCH_TEXT_ABSTRACT_DT@uixTableBundle@servletRequest"/>
    <uix:spacer height="15"/>
    </uix:stackLayout>    
    <uix:labeledFieldLayout fieldWidth="0%" labelWidth="0%" width="0%">
      <uix:contents>
        <uix:messagePrompt promptBinding="SCHEMA@uixDBObjectBundle@servletRequest" labeledNodeId="SCHEMA"/>
        <uix:lovField name="searchSchemaName"
                      shortDescBinding="SCHEMA@uixDBObjectBundle@servletRequest"
                      searchDescBinding="SCHEMA@uixDBObjectBundle@servletRequest"
                      textBinding="searchSchemaName@objectBean@servletRequest"
                      id="SCHEMA"
                      onClick="startLov('searchSchemaName', 'ListSchema')"/>
      
        <uix:messagePrompt promptBinding="DATA_TYPE@uixDBObjectBundle@servletRequest" labeledNodeId="DATA_TYPE" />
        <uix:textInput name="searchObjectName" textBinding="searchObjectName@objectBean@servletRequest" columns="50" id="DATA_TYPE" shortDescBinding="DATA_TYPE@uixDBObjectBundle@servletRequest"/>
        <uix:messagePrompt prompt=""/>
        <uix:messagePrompt prompt=""/>
        <uix:messagePrompt prompt=""/>
        <uix:submitButton textBinding="SEARCH@uixDBObjectBundle@servletRequest"
                          shortDescBinding="SEARCH@uixDBObjectBundle@servletRequest"
                          name="event" 
                          value="<%= TableConst.J_ABST_SEARCH %>"/>
      
        <uix:cellFormat>
        </uix:cellFormat>
      </uix:contents>
    </uix:labeledFieldLayout>
  </uix:header>

  <%-- Search Results --%>
  <uix:header textBinding="RESULTS@uixTableBundle@servletRequest">
    <oem:table name="schemaObjectUIDataSourceAbstractDT" blockSize="10"
                destinationBinding="destination" formSubmitted="true"
                dataSourceProp="schemaObjectUIDataSourceAbstractDT" width="100%"
               alternateTextBinding="NO_ITEMS_FOUND@uixDBObjectBundle@servletRequest" 
               summaryBinding="RESULTS@uixTableBundle@servletRequest"
               copyParams="target,type,cancelURL,sname,oname,otype" >
      <uix:tableSelection>
       <oem:singleSelection selectedIndexBinding="selectedIndexADP@objectBean@servletRequest" shortDescBinding="SELECT@uixDBObjectBundle@servletRequest"/>
      </uix:tableSelection>
    </oem:table>
  </uix:header>

  </uix:stackLayout>
  <%-- END: ABSTRACT DATA TYPE PAGE CONTENTS ends here --%>   
        
  <%-- OK/CANCEL Button --%>
  <uix:pageButtons>
  <uix:pageButtonBar>

    <%-- CANCEL BUTTON --%>
    <uix:submitButton textBinding="CANCEL@uixDBObjectBundle@servletRequest" 
                      shortDescBinding="CANCEL@uixDBObjectBundle@servletRequest"
                      name="event" 
                      value="<%= TableConst.J_ABST_CANCEL %>" />

    <%-- OK BUTTON --%>
    <uix:submitButton textBinding="OK@uixDBObjectBundle@servletRequest" 
                      shortDescBinding="OK@uixDBObjectBundle@servletRequest"
                      name="event" 
                      value="<%= TableConst.J_ABST_OK %>" />

  </uix:pageButtonBar>
  </uix:pageButtons>

</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>
</uix:body>
</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 

