<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:        attrDefaultPage.jsp
  -- Controller:  db/adm/schm/TableGeneralController.java
  --
  -- Description: Page for defining a columns attributes.
  --              There will be a new page for each column type we support,
  --              but this will be the default page for standard types.
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<db:script  src="/database/utils.js"/>
<script language="javascript">
function setNotNull() 
{
  if (document.forms[0].<%= TableConst.J_COL_TBL_CURR_NOT_NULL %> != null)
  {
    document.forms[0].<%= TableConst.J_COL_TBL_CURR_NOT_NULL_NAME %>.disabled = 
            !document.forms[0].<%= TableConst.J_COL_TBL_CURR_NOT_NULL %>.checked
            || document.forms[0].<%= TableConst.J_COL_TBL_CURR_NOT_NULL %>.disabled;
            
  }
  if (document.forms[0].retention != null)
        initLOBStorageOptions();

  if (document.forms[0].bfretention != null)
        initBFLOBStorageOptions();
}
</script>


<%-- 
|| ((Boolean)document.forms[0].<%= TableConst.J_COL_TBL_CURR_NOT_NULL_EXISTING %>.value).booleanValue();
--%>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>
<%@ page import="oracle.sysman.emo.adm.schema.table.TableConst" %>

<uix:renderingContext id="renderingContext">
    <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
    <uix:bundle name="tblMsgs" class="oracle.sysman.db.rsc.schm.TableMsg"/>
    <uix:bundle name="tdeMsgs" class="oracle.sysman.db.rsc.sec.tde.TDEMsg"/>
    <uix:bundle name="msgs" class="oracle.sysman.db.rsc.schm.PartitionsMsg"/>
    <uix:bundle name="spatialMsgs" class="oracle.sysman.db.rsc.sptl.SpatialMsg"/>
    <oem:setURLEncoder id="renderingContext"/>
    <uix:document>

        <%-- HTML Page Title --%>
        <uix:metaContainer>
  <uix:head titleBinding="_emSDK_PageTitle@servletRequest"/>
        </uix:metaContainer>

        <uix:body onLoad="setNotNull()">

            <%-- HTML Form --%>
            <db:form name="tblForm"
                method="post"
                destinationBinding="destination@objectBean@servletRequest"
                copyParams="target,type,cancelURL,sname,oname,otype">

                <uix:dataScope currentDataBinding="tableColumnBean@servletRequest">

                    <uix:formValue name="pageName" value="<%= SchemaPages.TBL_COL_ATTR_PG %>"/>
                    <uix:formValue name="<%= TableConst.J_COL_TBL_CURR_NOT_NULL_EXISTING %>" 
                    valueBinding="<%= TableConst.J_COL_TBL_CURR_NOT_NULL_EXISTING %>" />

                    <uix:pageLayout titleBinding="attrDefaultPageHeader">

                        <%-- Oracle Logo and Tabs --%>
                        <%@ include file="/database/global.jspf" %>

                        <%-- Warning/Error display --%>
                        <oem:messageBox messageType="info" 
                        errorTableBinding="info@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
                        <oem:messageBox messageType="error" 
                        errorTableBinding="errorsAttrDefPage@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
					
						  <%-- START: COLUMN ATTRIBUTES PAGE CONTENT starts here --%> 
  
                        <uix:switcher childNameBinding="<%= TableConst.J_COL_TBL_SELECTED_COL_TYPE %>" defaultCase="defCase">

                            <uix:case name="<%= TableConst.COL_XML_TYPE %>">
                                <uix:dataScope currentDataBinding="XMLTypeTable_Bean@servletRequest">
                                    <jsp:include page="/database/schema/table/generalXmlTypeInclude.jsp" />
                                    <uix:ref refID="generalXmlTypeInclude" />
                                </uix:dataScope>       
                            </uix:case>
                            <uix:case name="defCase">
                                <uix:switcher childNameBinding="spatialtype@tableColumnBean@servletRequest">
                                    <uix:case name="false">
  
                                        <uix:stackLayout>
                                            <uix:labeledFieldLayout columns="1">

                                                <%-- Name --%>
                                                <uix:messageTextInput name="<%= TableConst.J_COL_TBL_CURR_NAME %>"
                                                promptBinding="NAME@dbMsgs"
                                                shortDescBinding="NAME@dbMsgs"
                                                textBinding="<%= TableConst.J_COL_TBL_CURR_NAME %>" />

                                                <%-- Primary Key Column --%>
                                                <uix:messageStyledText promptBinding="PRIMARY_KEY_COL@tblMsgs"
                                                shortDescBinding="PRIMARY_KEY_COL@tblMsgs"
                                                textBinding="YES@dbMsgs" 
                                                contentStyleClass="OraDataText"
                                                renderedBinding="<%= TableConst.J_COL_TBL_CURR_PK %>"/>

                                                <%-- Datatype --%>
                                                <uix:switcher childNameBinding="timestampType">
                                                  <uix:case name="true">
                                                    <uix:messageChoice name = "<%= TableConst.J_COL_TBL_CURR_DATA_TYPE %>"
                                                                       promptBinding="DATA_TYPE@dbMsgs"
                                                                       shortDescBinding="DATA_TYPE@dbMsgs"
                                                                       selectedValueBinding="<%= TableConst.J_COL_TBL_CURR_DATA_TYPE %>" >
                                                      <uix:option text="<%= TableConst.S_TS %>"
                                                                  value="<%= TableConst.S_TS %>" />
                                                      <uix:option text="<%= TableConst.S_TS_TZ %>"
                                                                  value="<%= TableConst.S_TS_TZ %>" />
                                                      <uix:option text="<%= TableConst.S_TS_LOCAL_TZ %>"
                                                                   value="<%= TableConst.S_TS_LOCAL_TZ %>" />
                                                    </uix:messageChoice>             
                                                  </uix:case>
                                                  <uix:case name="false">                                  
                                                    <uix:messageStyledText promptBinding="DATA_TYPE@dbMsgs"
                                                                           shortDescBinding="DATA_TYPE@dbMsgs"
                                                                           textBinding="<%= TableConst.J_COL_TBL_CURR_DATA_TYPE %>" 
                                                                           contentStyleClass="OraDataText" />
                                                  </uix:case>                                             
                                                </uix:switcher>

                                                <%-- Size --%>
                                                <uix:messagePrompt promptBinding="SIZE@tblMsgs" labeledNodeId="SIZE_ID" />
                                                <uix:tableLayout>
                                                    <uix:rowLayout>
                                                        <uix:messageTextInput name="<%= TableConst.J_COL_TBL_CURR_SIZE %>"
                                                        id="SIZE_ID"
                                                        shortDescBinding="SIZE@tblMsgs"
                                                        columns="10"
                                                        textBinding="<%= TableConst.J_COL_TBL_CURR_SIZE %>" 
                                                        disabledBinding="<%= TableConst.J_COL_TBL_CURR_SIZE_DISABLED %>"/>
                                                        <uix:messageChoice name="<%= TableConst.J_COL_TBL_CURR_SIZE_TYPE %>" 
                                                            shortDescBinding="SIZE_SEMANTICS@tblMsgs"
                                                            selectedValueBinding="<%= TableConst.J_COL_TBL_CURR_SIZE_TYPE %>"
                                                            renderedBinding="<%= TableConst.J_COL_TBL_CURR_SIZE_TYPE_AVAIL %>">
                                                            <uix:option textBinding="DEFAULT_OPT@dbMsgs" 
                                                            value="<%= TableConst.DEFAULT_SEMANTICS %>" />
                                                            <uix:option text="BYTE" 
                                                            value="<%= TableConst.BYTE_SEMANTICS %>"/>
                                                            <uix:option text="CHAR" 
                                                            value="<%= TableConst.CHAR_SEMANTICS %>"/>
                                                        </uix:messageChoice>
                                                    </uix:rowLayout>
                                                </uix:tableLayout>

                                                <%-- Scale --%>
                                                <uix:messageTextInput name="<%= TableConst.J_COL_TBL_CURR_SCALE %>"
                                                promptBinding="SCALE@tblMsgs"
                                                shortDescBinding="SCALE@tblMsgs"
                                                columns="10"
                                                textBinding="<%= TableConst.J_COL_TBL_CURR_SCALE %>"
                                                disabledBinding="<%= TableConst.J_COL_TBL_CURR_SCALE_DISABLED %>" />

                                                <%-- Default Value --%>
                                                <uix:messageTextInput name="<%= TableConst.J_COL_TBL_CURR_DEFAULT %>"
                                                promptBinding="DEFAULT_VALUE@tblMsgs"
                                                shortDescBinding="DEFAULT_VALUE@tblMsgs"
                                                textBinding="<%= TableConst.J_COL_TBL_CURR_DEFAULT %>" />
                                            </uix:labeledFieldLayout>

                                            <%-- Not NULL constraint --%>
                                            <uix:header textBinding="NOT_NULL_CON@tblMsgs">

                                                <%-- Not Null --%>
                                                <uix:messageCheckBox name="<%= TableConst.J_COL_TBL_CURR_NOT_NULL %>"
                                                textBinding="NOT_NULL@tblMsgs"
                                                shortDescBinding="NOT_NULL@tblMsgs"
                                                checkedBinding="<%= TableConst.J_COL_TBL_CURR_NOT_NULL %>" 
                                                disabledBinding="<%= TableConst.J_COL_TBL_CURR_NOT_NULL_DISABLED %>"
                                                onClick="setNotNull()"/>

                                                <%-- Not Null Name --%>
                                                <uix:messageTextInput name="<%= TableConst.J_COL_TBL_CURR_NOT_NULL_NAME %>"
                                                promptBinding="CONSTRAINT_NAME@tblMsgs"
                                                shortDescBinding="CONSTRAINT_NAME@tblMsgs"
                                                textBinding="<%= TableConst.J_COL_TBL_CURR_NOT_NULL_NAME %>" />

                                           </uix:header>


                                          </uix:stackLayout>
  
                                    </uix:case>
                                </uix:switcher>

                            </uix:case>
                        </uix:switcher>
  
                        <%-- END: COLUMN ATTRIBUTES PAGE CONTENT ends here --%>  



                        <%-- START: TYPE SPECIFIC ATTRIBUTES PAGE CONTENT starts here --%>  

                        <%-- LOB attribute include --%>
                        <uix:switcher childNameBinding="lobtype">
                            <uix:case name="true"> 
                                <uix:dataScope currentDataBinding="lobSegment@servletRequest">

                                    <jsp:include page="/database/schema/utilities/lobStorageInclude.jsp" />
                                    <uix:ref refID="lobStorageInclude" />
                                </uix:dataScope>
                            </uix:case>
                        </uix:switcher>

                        <%-- Nested Table attribute include --%>
                        <uix:switcher childNameBinding="cColIsNestedTable">
                            <uix:case name="true"> 
                              <uix:dataScope currentDataBinding="tableColumnBean@servletRequest">
                                <jsp:include page="/database/schema/table/nestedStorageInclude.jsp" />
                                <uix:ref refID="nestedStorageInclude" /> 
                              </uix:dataScope>
                            </uix:case>
                        </uix:switcher>                  
  
                        <uix:switcher childNameBinding="spatialtype">
                            <uix:case name="true"> 
                                <uix:dataScope currentDataBinding="spatial@servletRequest">    
                                    <jsp:include page="/database/schema/utilities/spatialStorageInclude.jsp" />
                                    <uix:ref refID="spatialStorageInclude" /> 
                                </uix:dataScope>      
                            </uix:case>
                        </uix:switcher>                  
  
  
                        <%-- END: TYPE SPECIFIC ATTRIBUTES PAGE CONTENT ends here --%>  
                         <%--<uix:dataScope currentDataBinding="tableColumnBean@servletRequest">--%>
			<uix:rowLayout  renderedBinding="saltEnabled@objectBean@servletRequest" >
					<uix:contents>
                                        <uix:cellFormat styleClass="OraInstructionText" hAlign="left" vAlign="top" width="50%" >
                                          <uix:contents>
                                            <uix:header textBinding="SALT_HEADER@tdeMsgs">
                                              <uix:contents>
                                                <uix:styledText >
                                                  <uix:contents>
                                                    <uix:styledText textBinding="SALT_MESSAGE@tdeMsgs" styleClass="OraInstructionText"/>
                                                  </uix:contents>
                                                </uix:styledText>
                                                <uix:rowLayout>
                                                  <uix:contents>
                                                    <uix:cellFormat  >
                                                      <uix:contents>
                                                                                                                
                                                        <uix:checkBox textBinding="SALT_CHECKBOX_MSG@tdeMsgs" name="salt" checkedBinding="<%= TableConst.J_COL_TBL_CURR_SALT%>"/> 
                                                      </uix:contents>
                                                    </uix:cellFormat>
                                                  </uix:contents>
                                                </uix:rowLayout>
                                              </uix:contents>
                                            </uix:header>
                                          </uix:contents>
                                        </uix:cellFormat>
                                      </uix:contents>
                        </uix:rowLayout>
		<%--             </uix:dataScope>       --%>
                        <uix:pageButtons>
              <uix:pageButtonBar>
                <%-- CANCEL BUTTON --%>
                <uix:switcher childNameBinding="viewspatialcoltype@tableColumnBean@servletRequest">
                  <uix:case name="false">
                    <uix:submitButton textBinding="CANCEL@dbMsgs" shortDescBinding="CANCEL@dbMsgs" name="event" value="<%= TableConst.J_ATTR_CANCEL %>" unvalidated="true"/>
                  </uix:case>
                </uix:switcher>
                <uix:switcher childNameBinding="viewspatialcoltype@tableColumnBean@servletRequest">
                  <uix:case name="true">
                    <uix:submitButton textBinding="OK@dbMsgs" shortDescBinding="OK@dbMsgs" name="event" value="breadcrumbEvent"/>
                  </uix:case>
                </uix:switcher>
                <uix:switcher childNameBinding="viewspatialcoltype@tableColumnBean@servletRequest">
                  <uix:case name="false">
                    <%--OK/CANCEL Button --%>
                    <%-- OK BUTTON --%>
                    <uix:submitButton textBinding="CONTINUE@dbMsgs" shortDescBinding="CONTINUE@dbMsgs" name="event" value="<%= TableConst.J_ATTR_OK %>"/>
                  </uix:case>
                </uix:switcher>
              </uix:pageButtonBar>
            </uix:pageButtons>
           <uix:pageStatus>
             <uix:switcher childNameBinding="viewSpatialColORindexExists@spatial@servletRequest" defaultCase="true">
        <uix:case name="false">
          <uix:messageStyledText styleClass="OraInstructionText" textBinding="SPATIAL_INSTRUCTION@spatialMsgs"/>
          <%--uix:tip
		    <uix:styledText textBinding="SPATIAL_INSTRUCTION@spatialMsgs" styleClass="OraTipText" />
		  </uix:tip --%>
        </uix:case>
        <uix:case name="true">
          <uix:spacer width="10"/>
        </uix:case>
      </uix:switcher>
      </uix:pageStatus>
      
          </uix:pageLayout>
        </uix:dataScope>
      </db:form>
      <%-- END: HTML Form --%>
    </uix:body>
  </uix:document>
</uix:renderingContext>
<%-- END: Content --%>
