<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%--
  -- Page:        clusterColumns.jsp
  -- Controller:  db/adm/schm/TableController.java
  --
  -- Description: Page for creating/editing a constraint.
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>
<%@ page import="oracle.sysman.emo.adm.schema.table.TableConst" %>

<uix:renderingContext id="renderingContext">
 <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
 <uix:bundle name="tblMsgs" class="oracle.sysman.db.rsc.schm.TableMsg"/>
<oem:setURLEncoder id="renderingContext"/>
<uix:document>
  
<%-- HTML Page Title --%>
<uix:metaContainer>
  <uix:head titleBinding="CLUSTER_COLUMNS_TITLE@uixTableBundle@servletRequest"/>
  <db:script src="/database/utils.js"/>   <%-- lovField support --%>
</uix:metaContainer>

  <script language="javascript">
          var destField;
          function callBackLov() { return (destField); }
  </script>

<uix:body>  

<%-- HTML Form --%>
<db:form name="tblForm" 
         method="post" 
         destinationBinding="destination@objectBean@servletRequest"
         copyParams="target,type,cancelURL,sname,oname,otype">
<uix:formValue name="pageName" value="<%= SchemaPages.TBL_CLUSTER_COLUMNS_PG %>"/>
<uix:pageLayout titleBinding="header@objectBean@servletRequest">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="constraintErrors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <uix:subTabLayout>

    <%-- Table SubTabs --%>
    <uix:subTabs>
      <jsp:include page="/database/schema/table/subTabsInclude.jsp" />
      <uix:ref refID="subTabsInclude" />
    </uix:subTabs>
    <%-- START: TABLE GENERAL PAGE starts here --%>

    <%-- START: General Info --%>
    <uix:tableLayout cellSpacing="5" hAlign="center" width="90%">
       <uix:checkBox name="asCluster"
                     checkedBinding="asCluster@objectBean@servletRequest"
                     disabledBinding="editing@objectBean@servletRequest"
                     textBinding="DEFINE_AS_CLUSTER@tblMsgs" />
       <uix:spacer width="15"/>
       <uix:rowLayout>
         <uix:cellFormat hAlign="right" width="80">
           <uix:messagePrompt labeledNodeId="CLUSTER_NAME" promptBinding="CLUSTER_NAME@dbMsgs"/>
         </uix:cellFormat>

         <uix:cellFormat>
         <uix:rowLayout>
         <uix:stackLayout>
           <uix:lovField id="CLUSTER_NAME"
                         name="clusterSchemaObjectName"
                         shortDescBinding="OBJECT_NAME@uixDBObjectBundle@servletRequest"
                         textBinding="clusterSchemaObjectName@objectBean@servletRequest" columns="60"
                         onClickBinding="clusterlovdest@servletRequest"
                         disabledBinding="editing@objectBean@servletRequest"/>

           <uix:switcher childNameBinding="creating@objectBean@servletRequest">
             <uix:case name="true">
               <uix:rowLayout>
                 <uix:messageText messageBinding="clusterSchemaObjectName@errors@servletRequest"
                                  messageType="error"/>
               </uix:rowLayout>
             </uix:case>
           </uix:switcher>
         </uix:stackLayout>

         <uix:spacer width="5"/>

         <uix:switcher childNameBinding="creating@objectBean@servletRequest">
           <uix:case name="true">
             <uix:submitButton textBinding="SHOW_COLUMNS@dbMsgs"
                               shortDescBinding="columnsButtonText@objectBean@servletRequest"
                               name="event" value="populate"/>
           </uix:case>
         </uix:switcher>
         </uix:rowLayout>
         </uix:cellFormat>
       </uix:rowLayout>
<%--
       <oem:table name="columnsTableUI"
                                   beanKey="indexColumnBean"
                                   formSubmitted="true"
                                   blockSize="25"
                                   dataSourceProp="columnsTableUI"
                                   width="100%"
                                   summaryBinding="TABLE_COLS_HEADER@uixIndexBundle@servletRequest"
                                   copyParams="target,type,cancelURL,sname,oname,otype"/>
--%>



    </uix:tableLayout> 
  </uix:subTabLayout>


  <%-- OK/CANCEL Button --%>
  <uix:pageButtons>
  <uix:pageButtonBar>
    <jsp:include page="/database/schema/pageButtonInclude.jsp" />
    <uix:ref refID="pageButtonInclude" />
  </uix:pageButtonBar>
  </uix:pageButtons>

</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>
</uix:body>

</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 
