<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%--
  -- Page:        constraintPage.jsp
  -- Controller:  db/adm/schm/TableController.java
  --
  -- Description: Page for creating/editing a constraint.
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>
<%@ page import="oracle.sysman.emo.adm.schema.table.TableConst" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>
<uix:document>
  
<%-- HTML Page Title --%>
<uix:metaContainer>
  <uix:head titleBinding="CONSTRAINTS_TITLE@uixTableBundle@servletRequest"/>
  <db:script src="/database/LOV.js"/>   <%-- lovField support --%>
  <db:script src="/database/utils.js"/>   <%-- lovField support --%>
</uix:metaContainer>

<uix:body>  

<%-- HTML Form --%>
<db:form name="tblForm" 
         method="post" 
         destinationBinding="destination@objectBean@servletRequest"
         copyParams="target,type,cancelURL,sname,oname,otype">
<uix:formValue name="pageName" value="<%= SchemaPages.TBL_CONSTRAINT_PG %>"/>

<%-- Default Event --%>
<uix:formValue name="event" value="<%= TableConst.J_CONSTR_OK %>" />
<uix:formValue name="schemaName" valueBinding="schemaName@objectBean@servletRequest"/>

<uix:pageLayout titleBinding="constraintHeader@tableConstraintBean@servletRequest">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="constraintErrors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>

  <%-- START: TAB CONTENTS starts here --%>
  <uix:stackLayout>
  
    <%-- Text about the constraint type selected --%>
    <uix:styledText styleClass="OraInstructionText"
                    textBinding="constraintDescription@tableConstraintBean@servletRequest" />

    <%-- Constraint Definition --%>
    <uix:header textBinding="DEFINITION@uixSchemaBundle@servletRequest">

      <%-- name --%>
      <uix:tableLayout width="75%" hAlign="center">
      <uix:rowLayout>
        <uix:cellFormat hAlign="right">
          <uix:messagePrompt promptBinding="NAME@uixDBObjectBundle@servletRequest" labeledNodeId="NAME"/>
        </uix:cellFormat>
        <uix:cellFormat>
          <uix:spacer height="1" width="5" />
        </uix:cellFormat>
        <uix:cellFormat hAlign="left">
          <uix:textInput name="constraintName" id="NAME" shortDescBinding="NAME@uixDBObjectBundle@servletRequest"
                         textBinding="constraintName@tableConstraintBean@servletRequest"
                         columns="50"
                         disabledBinding="constraintNameReadOnly@tableConstraintBean@servletRequest"/>
        </uix:cellFormat>
      </uix:rowLayout>

      <%-- define CHECK constraint --%>
      <uix:switcher childNameBinding="constraintType@tableConstraintBean@servletRequest">
      <uix:case name="CHECK">
        <uix:rowLayout>
          <uix:cellFormat hAlign="right">        
            <uix:messagePrompt promptBinding="CHECK_CONDITION@uixTableBundle@servletRequest" required="yes" labeledNodeId="CHECK_CONDITION"/>
          </uix:cellFormat>
          <uix:cellFormat>
            <uix:spacer height="1" width="5" />
          </uix:cellFormat>
          <uix:cellFormat hAlign="left">
            <uix:textInput name="constraintCheckCondition" id="CHECK_CONDITION" shortDescBinding="CHECK_CONDITION@uixTableBundle@servletRequest"
                           textBinding="constraintCheckCondition@tableConstraintBean@servletRequest"
                           columns="80"
                           disabledBinding="constraintCheckConditionReadOnly@tableConstraintBean@servletRequest"/>
          </uix:cellFormat>
        </uix:rowLayout>
      </uix:case>
      </uix:switcher>

      </uix:tableLayout>

    </uix:header>

    <%-- define PRIMARY, UNIQUE or FOREIGN constraint --%>
    <uix:switcher childNameBinding="constraintType@tableConstraintBean@servletRequest">

    <uix:case name="PRIMARY">
    <uix:switcher childNameBinding="constraintTableColumnsReadOnly@tableConstraintBean@servletRequest">

       <%-- PRIMARY: Read Only Table Column List --%>
       <uix:case name="true">
       <uix:header textBinding="TABLE_COLUMNS@uixTableBundle@servletRequest">
         <oem:list name="constraintTableColumns" 
                   optionsBinding="constraintTableColumns@tableConstraintBean@servletRequest"
                   disabled="true"/>
       </uix:header>
       </uix:case>

       <%-- PRIMARY: Shuttle Table Column List --%>
       <uix:case name="false">
         <uix:header textBinding="TABLE_COLUMNS@uixTableBundle@servletRequest">
         <oem:shuttle name="tableColumns" 
                      leadingHeaderBinding="AVAILABLE_COLS@uixTableBundle@servletRequest"
                      trailingHeaderBinding="SELECTED_COLS@uixTableBundle@servletRequest" 
                      size="5"
                      reorderable="true">
           <uix:leading>
             <oem:list name="availableColumns" shortDescBinding="AVAILABLE_COLS@uixTableBundle@servletRequest"
                       optionsBinding="availableColumns@tableConstraintBean@servletRequest"/>
           </uix:leading>
           <uix:trailing>
             <oem:list name="constraintTableColumns" shortDescBinding="SELECTED_COLS@uixTableBundle@servletRequest"
                       optionsBinding="constraintTableColumns@tableConstraintBean@servletRequest"/>
           </uix:trailing>
         </oem:shuttle>
         <uix:messageText messageType="error" messageBinding="tableColumns@errors@servletRequest" />
         </uix:header>
       </uix:case>

    </uix:switcher>
    </uix:case>

    <uix:case name="UNIQUE">
    <uix:switcher childNameBinding="constraintTableColumnsReadOnly@tableConstraintBean@servletRequest">

       <%-- UNIQUE: Read Only Table Column List --%>
       <uix:case name="true">
       <uix:header textBinding="TABLE_COLUMNS@uixTableBundle@servletRequest">
         <oem:list name="constraintTableColumns" 
                   optionsBinding="constraintTableColumns@tableConstraintBean@servletRequest"
                   disabled="true"/>
       </uix:header>
       </uix:case>

       <%-- UNIQUE: Shuttle Table Column List --%>
       <uix:case name="false">
         <uix:header textBinding="TABLE_COLUMNS@uixTableBundle@servletRequest">
         <oem:shuttle name="tableColumns" 
                      leadingHeaderBinding="AVAILABLE_COLS@uixTableBundle@servletRequest"
                      trailingHeaderBinding="SELECTED_COLS@uixTableBundle@servletRequest" 
                      size="5"
                      reorderable="true">
           <uix:leading>
             <oem:list name="availableColumns" shortDescBinding="AVAILABLE_COLS@uixTableBundle@servletRequest"
                       optionsBinding="availableColumns@tableConstraintBean@servletRequest"/>
           </uix:leading>
           <uix:trailing>
             <oem:list name="constraintTableColumns" shortDescBinding="SELECTED_COLS@uixTableBundle@servletRequest"
                       optionsBinding="constraintTableColumns@tableConstraintBean@servletRequest"/>
           </uix:trailing>
         </oem:shuttle>
         <uix:messageText messageType="error" messageBinding="tableColumns@errors@servletRequest" />
         </uix:header>
       </uix:case>

    </uix:switcher>
    </uix:case>

    <uix:case name="FOREIGN">
    <uix:switcher childNameBinding="constraintTableColumnsReadOnly@tableConstraintBean@servletRequest">

       <%-- FOREIGN: Read Only Table Column List --%>
       <uix:case name="true">
       <uix:tableLayout>
       <uix:rowLayout>
         <uix:cellFormat vAlign="top">
           <uix:header textBinding="TABLE_COLUMNS@uixTableBundle@servletRequest">
             <oem:list name="constraintTableColumns" 
                       optionsBinding="constraintTableColumns@tableConstraintBean@servletRequest"
                       disabled="true"/>
           </uix:header>
         </uix:cellFormat>
         <uix:cellFormat vAlign="top">
           <uix:header textBinding="REF_TABLE_COLUMNS@uixTableBundle@servletRequest">
           <uix:stackLayout>

               <%-- referenced table --%> 
               <uix:flowLayout>
                 <uix:messagePrompt promptBinding="REF_TABLE@uixTableBundle@servletRequest" required="yes" labeledNodeId="REF_TABLE"/>
                 <uix:lovField name="onSchemaAndObject"
                               id="REF_TABLE" shortDescBinding="REF_TABLE@uixTableBundle@servletRequest"
                               searchDescBinding="REF_TABLE@uixTableBundle@servletRequest"
                               textBinding="onSchemaAndObject@tableConstraintBean@servletRequest" 
                               onClickBinding="constlovdest@servletRequest"
                               disabled="true" />
               </uix:flowLayout>

               <%-- referenced table column list --%>
               <oem:list name="constraintReferencedColumns" 
                         optionsBinding="constraintReferencedColumns@tableConstraintBean@servletRequest"
                         disabled="true"/>
           </uix:stackLayout>
           </uix:header>
         </uix:cellFormat>
       </uix:rowLayout>
       </uix:tableLayout>
       </uix:case>

       <%-- FOREIGN: Shuttle Table Column List --%>
       <uix:case name="false">
       <uix:tableLayout>
       <uix:rowLayout>
         <uix:cellFormat vAlign="top">
         <uix:header textBinding="TABLE_COLUMNS@uixTableBundle@servletRequest">
         <oem:shuttle name="tableColumns" 
                      leadingHeaderBinding="AVAILABLE_COLS@uixTableBundle@servletRequest"
                      trailingHeaderBinding="SELECTED_COLS@uixTableBundle@servletRequest" 
                      size="5"
                      reorderable="true">
           <uix:leading>
             <oem:list name="availableColumns" shortDescBinding="AVAILABLE_COLS@uixTableBundle@servletRequest"
                       optionsBinding="availableColumns@tableConstraintBean@servletRequest"/>
           </uix:leading>
           <uix:trailing>
             <oem:list name="constraintTableColumns" shortDescBinding="SELECTED_COLS@uixTableBundle@servletRequest"
                       optionsBinding="constraintTableColumns@tableConstraintBean@servletRequest"/>
           </uix:trailing>
         </oem:shuttle>
         <uix:messageText messageType="error" messageBinding="tableColumns@errors@servletRequest" />
         </uix:header>
         </uix:cellFormat>
         <uix:cellFormat vAlign="top">
         <uix:header textBinding="REF_TABLE_COLUMNS@uixTableBundle@servletRequest">
         <uix:stackLayout>

           <%-- referenced table --%>
           <uix:rowLayout>
             <uix:messagePrompt promptBinding="REF_TABLE@uixTableBundle@servletRequest" required="yes" labeledNodeId="REF_TABLE"/>
             <uix:spacer width="5"/>
             <uix:messageLovField name="onSchemaAndObject" 
                                  id="REF_TABLE"
                                  shortDescBinding="REF_TABLE@uixTableBundle@servletRequest"
                                  searchDescBinding="REF_TABLE@uixTableBundle@servletRequest"
                                  textBinding="onSchemaAndObject@tableConstraintBean@servletRequest"
                                  onClick="setSearchFilter('schemaName');startLov('onSchemaAndObject','ListSchemaTable')"/>
             <uix:spacer width="5"/>
             <uix:submitButton textBinding="GO@uixDBObjectBundle@servletRequest" 
                               shortDescBinding="GO@uixDBObjectBundle@servletRequest"
                               name="event"
                               value="<%= TableConst.J_CONSTR_SET_REF_TABLE %>" />
           </uix:rowLayout>

           <%-- referenced table columns --%>
           <oem:shuttle name="referencedTableColumns" 
                        leadingHeaderBinding="AVAILABLE_COLS@uixTableBundle@servletRequest"
                        trailingHeaderBinding="SELECTED_COLS@uixTableBundle@servletRequest" 
                        size="5"
                        reorderable="true">
             <uix:leading>
               <oem:list name="availableReferencedColumns" shortDescBinding="AVAILABLE_COLS@uixTableBundle@servletRequest"
                         optionsBinding="availableReferencedColumns@tableConstraintBean@servletRequest"/>
             </uix:leading>
             <uix:trailing>
               <oem:list name="constraintReferencedColumns" shortDescBinding="SELECTED_COLS@uixTableBundle@servletRequest"
                         optionsBinding="constraintReferencedColumns@tableConstraintBean@servletRequest"/>
             </uix:trailing>
           </oem:shuttle>
           <uix:messageText messageType="error" messageBinding="referencedTableColumns@errors@servletRequest" />
         </uix:stackLayout>
         </uix:header>
         </uix:cellFormat>
       </uix:rowLayout>
       </uix:tableLayout>
       </uix:case>

    </uix:switcher>
    </uix:case>

    </uix:switcher>

    <%-- Attributes --%>
    <uix:header textBinding="ATTRIBUTES@uixSchemaBundle@servletRequest">
    <uix:stackLayout>
   
       <%-- disabled --%>
       <uix:checkBox name="constraintDisable" 
                     checkedBinding="constraintDisable@tableConstraintBean@servletRequest" 
                     textBinding="DISABLED@uixDBObjectBundle@servletRequest" />

       <%-- deferrable --%>
       <uix:checkBox  name="constraintDeferrable" 
                      checkedBinding="constraintDeferrable@tableConstraintBean@servletRequest" 
                      textBinding="DEFERRABLE_CONST@uixTableBundle@servletRequest"
                      disabledBinding="constraintDeferrableReadOnly@tableConstraintBean@servletRequest" />

       <%-- initially deferred --%>
       <uix:flowLayout>
         <uix:spacer height="1" width="10" />
            <uix:checkBox name="constraintInitiallyDeferred" 
                          checkedBinding="constraintInitiallyDeferred@tableConstraintBean@servletRequest" 
                          textBinding="INIT_DEFERRED_CONST@uixTableBundle@servletRequest"
                          disabledBinding="constraintInitiallyDeferredReadOnly@tableConstraintBean@servletRequest" />
       </uix:flowLayout>

       <%-- validate --%>
       <uix:checkBox name="constraintValidate"
                     checkedBinding="constraintValidate@tableConstraintBean@servletRequest" 
                     textBinding="VALIDATE_CONST@uixTableBundle@servletRequest"
                     disabledBinding="constraintValidateReadOnly@tableConstraintBean@servletRequest"/>

       <%-- rely --%>
       <uix:switcher childNameBinding="versionEqualOrHigher81@objectBean@servletRequest">
       <uix:case name="true">
         <uix:checkBox name="constraintRELY"
                       checkedBinding="constraintRELY@tableConstraintBean@servletRequest"
                       textBinding="RELY_CONST@uixTableBundle@servletRequest"
                       disabledBinding="constraintRELYReadOnly@tableConstraintBean@servletRequest"/>
       </uix:case>
       </uix:switcher>

       <%-- on delete cascade  --%>
       <uix:switcher childNameBinding="foreignConstraintType@tableConstraintBean@servletRequest">
       <uix:case name="true">
         <uix:checkBox name="constraintCascadeOnDelete"
                       checkedBinding="constraintCascadeOnDelete@tableConstraintBean@servletRequest" 
                       textBinding="CASCADE_ON_DEL_CONST@uixTableBundle@servletRequest"
                       disabledBinding="constraintCascadeOnDeleteReadOnly@tableConstraintBean@servletRequest"/>
       </uix:case>
       </uix:switcher>


    </uix:stackLayout>
    </uix:header>


  </uix:stackLayout>
  <%-- END: TAB CONTENTS ends here --%>   
        
  <%-- OK/CANCEL Button --%>
  <uix:pageButtons>
  <uix:pageButtonBar>

    <%-- CANCEL BUTTON --%>
    <uix:switcher childNameBinding="addMode@tableConstraintBean@servletRequest">
    <uix:case name="true">
        <uix:submitButton textBinding="CANCEL@uixDBObjectBundle@servletRequest" 
                          shortDescBinding="CANCEL@uixDBObjectBundle@servletRequest"
                          name="event" 
                          value="<%= TableConst.J_CONSTR_CANCEL_ADD %>" />
    </uix:case>
    <uix:case name="false">
        <uix:submitButton textBinding="CANCEL@uixDBObjectBundle@servletRequest" 
                          shortDescBinding="CANCEL@uixDBObjectBundle@servletRequest"
                          name="event" 
                          value="<%= TableConst.J_CONSTR_CANCEL_EDIT %>" />
    </uix:case>
    </uix:switcher>

    <%-- OK BUTTON --%>
    <uix:submitButton textBinding="CONTINUE@uixDBObjectBundle@servletRequest" 
                      shortDescBinding="CONTINUE@uixDBObjectBundle@servletRequest"
                      name="event" 
                      value="<%= TableConst.J_CONSTR_OK %>" />

  </uix:pageButtonBar>
  </uix:pageButtons>

</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>
</uix:body>

</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 
