<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%--
  -- Page:       constraintsPage.jsp
  -- Controller: db/adm/schm/TableController.java
  --
  -- Description: The Constraints tab for Table.  
  --              This tab allows the user to create/edit and see 
  --              their table constraints.
  --%>


<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>
<%@ page import="oracle.sysman.emo.adm.schema.table.TableConst" %>


<uix:renderingContext id="renderingContext">
<uix:bundle name="tblMsgs" class="oracle.sysman.db.rsc.schm.TableMsg"/>
<oem:setURLEncoder id="renderingContext"/>
<uix:document>
  
<%-- HTML Page Title --%>
<%-- Fix Bug 4080599, for future release
<%@ include file="/oemTitle.jspf" %>
--%>
<uix:metaContainer>
  <uix:head titleBinding="CONSTRAINTS_TITLE@uixTableBundle@servletRequest"/>
</uix:metaContainer>

<%-- HTML Form --%>
<uix:body>

<db:form name="tblForm"
         method="post"
         destinationBinding="destination@objectBean@servletRequest"
         copyParams="target,type,cancelURL,sname,oname,otype">

<uix:formValue name="pageName" value="<%= SchemaPages.TBL_CONSTRAINTS_PG %>"/>
<uix:pageLayout titleBinding="header@objectBean@servletRequest">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>

  <%-- Create/Edit/View Header --%>
  <uix:subTabLayout>
    
    <%-- Table SubTabs --%>
    <uix:subTabs>
      <jsp:include page="/database/schema/table/subTabsInclude.jsp" />
      <uix:ref refID="subTabsInclude" />
    </uix:subTabs>

    <%-- START: TABLE CONSTRAINTS PAGE starts here --%>
    <uix:stackLayout>

    <uix:spacer height="5"/>

    <%-- Constraint Choice Box --%>
    <uix:rowLayout hAlign="right">
    <uix:flowLayout>
      <uix:styledText textBinding="CONSTRAINTS@tblMsgs" labeledNodeId="CONSTRAINTS"
      styleClass="OraPromptText" />
      <oem:choice name="addConstraintType" optionsBinding="constraintTypes@tableConstraintBean@servletRequest" shortDescBinding="ADD@uixDBObjectBundle@servletRequest" />
      <uix:submitButton textBinding="ADD@uixDBObjectBundle@servletRequest" 
                        shortDescBinding="ADD@uixDBObjectBundle@servletRequest" 
                        name="event" 
                        value="<%= TableConst.J_CONSTR_ADD %>"/>
    </uix:flowLayout>
    </uix:rowLayout>    

    <uix:spacer height="25"/>

    <%-- Constraint Table --%>
    <oem:table name="constraintsTableUI" 
               blockSize="10"
               beanKey="tableConstraintBean"
               summaryBinding="ADD@uixDBObjectBundle@servletRequest"
               destinationBinding="destination@objectBean@servletRequest" 
               formSubmitted="true" 
               dataSourceProp="constraintsTableUI" 
               width="100%"
               alternateTextBinding="NO_CONSTRAINTS@uixTableBundle@servletRequest"
               copyParams="target,type,cancelURL,sname,oname,otype" >
      <uix:tableSelection>
      <uix:singleSelection shortDescBinding="SELECT@uixDBObjectBundle@servletRequest"
           selectedIndexBinding="selectedIndexUI@tableConstraintBean@servletRequest">
        <uix:submitButton textBinding="EDIT@uixDBObjectBundle@servletRequest" 
                          shortDescBinding="EDIT@uixDBObjectBundle@servletRequest"
                          name="event" 
                          value="<%= TableConst.J_CONSTR_EDIT %>"/>
        <uix:submitButton textBinding="DELETE@uixDBObjectBundle@servletRequest"
                          shortDescBinding="DELETE@uixDBObjectBundle@servletRequest"
                          name="event"
                          value="<%= TableConst.J_CONSTR_DELETE %>"/>
      </uix:singleSelection>
      </uix:tableSelection>
    </oem:table>

    <uix:spacer height="5"/>

    </uix:stackLayout>
    <%-- END: TABLE CONSTRAINTS PAGE starts here --%>

  </uix:subTabLayout>  

  <%-- Table Buttons --%>
  <uix:pageButtons>
  <uix:pageButtonBar>
    <jsp:include page="/database/schema/pageButtonInclude.jsp" />
    <uix:ref refID="pageButtonInclude" />
  </uix:pageButtonBar>
  </uix:pageButtons>

</uix:pageLayout>
</db:form>
</uix:body>
<%-- END: HTML Form --%>

</uix:document>
</uix:renderingContext>
<%-- END: Content --%>

