<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%--
  -- Page:        defaultLobStoragePage.jsp
  -- Controller:  db/adm/schm/TableGeneralController.java
  --
--%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<db:script  src="/database/utils.js"/>
<script language="javascript">
function setLOBOptions() 
{
  if (document.forms[0].retention != null)
        initLOBStorageOptions();

  if (document.forms[0].bfretention != null)
        initBFLOBStorageOptions();
}
</script>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>
<%@ page import="oracle.sysman.emo.adm.schema.table.TableConst" %>

<uix:renderingContext id="renderingContext">
  <uix:bundle name="msgs"
              class="oracle.sysman.db.rsc.schm.PartitionsMsg"/>
<oem:setURLEncoder id="renderingContext"/>
<uix:document>
  
<%-- HTML Page Title --%>
<uix:metaContainer>
  <uix:head titleBinding="SET_DEFAULT_LOB_ATTRS@uixTableBundle@servletRequest"/>
  <db:script src="/database/LOV.js" />
</uix:metaContainer>

<uix:body onLoad="setLOBOptions()">
<%-- HTML Form --%>
<db:form name="tblForm" 
         method="post" 
         destinationBinding="destination@objectBean@servletRequest"
         copyParams="target,type,cancelURL,sname,oname,otype">
<uix:formValue name="pageName" value="<%= SchemaPages.TBL_DEF_LOB_ATTR_PG %>"/>
<uix:pageLayout titleBinding="SET_DEFAULT_LOB_ATTRS@uixTableBundle@servletRequest">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errorsSetDefLobAttrPage@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
                  
  <uix:stackLayout> 
     
      <uix:spacer height="10"/>

        <uix:styledText styleClass="OraInstructionText"
                        textBinding="DEFAULT_LOB_HINT@uixTableBundle@servletRequest" />
     
    <uix:dataScope currentDataBinding="lobSegment@servletRequest">
      <jsp:include page="/database/schema/utilities/lobStorageInclude.jsp" />
      <uix:ref refID="lobStorageInclude" />
    </uix:dataScope>

  </uix:stackLayout>
        
  <%-- OK/CANCEL Button --%>
  <uix:pageButtons>
  <uix:pageButtonBar>

    <%-- CANCEL BUTTON --%>
    <uix:submitButton textBinding="CANCEL@uixDBObjectBundle@servletRequest" 
                      shortDescBinding="CANCEL@uixDBObjectBundle@servletRequest" 
                      name="event" 
                      unvalidated="true"
                      value="<%= TableConst.J_DEF_LOB_ATTR_CANCEL %>" />

    <%-- OK BUTTON --%>
    <uix:submitButton textBinding="OK@uixDBObjectBundle@servletRequest" 
                      shortDescBinding="OK@uixDBObjectBundle@servletRequest" 
                      name="event" 
                      value="<%= TableConst.J_DEF_LOB_ATTR_OK %>" />

  </uix:pageButtonBar>
  </uix:pageButtons>

</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>
</uix:body>

</uix:document>
</uix:renderingContext>
<%-- END: Content --%> 
