<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:       estimateTableSizePage.jsp
  -- Controller: db/adm/schm/TableController.java
  --
  -- Description: 
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>
<%@ page import="oracle.sysman.emo.adm.schema.table.TableConst" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>
<uix:document>
  
<%-- HTML Page Title --%>
<uix:metaContainer>
  <uix:head titleBinding="STORAGE_TITLE@uixTableBundle@servletRequest"/>
</uix:metaContainer>

<uix:body>

<%-- HTML Form --%>
<db:form name="tblForm" 
         method="post" 
         destinationBinding="destination@objectBean@servletRequest"
         copyParams="target,type,cancelURL,sname,oname,otype">
<uix:formValue name="pageName" value="<%= SchemaPages.TBL_ESTIMATE_SIZE_PG%>"/>

<uix:pageLayout titleBinding="ESTIMATE_TABLE_SIZE@uixDBObjectBundle@servletRequest">   
  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
                  
          <uix:tableLayout cellSpacing="5">
          <uix:rowLayout>
               <uix:styledText styleClass="OraInstructionText"
                  textBinding="ESTIMATE_TEXT_TABLE@uixDBObjectBundle@servletRequest"/>
            </uix:rowLayout>
            </uix:tableLayout>
            <uix:tableLayout cellSpacing="5" width="75%">
            <uix:rowLayout>
              <uix:cellFormat hAlign="right">
                <uix:messagePrompt promptBinding="PROJECTED_ROW_COUNT@uixDBObjectBundle@servletRequest"/>
              </uix:cellFormat>
              <uix:cellFormat>
                <uix:rowLayout>
                  <uix:textInput name="projectedRowCount" 
                                 textBinding="projectedRowCount@tableEstimateSizeUIBean@servletRequest"    
                                 columns="10">
                    <uix:onSubmitValidater><uix:decimal/></uix:onSubmitValidater>
                  </uix:textInput> 
                  <uix:spacer width="5" />
                  <uix:submitButton textBinding="ESTIMATE_TABLE_SIZE@uixDBObjectBundle@servletRequest"
                                name="event" 
                                value="<%= TableConst.J_ESTIMATE_SIZE_BUTTON %>"/>
                </uix:rowLayout>
              </uix:cellFormat>
            </uix:rowLayout>
          </uix:tableLayout>
      
          <uix:header textBinding="estimateSizeResultHeader@tableEstimateSizeUIBean@servletRequest">          
            <uix:tableLayout width="75%">
                <uix:rowLayout>
                  <uix:cellFormat>
                    <uix:tableLayout cellSpacing="5">
                      <uix:rowLayout>
                        <uix:cellFormat hAlign="right">
                          <uix:messagePrompt promptBinding="ESTIMATED_SIZE_TABLE@uixDBObjectBundle@servletRequest"/>
                        </uix:cellFormat>     
                        <uix:cellFormat>
                          <uix:styledText styleClass="OraDataText" 
                                          textBinding="estimatedTableSize@tableEstimateSizeUIBean@servletRequest"/>  
                        </uix:cellFormat>
                      </uix:rowLayout>
                      <uix:rowLayout>
                        <uix:cellFormat hAlign="right">
                          <uix:messagePrompt promptBinding="SPACE_ALLOCATED@uixDBObjectBundle@servletRequest"/>
                        </uix:cellFormat>
                        <uix:cellFormat>
                          <uix:styledText styleClass="OraDataText" 
                                          textBinding="spaceAllocated@tableEstimateSizeUIBean@servletRequest"/>  
                        </uix:cellFormat>
                      </uix:rowLayout>

<%--
                      <uix:rowLayout>
                        <uix:cellFormat hAlign="right">
                          <uix:messagePrompt promptBinding="FREE_SPACE@uixDBObjectBundle@servletRequest"/>
                        </uix:cellFormat>
                        <uix:cellFormat>
                          <uix:styledText styleClass="OraDataText"  
                                          textBinding ="freeSpaceAfterAllocationPct@tableEstimateSizeUIBean@servletRequest"/>  
                        </uix:cellFormat>
                      </uix:rowLayout>                                
--%>

                    </uix:tableLayout>
                  </uix:cellFormat>
                </uix:rowLayout>
      
                <uix:rowLayout>
                  <uix:cellFormat>
                    <uix:spacer height="5" />
                  </uix:cellFormat>
                </uix:rowLayout>
      
                <uix:rowLayout>
                  <uix:cellFormat>
                    <uix:tip>
                      <uix:styledText styleClass="OraTipText" textBinding="ESTIMATED_TABLE_SIZE@uixDBObjectBundle@servletRequest" />
                    </uix:tip>
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:tableLayout>
            </uix:header> 
      

  <%-- Table Buttons --%>
  <uix:pageButtons>
  <uix:pageButtonBar>
    <uix:flowLayout>
      <uix:submitButton textBinding="OK@uixDBObjectBundle@servletRequest" 
                      name="event" 
                      value="cancelEstimateTableSize"/>
    </uix:flowLayout>
  </uix:pageButtonBar>
  </uix:pageButtons>

</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>
</uix:body>

</uix:document>
</uix:renderingContext>
<%-- END: Content --%>
