<%--
  -- Page:        generalColumnInclude.jsp
  -- Controller:  db/adm/schm/TableGeneralController.java
  --
  -- Description: The jsp for the ui table where the user defines the table columns. 
  --              The table supports Attributes, Abstract Data Type and Delete.
  --%>
  <%-- Tag Libraries --%>
  <%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
  <%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
  <%-- Imports --%>
  <%@ page import="oracle.sysman.emo.adm.schema.table.TableConst"%>
  <%-- COLUMN TABLE DEFINITION --%>
  <uix:buildTree nodeID="generalColumnInclude">
    <uix:dataScope>
	         

      <%-- Message Bundles Used --%>
      <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
      <uix:bundle name="schmMsgs" class="oracle.sysman.db.rsc.schm.SchemaMsg"/>
      <uix:bundle name="tblMsgs" class="oracle.sysman.db.rsc.schm.TableMsg"/>
      <uix:tableLayout width="80%">
        <uix:stackLayout>
          <%-- start : header --%>

          <uix:header textBinding="COLUMNS_HEADER@tblMsgs">
            <uix:stackLayout>
              <uix:cellFormat hAlign="right">
                <uix:submitButton textBinding="SET_DEFAULT_LOB_ATTRS@tblMsgs" shortDescBinding="SET_DEFAULT_LOB_ATTRS@tblMsgs" name="event" value="<%= TableConst.J_SET_DEF_LOB_ATTRS %>" renderedBinding="isEnabled@"/>

                <uix:submitButton textBinding="ENCRYPTION_OPTIONS@schmMsgs" shortDescBinding="ENCRYPTION_OPTIONS@schmMsgs" name="event" value="<%= TableConst.J_COL_TBL_ENCRYPTION_OPTIONS %>" renderedBinding="encryptionButtonEnabled@objectBean@servletRequest" disabledBinding="<%= TableConst.J_COL_TBL_ENCRYPT_BUTTON_DISABLED %>"/> 
 

              </uix:cellFormat>
            </uix:stackLayout>
            <%-- columns table --%>
            <uix:stackLayout>
              <uix:table name="<%= TableConst.J_COL_TBL %>" width="100%" tableDataBinding="multiCols@" formSubmitted="true" minValue="1" blockSizeBinding="tblBlockSize@" maxValueBinding="rowCount@" valueBinding="startIndex@" summaryBinding="COLUMNS_HEADER@tblMsgs">
                <uix:tableFormat tableBanding="rowBanding"/>
                <uix:tableSelection>
                  <uix:singleSelection selectedIndexBinding="selectedIndexUI@" shortDescBinding="SELECT@dbMsgs" renderedBinding="isEnabled@">
                    <uix:submitButton textBinding="ADVANCED_ATTRIBUTES@tblMsgs" shortDescBinding="ADVANCED_ATTRIBUTES@tblMsgs" name="event" value="<%= TableConst.J_ADVANCED_ATTRS %>" renderedBinding="isEnabled@"/>
                    <uix:submitButton textBinding="DELETE@dbMsgs" shortDescBinding="DELETE@dbMsgs" name="event" value="<%= TableConst.J_DELETE_COL %>" renderedBinding="isEnabled@"/>
                    <uix:spacer width="10"/>
                    <uix:messageChoice name="insertColumnType" promptBinding="INSERT_COLUMN@tblMsgs" shortDescBinding="DATA_TYPE@dbMsgs" selectedValueBinding="insertColumnType@">
                      <uix:option textBinding="ABSTRACT_DT@tblMsgs" value="<%= TableConst.COL_NON_STANDARD %>"/>
                      <uix:option textBinding="STANDARD_DT@tblMsgs" value="<%= TableConst.COL_STANDARD %>"/>
                    </uix:messageChoice>
                    <uix:submitButton textBinding="INSERT@schmMsgs" shortDescBinding="INSERT@schmMsgs" name="event" value="<%= TableConst.J_COL_TBL_INSERT %>" renderedBinding="isEnabled@"/>
                    <%--<uix:submitButton textBinding="ENCRYPTION_OPTIONS@schmMsgs" shortDescBinding="ENCRYPTION_OPTIONS@schmMsgs" name="event" value="<%= TableConst.J_COL_TBL_ENCRYPTION_OPTIONS %>" renderedBinding="isVersionEqualOrHigher102@"/> 
<%--  <uix:submitButton textBinding="ENCRYPTION_OPTIONS@schmMsgs" shortDescBinding="ENCRYPTION_OPTIONS@schmMsgs" name="event" value="<%= TableConst.J_COL_TBL_ENCRYPTION_OPTIONS %>" renderedBinding="isVersionEqualOrHigher102@"/> --%>

                  </uix:singleSelection>
                </uix:tableSelection>
                <%-- Column Table:  Primary Key Column --%>
                <uix:column>
                  <uix:columnHeader>
                    <uix:styledText shortDescBinding="PRIMARY_KEY_COL@tblMsgs"/>
                  </uix:columnHeader>
                  <uix:flowLayout>
                    <uix:switcher childNameBinding="<%= TableConst.J_COL_TBL_PK %>" >
                      <uix:case name="PRIMARY">
                        <uix:image sourceBinding="<%= TableConst.J_COL_TBL_PK_PIC %>"
                                   shortDescBinding="YES@dbMsgs"/>
                      </uix:case>
	              <uix:case name="SECURE">
                        <uix:image sourceBinding="<%= TableConst.J_COL_TBL_SECURE_PIC %>"
                                   shortDescBinding="SECURE_LOB@tblMsgs"/>
                      </uix:case>
                      <uix:case name="NONE">
                        <uix:image sourceBinding="<%= TableConst.J_COL_TBL_NO_PK_PIC %>"
                                   shortDescBinding="NO@dbMsgs"/>
                      </uix:case>
                    </uix:switcher>   
                    <uix:switcher childNameBinding="<%= TableConst.J_COL_TBL_UNIQUE %>" >
	              <uix:case name="UNIQUE">
                        <uix:image sourceBinding="<%= TableConst.J_COL_TBL_UNIQUE_PIC %>"
                                   shortDescBinding="YES@dbMsgs"/>
                      </uix:case>
                      <uix:case name="NONE">
                        <uix:image sourceBinding="<%= TableConst.J_COL_TBL_NO_PK_PIC %>"
                                   shortDescBinding="NO@dbMsgs"/>
                      </uix:case>
                    </uix:switcher>   
                  </uix:flowLayout>
                </uix:column>
                <%-- Column Table:  Name --%>
               
    <uix:column>
      <uix:columnHeader>
        <uix:styledText textBinding="NAME@dbMsgs"/>
      </uix:columnHeader>
      <uix:columnFormat columnDataFormat="textFormat"/>
	  <uix:textInput renderedBinding="isNameDisabledFalse@"columns="25" shortDescBinding="NAME@dbMsgs"
                         name="<%= TableConst.J_COL_TBL_NAME %>"
                         textBinding="<%= TableConst.J_COL_TBL_NAME %>"/>
	  <uix:styledText renderedBinding="isViewNotSpatial@" textBinding="<%= TableConst.J_COL_TBL_NAME %>"/>
	  <uix:link renderedBinding="isViewSpatial@" textBinding="<%= TableConst.J_COL_TBL_NAME %>" destinationBinding="tableColNameDest"/>
           <uix:onSubmitValidater>
        <uix:decimal />
      </uix:onSubmitValidater>
    </uix:column> 
	     <%-- Column Table: Datatype --%>
                <uix:column>
                  <uix:columnHeader>
                    <uix:styledText textBinding="DATA_TYPE@dbMsgs"/>
                  </uix:columnHeader>
                  <uix:columnFormat columnDataFormat="textFormat"/>
                  <uix:switcher childNameBinding="isAbstractTypeOrDisabled@">
                    <uix:case name="false">
                      <oem:choice name="<%= TableConst.J_COL_TBL_DATA_TYPE %>" shortDescBinding="DATA_TYPE@dbMsgs" selectedValueBinding="standardTypesDropDownListChoice@" optionsBinding="standardTypesDropDownList@"/>
                    </uix:case>
                    <uix:case name="true">
                      <uix:styledText textBinding="cColAbstType"/>
                    </uix:case>
                  </uix:switcher>
                </uix:column>
                <%-- Column Table: Size --%>
                <uix:column>
                  <uix:columnHeader>
                    <uix:styledText textBinding="SIZE@tblMsgs"/>
                  </uix:columnHeader>
                  <uix:switcher childNameBinding="isAbstractTypeOrDisabled@">
                    <uix:case name="false">
                      <uix:textInput columns="7" shortDescBinding="SIZE@tblMsgs" name="<%= TableConst.J_COL_TBL_SIZE %>" readOnlyBinding="showSize@" textBinding="<%= TableConst.J_COL_TBL_SIZE %>"/>
                    </uix:case>
                    <uix:case name="true">
                      <uix:styledText textBinding="size@"/>
                    </uix:case>
                  </uix:switcher>
                </uix:column>
                <%-- Column Table: Scale --%>
                <uix:column>
                  <uix:columnHeader>
                    <uix:styledText textBinding="SCALE@tblMsgs"/>
                  </uix:columnHeader>
                  <uix:columnFormat columnDataFormat="textFormat"/>
                  <uix:switcher childNameBinding="isAbstractTypeOrDisabled@">
                    <uix:case name="false">
                      <uix:textInput columns="7" shortDescBinding="SCALE@tblMsgs" name="<%= TableConst.J_COL_TBL_SCALE %>" readOnlyBinding="showScale@" textBinding="<%= TableConst.J_COL_TBL_SCALE %>">
                        <uix:onSubmitValidater>
                          <uix:decimal/>
                        </uix:onSubmitValidater>
                      </uix:textInput>
                    </uix:case>
                    <uix:case name="true">
                      <uix:styledText textBinding="scale@"/>
                    </uix:case>
                  </uix:switcher>
                </uix:column>
                <%-- Column Table: Not Null --%>
                <uix:column>
                  <uix:columnHeader>
                    <uix:styledText textBinding="NOT_NULL@tblMsgs"/>
                  </uix:columnHeader>
                  <uix:columnFormat columnDataFormat="iconButtonFormat"/>
                  <uix:checkBox name="<%= TableConst.J_COL_TBL_NOT_NULL %>" shortDescBinding="NOT_NULL@tblMsgs" checkedBinding="<%= TableConst.J_COL_TBL_NOT_NULL %>" disabledBinding="<%= TableConst.J_COL_TBL_NOT_NULL_DISABLED %>"/>
                </uix:column>
                <%-- Column Table: Default Value --%>
                <uix:column>
                  <uix:columnHeader>
                    <uix:styledText textBinding="DEFAULT_VALUE@tblMsgs"/>
                  </uix:columnHeader>
                  <uix:columnFormat columnDataFormat="textFormat"/>
                  <uix:switcher childNameBinding="isDisabled@">
                    <uix:case name="false">
                      <uix:textInput columns="15" shortDescBinding="DEFAULT_VALUE@tblMsgs" name="<%= TableConst.J_COL_TBL_DEFAULT %>" readOnlyBinding="showDefault@" textBinding="<%= TableConst.J_COL_TBL_DEFAULT %>"/>
                    </uix:case>
                    <uix:case name="true">
                      <uix:styledText textBinding="defaultValue@"/>
                    </uix:case>
                  </uix:switcher>
                </uix:column>


                <%-- Column Table: ENCRYPTED --%>
                <uix:column  renderedBinding="isVersionEqualOrHigher102@"> 
                  <uix:columnHeader>
                    <uix:styledText textBinding="ENCRYPTED@tblMsgs"/>
                  </uix:columnHeader>
                  <uix:columnFormat columnDataFormat="iconButtonFormat"/>
                  <uix:checkBox name="<%= TableConst.J_COL_TBL_ENCRYPTED %>" shortDescBinding="ENCRYPTED@tblMsgs" checkedBinding="<%= TableConst.J_COL_TBL_ENCRYPTED %>" disabledBinding="<%= TableConst.J_COL_TBL_ENCRYPTED_DISABLED %>"/>
                </uix:column>




                <uix:footer>
                  <uix:submitButton textBinding="ADD_ROWS@tblMsgs" shortDescBinding="ADD_ROWS@tblMsgs" name="event" value="<%= TableConst.J_ADD_COLS %>" renderedBinding="isEnabled@"/>
                </uix:footer>
              </uix:table>
              <uix:flowLayout>
                <uix:image sourceBinding="<%= TableConst.J_COL_TBL_PK_PIC %>" shortDescBinding="YES@dbMsgs"/>
                <uix:styledText textBinding="PRIMARY_KEY_INFO@tblMsgs" styleClass="OraTipText"/>
              </uix:flowLayout>
              <uix:flowLayout> <uix:image sourceBinding="<%= TableConst.J_COL_TBL_UNIQUE_PIC %>" shortDescBinding="YES@dbMsgs"/>
                <uix:styledText textBinding="UNIQUE_KEY_INFO@tblMsgs" styleClass="OraTipText" />
              </uix:flowLayout>
              <uix:flowLayout renderedBinding="isVersionEqualOrHigher11@"> <uix:image sourceBinding="<%= TableConst.J_COL_TBL_SECURE_PIC %>" shortDescBinding="YES@dbMsgs"/>
                <uix:styledText textBinding="SECURE_FILE_ICON@tblMsgs" styleClass="OraTipText" />
              </uix:flowLayout>
            </uix:stackLayout>
            <%-- error messages --%>
            <uix:messageText messageType="error" messageBinding="columnsTableUI@errors@servletRequest"/>
          </uix:header>
          <%-- end : header --%>
        </uix:stackLayout>
      </uix:tableLayout>
    </uix:dataScope>
  </uix:buildTree>
