<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%--
  -- Page:       generalPage.jsp
  -- Controller: db/adm/schm/TableController.java
  --
  -- Description: The General tab for Table.  
  --              This tab contains all the basic elements for defining a table
--%>


<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>
<%@ page import="oracle.sysman.emo.adm.schema.table.TableConst" %>

<uix:renderingContext id="renderingContext">

    <%-- Message Bundles --%>
    <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
    <uix:bundle name="tblMsgs" class="oracle.sysman.db.rsc.schm.TableMsg"/>

    <oem:setURLEncoder id="renderingContext"/>
    <uix:document>
  
        <%-- HTML Page Title --%>
        <%-- Fix Bug 4080599, for future release
        <%@ include file="/oemTitle.jspf" %>
        --%>
        <uix:metaContainer>
            <uix:head titleBinding="GENERAL_TITLE@tblMsgs"/>
            <db:script src="/database/LOV.js" />
        </uix:metaContainer>

        <uix:body>

            <%-- HTML Form --%>
            <db:form name="tblForm" 
                method="post" 
                destinationBinding="destination@objectBean@servletRequest"
                copyParams="target,type,cancelURL,sname,oname,otype" >

                <uix:formValue name="pageName" value="<%= SchemaPages.TBL_GENERAL_PG %>"/>
                <uix:pageLayout titleBinding="header@objectBean@servletRequest">

                    <%-- Oracle Logo and Tabs --%>
                    <%@ include file="/database/global.jspf" %>

                    <%-- Warning/Error display --%>
                    <oem:messageBox messageType="info" 
                    errorTableBinding="info@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>
                    
                    <oem:messageBox messageType="error" 
                    errorTableBinding="errors@servletRequest"
                    titleTextKey="titleText" mainTextKey="mainText"/>

                    <%-- Create/Edit/View Header --%>
                    <uix:subTabLayout>
    
                        <%-- Table SubTabs --%>
                        <uix:subTabs>
                            <jsp:include page="/database/schema/table/subTabsInclude.jsp" />
                            <uix:ref refID="subTabsInclude" />
                        </uix:subTabs>

                        <%-- START: TABLE GENERAL PAGE starts here --%>

                        <%-- START: General Info --%>
                        <uix:tableLayout cellSpacing="5" hAlign="center" width="75%">

                            <%-- Name --%>
                            <uix:rowLayout>
                                <uix:cellFormat hAlign="right">
                                    <uix:messagePrompt promptBinding="NAME@dbMsgs" required="yes" labeledNodeId="NAME"/>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left">
                                    <uix:stackLayout>
                                        <uix:textInput name="tableName" textBinding="tableName@objectBean@servletRequest" 
                                        columns="50" id="NAME" shortDescBinding="NAME@dbMsgs"/>
                                        <uix:messageText messageType="error" messageBinding="tableName@errors@servletRequest" />
                                    </uix:stackLayout>
                                </uix:cellFormat>
                            </uix:rowLayout>

                            <%-- Schema --%>
                            <uix:rowLayout>
                                <uix:cellFormat hAlign="right">
                                    <uix:messagePrompt promptBinding="SCHEMA@dbMsgs" labeledNodeId="SCHEMA"/>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left">
                                    <uix:lovField name="schemaName"
                                    id="SCHEMA" shortDescBinding="SCHEMA@dbMsgs"
                                    searchDescBinding="SCHEMA@dbMsgs"
                                    textBinding="schemaName@objectBean@servletRequest" 
                                    onClick="startLov('schemaName', 'ListSchema')" 
                                    disabledBinding="editing@objectBean@servletRequest"/>
                                </uix:cellFormat>
                            </uix:rowLayout>

                            <%-- Tablespace --%>
                            <uix:rowLayout>
                                <uix:cellFormat hAlign="right">
                                    <uix:messagePrompt promptBinding="TABLESPACE@dbMsgs" labeledNodeId="TABLESPACE"/>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left">
                                    <uix:contents>
                                        <uix:lovField name="tablespace"
                                        id="TABLESPACE" shortDescBinding="TABLESPACE@dbMsgs" 
                                        searchDescBinding="TABLESPACE@dbMsgs"
                                        textBinding="tablespace@objectBean@servletRequest" 
                                        onClick="startLov('tablespace', 'ListTablespaceAll')" 
                                        disabledBinding="disableTablespace@objectBean@servletRequest"/>
                                        <uix:switcher childNameBinding="creatingAndVersionHigher10@objectBean@servletRequest">
                                            <uix:case name="true">
                                                <uix:submitButton textBinding="ESTIMATE_TABLE_SIZE@dbMsgs"
                                                shortDescBinding="ESTIMATE_TABLE_SIZE@dbMsgs" 
                                                name="event" 
                                                value="<%= TableConst.J_ESTIMATE_SIZE %>"
                                                renderedBinding="defineUsingColumns@objectBean@servletRequest"/>
                                            </uix:case>
                                        </uix:switcher>
                                    </uix:contents>
                                </uix:cellFormat>
                            </uix:rowLayout>

                            <%-- Table Organization --%>

                            <uix:rowLayout>
                                <uix:cellFormat hAlign="right">
                                    <uix:messagePrompt promptBinding="ORG@tblMsgs"/>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left">
                                    <uix:styledText styleClass="OraDataText"
                                    textBinding="organizationHeader@objectBean@servletRequest" />
                                </uix:cellFormat>
                            </uix:rowLayout>

				
                            <%-- Wallet Status --%>
                <%-- 
                            <uix:rowLayout>
                                <uix:cellFormat hAlign="right">
                                    <uix:messagePrompt promptBinding="WALLET_STATUS@tblMsgs"/>
                                </uix:cellFormat>
                                <uix:cellFormat hAlign="left">
                                    <uix:styledText styleClass="OraDataText"
                                    textBinding="walletStatus@objectBean@servletRequest" />
                                </uix:cellFormat>
                            </uix:rowLayout>
				--%>
                            <%-- Temporary --%>
                            <uix:switcher childNameBinding="temporary@objectBean@servletRequest">
                                <uix:case name="true">
                                    <uix:rowLayout>
                                        <uix:cellFormat hAlign="right">
                                            <uix:messagePrompt promptBinding="TEMPORARY@tblMsgs" labeledNodeId="TEMPORARY"/>
                                        </uix:cellFormat>
                                        <uix:cellFormat hAlign="left">
                                            <uix:choice name="tempType" selectedValueBinding="tempType@objectBean@servletRequest" id="TEMPORARY"
                                                disabledBinding="editing@objectBean@servletRequest">
                                                <uix:option textBinding="SESSION@tblMsgs"
                                                value="<%= TableConst.TEMP_SESSION %>" />
                                                <uix:option textBinding="TRANSACTION@tblMsgs"         
                                                value="<%= TableConst.TEMP_TRANSACTION %>" />
                                            </uix:choice>
                                        </uix:cellFormat>  
                                    </uix:rowLayout>
                                </uix:case>
                            </uix:switcher>
                        </uix:tableLayout>
                        <%-- END: General Info --%>     

                        <%-- START: Table Definition --%>
                        <uix:switcher childNameBinding="editing@objectBean@servletRequest">

                            <%-- Case: Create Table --%>
                            <uix:case name="false">

                            <%-- Table Definition: Columns, SQL, Object Type --%>
                            <uix:stackLayout>
                                <%-- Define Using drop down and go button --%>

                                <uix:rowLayout hAlign="right">
                                    <uix:flowLayout>
                                        <uix:styledText textBinding="DEFINE_USING@tblMsgs" labeledNodeId="DEFINE_USING"
                                        styleClass="OraPromptText" />
                                        <uix:choice name="<%= TableConst.J_DEFINE_USING %>" id="DEFINE_USING"
                                            onChange="submitForm('tblForm', true, {'event':'defineUsing'})"
                                            shortDescBinding="DEFINE_USING@tblMsgs"
                                            selectedValueBinding="defineUsing@objectBean@servletRequest"
                                            disabledBinding="disabledDefinedUsing@objectBean@servletRequest">
                                            <uix:option textBinding="COLUMNS@tblMsgs"
                                            value="<%= TableConst.DEF_COLUMNS %>" />
                                            <uix:option textBinding="SQL@dbMsgs"         
                                            value="<%= TableConst.DEF_SQL %>" />
                                            <uix:switcher childNameBinding="xdbEnabled@servletRequest">
                                                <uix:case name="true">
                                                    <uix:option textBinding="XML_TYPE@tblMsgs"
                                                    value="<%= TableConst.DEF_XML_TYPE %>"
                                                    renderedBinding="xdbEnabled@servletRequest"/>
                                                </uix:case>
                                            </uix:switcher>
             
                       
                                            <%-- 
                                            <uix:option textBinding="OBJECT_TYPE@dbMsgs"
                                            value="<%= TableConst.DEF_OBJECT_TYPE %>" />
                                            --%> 
                                        </uix:choice>  
           
                                    </uix:flowLayout>
                                </uix:rowLayout>

                                <%-- Table Definition UI --%>
                                <uix:switcher childNameBinding="defineUsing@objectBean@servletRequest">
                                    <uix:case name="<%= TableConst.DEF_COLUMNS %>">
                                        <uix:dataScope currentDataBinding="tableColumnBean@servletRequest">
                                            <jsp:include page="/database/schema/table/generalColumnInclude.jsp" />
                                            <uix:ref refID="generalColumnInclude" />
                                        </uix:dataScope>
                                    </uix:case>   
                                    <uix:case name="<%= TableConst.DEF_SQL %>">
                                        <jsp:include page="/database/schema/table/generalSqlInclude.jsp" />
                                        <uix:ref refID="generalSqlInclude" />
                                    </uix:case>
          
                                    <uix:case name="<%= TableConst.DEF_XML_TYPE %>">
                                        <uix:dataScope currentDataBinding="XMLTypeTable_Bean@servletRequest">
                                            <jsp:include page="/database/schema/table/generalXmlTypeInclude.jsp" />
                                            <uix:ref refID="generalXmlTypeInclude" />
                                        </uix:dataScope>
                                    </uix:case>
          
                                    <%--
                                    <uix:case name="<%= TableConst.DEF_OBJECT_TYPE %>">
                                    <jsp:include page="/database/schema/table/generalObjectTypeInclude.jsp" />
                                    <uix:ref refID="generalObjectTypeInclude" />
                                    </uix:case>     
                                    --%>
                                </uix:switcher>
                            </uix:stackLayout>
                            </uix:case>

                            <%-- Case: Edit Table --%>
                            <uix:case name="true">
                                <uix:rowLayout width="100%">
                                    <uix:switcher childNameBinding="defineUsing@objectBean@servletRequest" defaultCase="defCase">
                                        <uix:case name="<%= TableConst.DEF_XML_TYPE %>">
                                            <uix:dataScope currentDataBinding="XMLTypeTable_Bean@servletRequest">
                                                <jsp:include page="/database/schema/table/generalXmlTypeInclude.jsp" />
                                                <uix:ref refID="generalXmlTypeInclude" />
                                            </uix:dataScope>
                                        </uix:case>
                                        <uix:case name="defCase">
                                            <uix:dataScope currentDataBinding="tableColumnBean@servletRequest">
                                                <jsp:include page="/database/schema/table/generalColumnInclude.jsp" />
                                                <uix:ref refID="generalColumnInclude" />
                                            </uix:dataScope>
                                        </uix:case>
                                    </uix:switcher>
                                </uix:rowLayout>
                            </uix:case>     

                        </uix:switcher>
                        <%-- END: Table Definition --%>    


                        <%-- END: TABLE GENERAL PAGE ends here --%>   
        
                    </uix:subTabLayout>  

                    <%-- Table Buttons --%>
                    <uix:pageButtons>
                        <uix:pageButtonBar>
                            <jsp:include page="/database/schema/pageButtonInclude.jsp" />
                            <uix:ref refID="pageButtonInclude" />
                        </uix:pageButtonBar>
                    </uix:pageButtons>

                </uix:pageLayout>
            </db:form>
            <%-- END: HTML Form --%>
        </uix:body>

    </uix:document>
</uix:renderingContext>
<%-- END: Content --%>
