<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>
<%-- Imports --%>
<%@ page import="oracle.sysman.emo.adm.schema.table.XmlTypeConstants" %>

<%-- COLUMN TABLE DEFINITION --%>

<uix:buildTree nodeID="generalXmlTypeInclude">
    <uix:dataScope>
         <db:script src="/database/utils.js"/>   <%-- lovField support --%>
         <db:script src="/database/LOV.js" />
        <%-- Message Bundles --%>
        <uix:bundle name="xschMsg" class="oracle.sysman.db.rsc.xdb.XDBSchemaMsg"/>
        <uix:bundle name="tblMsgs" class="oracle.sysman.db.rsc.schm.TableMsg"/>
        <uix:tableLayout>
            <uix:stackLayout>
                <uix:header textBinding="XML_TYPE@tblMsgs">
                    <uix:contents>
                        <uix:header textBinding="XML_SCHEMA_DETAILS@xschMsg">
                            <uix:contents>
								<uix:rowLayout>
									<uix:spacer width="10"/>
								</uix:rowLayout>
								<uix:rowLayout>
									<uix:messagePrompt promptBinding="XML_SCHEMA_TYPE@xschMsg" />
									<uix:spacer width="10"/>
									<uix:messageChoice
										name="<%=XmlTypeConstants.XML_SCHEMA_TYPE %>"
										id="<%=XmlTypeConstants.XML_SCHEMA_TYPE %>"
										shortDescBinding="XML_SCHEMA_TYPE@xschMsg"
										selectedValueBinding="xmlSchemaType@"
                                        disabledBinding="xmlTypeTableEditing@objectBean@servletRequest"
										onChange="submitForm('tblForm', true, {'event':'xmlSchemaSelected'})">
										<uix:option textBinding="NON_SCHEMA_BASED@xschMsg"
											value="<%=XmlTypeConstants.SCHEMA_BASED_NONE %>" />
										<uix:option textBinding="SCHEMA_BASED@xschMsg"
											value="<%=XmlTypeConstants.SCHEMA_BASED_ONE %>" />
										<uix:option textBinding="ANY_SCHEMA_BASED@xschMsg"
											value="<%=XmlTypeConstants.SCHEMA_BASED_ANY %>" />
									</uix:messageChoice>
								</uix:rowLayout>
								
                                <uix:switcher childNameBinding="oneSchema@">
                                    <uix:case name="true">
                                        <uix:tableLayout hAlign="center" width="70%" cellSpacing = "5">
                                            <uix:contents>
                                                 <uix:header textBinding="SELECT_XML_SCHEMA@xschMsg">
                                                    <uix:contents>
													<uix:styledText styleClass="OraInstructionText" textBinding="XML_SCHEMA_INSTR@xschMsg"/>
                                                        <uix:tableLayout cellSpacing="5">
                                                            <uix:contents>
                                                                <uix:rowLayout>
                                                                    <uix:contents>
                                                                        <uix:cellFormat hAlign="right" wrappingDisabled="true">
                                                                            <uix:contents>
                                                                                <uix:styledText styleClass="OraInstructionText" textBinding="XML_SCHEMA@xschMsg" labeledNodeId="schemaURL"/>
                                                                            </uix:contents>
                                                                        </uix:cellFormat>
                                                                        <uix:cellFormat hAlign="left" wrappingDisabled="true">
                                                                            <uix:contents>
                                                                                <uix:messageLovField columns="65"
                                                                                name="schemaURL"
                                                                                id="schemaURL"
                                                                                textBinding="completeXmlSchema@"
                                                                                shortDescBinding="XML_SCHEMA@xschMsg"
                                                                                searchDescBinding="XML_SCHEMA@xschMsg"
                                                                                disabledBinding="xmlTypeTableEditing@objectBean@servletRequest"
                                                                                onClick="setWindowSize(800,600);preserveCase();startLov('schemaURL','ListOwnerXmlSchema')"
                                                                                tipBinding="ERR_PARSE_XML_SCHEMA@xschMsg"
                                                                                />
                                                                            </uix:contents>
                                                                        </uix:cellFormat>
                                                                          <uix:cellFormat hAlign="left" wrappingDisabled="true" >
                                                                            <uix:contents>
                                                                                <uix:submitButton textBinding="PARSE_XML_SCHEMA@xschMsg"
                                                                                shortDescBinding="PARSE_XML_SCHEMA@xschMsg"
                                                                                renderedBinding="createOrNew@"
                                                                                name="event" value="parse_schema"/>
                                                                            </uix:contents>
                                                                        </uix:cellFormat>                                                                              
                                                                    </uix:contents>
                                                                </uix:rowLayout>
                                                                <uix:switcher childNameBinding="showStorageOptionsToggle@">
                                                                    <uix:case name="<%= XmlTypeConstants.SCHEMA_PARSING_DONE %>">
                                                    
                                                                        <uix:rowLayout>
                                                                            <uix:contents>
                                                                                <uix:cellFormat hAlign="right">
                                                                                    <uix:contents>
                                                                                        <uix:styledText styleClass="OraInstructionText" textBinding="ELEMENT@xschMsg"/>
                                                                                    </uix:contents>
                                                                                </uix:cellFormat>
                                                                                
                                                                                    
                                                                                        <uix:cellFormat hAlign="left">
                                                                                            <uix:contents>
                                                                                                <uix:switcher childNameBinding="createOrNew@">
                                                                                                <uix:case name="true">
                                                                                                <oem:choice name="schemaElement" optionsBinding="elementCollection@XMLTypeTable_Bean@servletRequest" selectedValueBinding = "schemaElement@" shortDescBinding="ELEMENT@xschMsg"/>
                                                                                                </uix:case>
                                                                                                <uix:case name="false">
                                                                                                <uix:styledText styleClass="OraDataText" textBinding="schemaElement@XMLTypeTable_Bean@servletRequest"/>
                                                                                                </uix:case>
                                                                                                </uix:switcher>
                                                                                            </uix:contents>
                                                                                       </uix:cellFormat>
                                                                                    
                                                                                    
                                                                            </uix:contents>
                                                                            
                                                                        </uix:rowLayout>
                                                                    </uix:case>
                                                            
                                                                </uix:switcher>


                                                            </uix:contents>
                                                        </uix:tableLayout>
                                    
                                                    </uix:contents>
                                                </uix:header>
                                             </uix:contents>
                                        </uix:tableLayout>
                                    </uix:case>
                                </uix:switcher>         
                            </uix:contents>
                        </uix:header>
                        <jsp:include page="/database/schema/table/generalSubXmlInclude.jsp" />
				    	<uix:ref refID="generalSubXmlInclude" />
                    </uix:contents>
                </uix:header>
            </uix:stackLayout>
        </uix:tableLayout>
    </uix:dataScope>    
</uix:buildTree>

