<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%--
  -- Page:       indexesPage.jsp
  -- Controller: db/adm/schm/TableController.java
  --
  -- Description: The Index tab for Table.  
  --              This tab allows the user to view
  --              indexes on this table
  --%>


<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<db:script src="/database/utils.js"/>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>
<%@ page import="oracle.sysman.emo.util.UIXDataSource" %>
<uix:renderingContext id="renderingContext">
  <uix:bundle name="dbMsgs"
              class="oracle.sysman.db.rsc.DBObjectMsg"/>
  <uix:bundle name="indMsgs"
              class="oracle.sysman.db.rsc.schm.IndexMsg"/>
<oem:setURLEncoder id="renderingContext"/>
<uix:document>
  
<%-- HTML Page Title --%>
<%-- Fix Bug 4080599, for future release
<%@ include file="/oemTitle.jspf" %>
--%>
<uix:metaContainer>
  <uix:head titleBinding="title@objectBean@servletRequest"/>
</uix:metaContainer>

<%-- HTML Form --%>
<uix:body> 
<db:form name="tblForm"
         method="post" 
         destinationBinding="destination@objectBean@servletRequest"
         copyParams="target,type,cancelURL,sname,oname,otype">
<uix:formValue name="pageName" value="<%= SchemaPages.TBL_INDEXES_PG %>"/>
<uix:formValue name="source"/>
<uix:pageLayout titleBinding="header@objectBean@servletRequest">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>

  <%-- Create/Edit/View Header --%>
  <uix:subTabLayout>
    
    <%-- Table SubTabs --%>
    <uix:subTabs>
      <jsp:include page="/database/schema/table/subTabsInclude.jsp" />
      <uix:ref refID="subTabsInclude" />
    </uix:subTabs>

    <%-- START: TABLE OPTIONS PAGE starts here --%>
    <uix:tableLayout hAlign="center" width="100%">
      <uix:dataScope currentDataBinding="indexesDS@servletRequest">
        <uix:rowLayout>
          <uix:spacer height="10"/>
        </uix:rowLayout>
        <uix:rowLayout>
          <uix:labeledFieldLayout columns="1">
            <uix:messageStyledText 
                    promptBinding="NUMBER_OF_INDEXES@uixDBObjectBundle@servletRequest"
                    shortDescBinding="NUMBER_OF_INDEXES@uixDBObjectBundle@servletRequest"
                    textBinding="numIndexes@"
                    contentStyleClass="OraDataText"/>
          </uix:labeledFieldLayout>
        </uix:rowLayout>
        <uix:rowLayout>
          <uix:spacer height="10"/>
        </uix:rowLayout>
        <uix:rowLayout>
          <uix:cellFormat>
            <jsp:include page="/database/schema/table/tableIndexesInclude.jsp"/>
            <uix:ref refID="tableIndexesInclude"/>
          </uix:cellFormat>
        </uix:rowLayout>
        <uix:rowLayout>
          <uix:spacer height="20"/>
        </uix:rowLayout>
      </uix:dataScope> 
    </uix:tableLayout> 
    <%-- END: TABLE OPTIONS PAGE ends here --%>

  </uix:subTabLayout>  

  <%-- Table Buttons --%>
  <uix:pageButtons>
  <uix:pageButtonBar>
    <jsp:include page="/database/schema/pageButtonInclude.jsp" />
    <uix:ref refID="pageButtonInclude" />
  </uix:pageButtonBar>
  </uix:pageButtons>

</uix:pageLayout>
</db:form>
</uix:body>
<%-- END: HTML Form --%>

</uix:document>
</uix:renderingContext>
<%-- END: Content --%>
