<%@ include file="/sdk/oemTop.jspf" %>
<%--
  -- Page:       iotStoragePage.jsp
  -- Controller: db/adm/schm/TableController.java
  --
  -- Description: The Storage button for IOT tab for Table.  
  --%>

<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>
<%@ page import="oracle.sysman.emo.adm.schema.table.TableConst" %>
<NOSCRIPT>
A browser with Javascript enabled is required for this page to operate properly.
</NOSCRIPT>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>
<uix:document>
  
<%-- HTML Page Title --%>
<uix:metaContainer>
  <uix:head titleBinding="IOT_STORAGE@uixTableBundle@servletRequest"/>
</uix:metaContainer>

<%-- HTML Form --%>
<db:form name="tblForm"
         method="post" 
         destinationBinding="destination@objectBean@servletRequest"
         copyParams="target,type,cancelURL,sname,oname,otype">
<uix:formValue name="pageName" value="<%= SchemaPages.TBL_IOTSTORAGE_PG %>"/>
<uix:pageLayout titleBinding="IOT_STORAGE@uixTableBundle@servletRequest">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errorsIOTStoragePage@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>

  <%-- Create/Edit/View Header --%>
  <uix:subTabLayout>

    <%-- START: TABLE STORAGE PAGE starts here --%>
    <uix:dataScope currentDataBinding="iotSegment@servletRequest">
      <jsp:include page="/database/schema/utilities/storageContextInclude.jsp" />
      <uix:ref refID="storageInclude" />
    </uix:dataScope>
    <%-- END: TABLE STORAGE PAGE ends here --%>   
        
  </uix:subTabLayout>  

  <%-- Table Buttons --%>
  <uix:pageButtons>
  <uix:pageButtonBar>
    <uix:submitButton textBinding="CANCEL@uixDBObjectBundle@servletRequest" 
                          name="event" 
                          value="<%= TableConst.J_IOT_STORAGE_CANCEL %>" />
    <uix:submitButton textBinding="OK@uixDBObjectBundle@servletRequest" 
                      name="event" 
                      value="<%= TableConst.J_IOT_STORAGE_OK %>" />
  </uix:pageButtonBar>
  </uix:pageButtons>
</uix:pageLayout>
</db:form>
<%-- END: HTML Form --%>

</uix:document>
</uix:renderingContext>
<%-- END: Content --%>
