<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%--
  -- Page:       optionsPage.jsp
  -- Controller: db/adm/schm/TableController.java
  --
  -- Description: The Options tab for Table.  
  --              This tab allows the user to see/edit 
  --              various options for the table object.
  --%>


<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<db:script src="/database/utils.js"/>

<script language="javascript">
function setParallel()
{
  if (document.forms[0].parallel != null)
  {
    document.forms[0].defaultDegree[0].disabled = !document.forms[0].parallel.checked;
    document.forms[0].defaultDegree[1].disabled = !document.forms[0].parallel.checked;
    document.forms[0].degree.disabled = (document.forms[0].defaultDegree[0].checked || document.forms[0].defaultDegree[0].disabled);
  }
}
</script>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.adm.schm.SchemaPages" %>
<%@ page import="oracle.sysman.emo.adm.schema.table.TableConst" %>
<%@ page import="oracle.sysman.emo.adm.schema.SchemaObjectSegmentAttributes" %>
<uix:renderingContext id="renderingContext">
  <uix:bundle name="msgs"
              class="oracle.sysman.db.rsc.schm.PartitionsMsg"/>
<oem:setURLEncoder id="renderingContext"/>
<uix:document>
  
<%-- HTML Page Title --%>
<%-- Fix Bug 4080599, for future release
<%@ include file="/oemTitle.jspf" %>
--%>
<uix:metaContainer>
  <uix:head titleBinding="OPTIONS_TITLE@uixTableBundle@servletRequest"/>
</uix:metaContainer>

<%-- HTML Form --%>
<uix:body onLoad="setParallel()">
<db:form name="tblForm"
         method="post" 
         destinationBinding="destination@objectBean@servletRequest"
         copyParams="target,type,cancelURL,sname,oname,otype">
<uix:formValue name="pageName" value="<%= SchemaPages.TBL_OPTIONS_PG %>"/>
<uix:pageLayout titleBinding="header@objectBean@servletRequest">

  <%-- Oracle Logo and Tabs --%>
  <%@ include file="/database/global.jspf" %>

  <%-- Warning/Error display --%>
  <oem:messageBox messageType="info" 
                  errorTableBinding="info@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>
  <oem:messageBox messageType="error" 
                  errorTableBinding="errors@servletRequest"
                  titleTextKey="titleText" mainTextKey="mainText"/>

  <%-- Create/Edit/View Header --%>
  <uix:subTabLayout>
    
    <%-- Table SubTabs --%>
    <uix:subTabs>
      <jsp:include page="/database/schema/table/subTabsInclude.jsp" />
      <uix:ref refID="subTabsInclude" />
    </uix:subTabs>

    <%-- START: TABLE OPTIONS PAGE starts here --%>
    <uix:stackLayout>

      <uix:spacer height="10"/>

        <%-- Row Movement --%>
        <uix:messageChoice name="rowMovement" 
                    promptBinding="ROW_MOVEMENT@uixTableBundle@servletRequest"
                    selectedValueBinding="rowMovement@objectBean@servletRequest"
                    disabledBinding="rowMovementDisabled@objectBean@servletRequest">
          <uix:option textBinding="DEFAULT_OPT@uixDBObjectBundle@servletRequest"
                            value="<%= TableConst.ROW_MOVEMENT_DEFAULT %>" />
          <uix:option textBinding="YES@uixDBObjectBundle@servletRequest"
                            value="<%= TableConst.ROW_MOVEMENT_ENABLED %>" />
          <uix:option textBinding="NO@uixDBObjectBundle@servletRequest"         
                            value="<%= TableConst.ROW_MOVEMENT_DISABLED %>" />
        </uix:messageChoice>

      <%-- Parallel Option --%>
      <uix:spacer height="5" />
      <uix:checkBox name="parallel"
                    checkedBinding="parallel@objectBean@servletRequest" 
                    textBinding="PARALLEL_OPTION@uixTableBundle@servletRequest"
                    onClick="setParallel()" />
      <uix:flowLayout>
        <uix:spacer width="21" height="1" />
        <uix:styledText styleClass="OraPromptText" labeledNodeId="PARALLEL_DEGREE"
                        textBinding="PARALLEL_DEGREE@uixTableBundle@servletRequest"/>
        <uix:spacer width="5"/>
        <oem:radioButton name="defaultDegree" 
                         value="true" 
                         textBinding="DEFAULT@uixDBObjectBundle@servletRequest"
                         onClick="setParallel()" 
                         selectedValueBinding="defaultDegree@objectBean@servletRequest"/>
        <uix:spacer width="5" />
        <oem:radioButton name="defaultDegree"
                         value="false"
                         textBinding="VALUE@uixDBObjectBundle@servletRequest" 
                         onClick="setParallel()" 
                         selectedValueBinding="defaultDegree@objectBean@servletRequest"/>
        <uix:spacer width="5" />
        <uix:textInput name="degree" id="PARALLEL_DEGREE"
                       textBinding="degree@objectBean@servletRequest" 
                       columns="10">
          <uix:onSubmitValidater><uix:decimal /></uix:onSubmitValidater>
        </uix:textInput>
      </uix:flowLayout>

      <%-- Cache --%>
      <uix:spacer height="5" 
                  renderedBinding="standardOrg@objectBean@servletRequest" />
      <uix:checkBox name="cache" 
                    checkedBinding="cache@objectBean@servletRequest" 
                    textBinding="CACHE_OPTION@uixTableBundle@servletRequest" 
                    renderedBinding="standardOrg@objectBean@servletRequest" />

      <%-- Monitoring --%>
      <uix:spacer height="5"
                  renderedBinding="monitoringAvailable@objectBean@servletRequest" />
      <uix:checkBox name="monitoring" 
                    checkedBinding="monitoring@objectBean@servletRequest" 
                    textBinding="MONITOR_OPTION@uixTableBundle@servletRequest" 
                    renderedBinding="monitoringAvailable@objectBean@servletRequest"/>

    </uix:stackLayout>
    <%-- END: TABLE OPTIONS PAGE ends here --%>

  </uix:subTabLayout>  

  <%-- Table Buttons --%>
  <uix:pageButtons>
  <uix:pageButtonBar>
    <jsp:include page="/database/schema/pageButtonInclude.jsp" />
    <uix:ref refID="pageButtonInclude" />
  </uix:pageButtonBar>
  </uix:pageButtons>

</uix:pageLayout>
</db:form>
</uix:body>
<%-- END: HTML Form --%>

</uix:document>
</uix:renderingContext>
<%-- END: Content --%>
