<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:buildTree nodeID="partitionsViewInclude">
  <uix:tableLayout>
    <uix:switcher childNameBinding="partitioned@objectBean@servletRequest">
      <uix:case name="true">
        <uix:header textBinding="PDESC@msgs">
          <uix:rowLayout>
            <uix:cellFormat hAlign="right" width="180">
              <uix:styledText styleClass="OraFieldText"
                              textBinding="PMETHOD@msgs"/>
            </uix:cellFormat>
            <uix:cellFormat>
              <uix:spacer width="5"/>
            </uix:cellFormat>
            <uix:styledText styleClass="OraDataText"
                            textBinding="displayType@dataPartitionsBean@servletRequest"/>
          </uix:rowLayout>

          <uix:rowLayout>
            <uix:cellFormat hAlign="right" width="180">
              <uix:styledText styleClass="OraFieldText"
                              textBinding="PCOLS@msgs"/>
            </uix:cellFormat>
            <uix:cellFormat>
              <uix:spacer width="5"/>
            </uix:cellFormat>
            <uix:styledText styleClass="OraDataText"
                            textBinding="pcolsList@partitionColsBean@servletRequest"/>
          </uix:rowLayout>

          <uix:rowLayout>
            <uix:cellFormat hAlign="right" width="180">
              <uix:styledText styleClass="OraFieldText"
                              textBinding="NUMPARTS@msgs"/>
            </uix:cellFormat>
            <uix:cellFormat>
              <uix:spacer width="5"/>
            </uix:cellFormat>

            <uix:switcher childNameBinding="showLinks@dataPartitionSubPartitionBean@servletRequest">
              <uix:case name="true">
                <db:link textBinding="numberPartitions@dataPartitionsBean@servletRequest"
                         onClick="submitForm('tblForm', true, {event:'showPartDetails'})" 
                         copyParams="target,type,cancelURL,sname,oname,otype" />
              </uix:case>
              <uix:case name="false">
                <uix:styledText styleClass="OraDataText"
                                textBinding="numberPartitions@dataPartitionsBean@servletRequest"/>
              </uix:case>
            </uix:switcher>
          </uix:rowLayout>

          <uix:switcher childNameBinding="isComposite@dataPartitionsBean@servletRequest">
            <%-- CASE: Composite partitions --%>
            <uix:case name="true">
              <uix:rowLayout>
                <%-- SWITCH: Range-Hash or Range-List type --%>
                <uix:cellFormat hAlign="right" width="180">
                  <uix:switcher childNameBinding="selectedTypeInt@dataPartitionsBean@servletRequest">
                    <%-- CASE: Range-Hash partitions --%>
                    <uix:case name="3">
                      <uix:styledText styleClass="OraFieldText"
                                             textBinding="SCOLS@msgs"/>
                    </uix:case>
                    <%-- CASE: Range-List partitions --%>
                    <uix:case name="4">
                      <uix:styledText styleClass="OraFieldText"
                                           textBinding="SCOL@msgs"/>
                    </uix:case>
                  </uix:switcher>
                </uix:cellFormat>
                <uix:cellFormat>
                  <uix:spacer width="5"/>
                </uix:cellFormat>
                <uix:cellFormat>
                  <uix:styledText styleClass="OraDataText"
                                  textBinding="scolsList@partitionColsBean@servletRequest" />
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:case>
          </uix:switcher>

          <uix:switcher childNameBinding="isComposite@dataPartitionsBean@servletRequest">
            <%-- CASE: Composite partitions --%>
            <uix:case name="true">
              <uix:rowLayout>
                <uix:cellFormat hAlign="right" width="180">
                  <uix:styledText styleClass="OraFieldText"
                                  textBinding="NUMSUBPARTS@msgs"/>
                </uix:cellFormat>
                <uix:cellFormat>
                  <uix:spacer width="5"/>
                </uix:cellFormat>

                <%-- LINK OF REACH MAXIMUM --%>
                <uix:switcher childNameBinding="showLinks@dataPartitionSubPartitionBean@servletRequest">
                  <uix:case name="true">
                    <db:link textBinding="numSubpartitions@dataPartitionSubPartitionBean@servletRequest"
                             onClick="submitForm('tblForm', true, {event:'showSubPartDetails'})" 
                             copyParams="target,type,cancelURL,sname,oname,otype" />
                  </uix:case>
                  <uix:case name="false">
                    <uix:styledText styleClass="OraDataText"
                                    textBinding="numSubpartitions@dataPartitionSubPartitionBean@servletRequest"/>
                  </uix:case>
                </uix:switcher>
                <%-- END LINK OF REACH MAXIMUM --%>
              </uix:rowLayout>
            </uix:case>
          </uix:switcher>
      </uix:header> <%-- end PDESC header --%>
    </uix:case>
  </uix:switcher>

  <uix:switcher childNameBinding="showLinks@dataPartitionSubPartitionBean@servletRequest">
    <uix:case name="false">
      <uix:switcher childNameBinding="partitioned@objectBean@servletRequest">
        <uix:case name="true">
          <uix:spacer height="15"/>
          <uix:switcher childNameBinding="showPartitions@defaultBean@servletRequest">
            <uix:case name="0">
              <uix:tableLayout>
              <uix:header textBinding="PARTS@msgs">
                <oem:table name="dataPartitionsUI"
                           beanKey="dataPartitionsBean"
                           formSubmitted="true"
                           dataSourceProp="dataPartitionsUI"
                           width="80%"
                           alternateTextBinding="NO_PARTS@msgs"
                           copyParams="target,type,cancelURL,sname,oname,otype" />
              </uix:header>
              <uix:switcher childNameBinding="hasSubpartitions@dataPartitionSubPartitionBean@servletRequest">
                <uix:case name="true">
                  <uix:header textBinding="SUBPARTSHDR@msgs">
                    <oem:table name="dataPartitionsUI"
                               beanKey="dataPartitionSubPartitionBean"
                               formSubmitted="true"
                               dataSourceProp="dataPartitionsUI"
                               width="80%"
                               alternateTextBinding="NO_PARTS@msgs"
                               copyParams="target,type,cancelURL,sname,oname,otype" />
                  </uix:header>
                </uix:case>
              </uix:switcher>
              </uix:tableLayout>
            </uix:case>
            <uix:case name="1">
              <uix:tableLayout>
              <uix:header textBinding="PARTS@msgs">
                <oem:table name="dataPartitionsUI"
                           blockSize="25"
                           beanKey="dataPartitionsBean"
                           formSubmitted="true"
                           dataSourceProp="dataPartitionsUI"
                           width="80%"
                           alternateTextBinding="NO_PARTS@msgs"
                           copyParams="target,type,cancelURL,sname,oname,otype" />
              </uix:header>
              </uix:tableLayout>
            </uix:case>
            <uix:case name="2">
              <uix:tableLayout>
              <uix:switcher childNameBinding="hasSubpartitions@dataPartitionSubPartitionBean@servletRequest">
                <uix:case name="true">
                  <uix:header textBinding="SUBPARTSHDR@msgs">
                    <oem:table name="dataPartitionsUI"
                               blockSize="25"
                               beanKey="dataPartitionSubPartitionBean"
                               formSubmitted="true"
                               dataSourceProp="dataPartitionsUI"
                               width="80%"
                               alternateTextBinding="NO_PARTS@msgs"
                               copyParams="target,type,cancelURL,sname,oname,otype" />
                  </uix:header>
                </uix:case>
              </uix:switcher>
              </uix:tableLayout>
            </uix:case>
          </uix:switcher>
        </uix:case>
        <uix:case name="false">
          <oem:table name="dataPartitionsUI"
                     beanKey="dataPartitionsBean"
                     formSubmitted="true"
                     dataSourceProp="dataPartitionsUI"
                     width="80%"
                     alternateTextBinding="NO_PARTS@msgs"
                     copyParams="target,type,cancelURL,sname,oname,otype" />
        </uix:case>
      </uix:switcher>
    </uix:case>
  </uix:switcher>

</uix:tableLayout>
</uix:buildTree>
<%-- END PARTITIONS TAB --%>

