<%--
  -- Page:       statsInclude.jsp
  -- Controller: db/adm/schm/TableController.java
  -- 
  -- Description: Shows all table stats.  Used for View and Edit.
  --%>

<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:buildTree nodeID="statsInclude">

<%-- Define Msg Bundles --%>
<uix:dataScope>

  <%-- Msg Bundles --%>
  <uix:bundle name="schmMsgs" class="oracle.sysman.db.rsc.schm.SchemaMsg"/>
  <uix:bundle name="partMsgs" class="oracle.sysman.db.rsc.schm.PartitionsMsg"/>
  <uix:bundle name="dbMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
    
  <%-- START: Content --%>
  <uix:labeledFieldLayout>

      <%-- Last Analyzed --%>
      <uix:messagePrompt promptBinding="LAST_ANALYZED@dbMsgs"/>
      <uix:styledText styleClass="OraDataText"
                      textBinding="lastAnalyzed@objectBean@servletRequest" />
 
      <%-- Empty Blocks --%>
      <uix:messagePrompt promptBinding="EMPTY_BLOCKS@partMsgs"/>
      <uix:styledText styleClass="OraDataText"
                      textBinding="emptyBlocks@objectBean@servletRequest" />
  
      <%-- Average Space --%>
      <uix:messagePrompt promptBinding="AVG_SPACE_BYTES@partMsgs"/>
      <uix:styledText styleClass="OraDataText"
                      textBinding="avgSpace@objectBean@servletRequest" />
 
      <%-- Number of Rows --%>
      <uix:messagePrompt promptBinding="NUM_ROWS@partMsgs"/>
      <uix:styledText styleClass="OraDataText"
                      textBinding="numRows@objectBean@servletRequest" />
  
      <%-- Sample Size --%>
      <uix:messagePrompt promptBinding="SAMPLE_SIZE@partMsgs"/>
      <uix:styledText styleClass="OraDataText"
                      textBinding="sampleSize@objectBean@servletRequest" />

      <%-- Average Row Length --%>
      <uix:messagePrompt promptBinding="AVG_ROW_LEN_BYTES@partMsgs"/>
      <uix:styledText styleClass="OraDataText"
                      textBinding="avgRowLen@objectBean@servletRequest" />

      <%-- Continued Row Count --%>
      <uix:messagePrompt promptBinding="CHAIN_CNT@partMsgs"/>
      <uix:styledText styleClass="OraDataText"
                      textBinding="chainCnt@objectBean@servletRequest" />

      <%-- Average Space Freelist Blocks --%>
      <uix:messagePrompt promptBinding="AVG_SPC_FREELIST_BLKS@schmMsgs"/>
      <uix:styledText styleClass="OraDataText"
                      textBinding="avgSpaceFreelistBlocks@objectBean@servletRequest" />

      <%-- Number of Freelist Blocks --%>
      <uix:messagePrompt promptBinding="NUM_FREELIST_BLKS@schmMsgs"/>
      <uix:styledText styleClass="OraDataText"
                      textBinding="numFreelistBlocks@objectBean@servletRequest" />
    
    </uix:labeledFieldLayout>
    <%-- END: Content --%>

</uix:dataScope>
</uix:buildTree>
